/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ytjV
 */

// forked from sakef's ランダムテキストのサンプル
/*
    よく見るランダムテキストの練習。
    
    umi_kappaがコメントを付け足しました。
    ふぅー
*/

package
{
    import flash.display.Sprite;

    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="40")]
    
    public class RandomTextSample extends Sprite
    {
        /*
          コンストラクタ
        */
        public function RandomTextSample()
        {
            var rand1:RandomText = new RandomText("Wonderfl build flash online.");
            addChild(rand1);
            rand1.x = 20;
            rand1.y = 20;
        }
    }
}

import flash.display.Sprite;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.Timer;
import flash.events.MouseEvent;

class RandomText extends Sprite
{
    //ランダムに表示させたい文字
    private var RandSource:String = "_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    //最終的に表示させたい文字
    private var MainString:String;
    private var Length:int;
    //表表示されている本物の文字数
    private var ReplaceCount:int;
    //文字列が本物に戻る間隔
    private var ReplaceTimer:Timer;
    //文字列をランダムに切り替えるときの間隔
    private var RandomTimer:Timer;
    //テキストフィールド
    private var MainTextField:TextField;
    
    /*
      コンストラクタ
    */
    public function RandomText(main_string:String)
    {
        //本物の文字をセット
        MainString = main_string;
        //文字数
        Length = MainString.length;
        
        //TextField
        MainTextField = new TextField();
        MainTextField.defaultTextFormat = new TextFormat(null, 17, 0x000000);
        MainTextField.text = MainString;
        MainTextField.autoSize = TextFieldAutoSize.LEFT;
        addChild(MainTextField);
        //MouseEvent
        MainTextField.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        MainTextField.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
        //ランダム時の間隔
        RandomTimer=new Timer(10);
        RandomTimer.addEventListener(TimerEvent.TIMER, onRandomTimer);
        
        //本物の文字列が出る間隔
        ReplaceTimer = new Timer(10);
        ReplaceTimer.addEventListener(TimerEvent.TIMER, onReplaceTimer);
    }
    
    /*
      MouseOver = ランダムスタート
    */
    private function onMouseOver(e:MouseEvent):void
    {
        if (ReplaceTimer.running) 
        {
            //ランダムに表表示させるのは終わり。
            ReplaceTimer.stop();
        }
        //本物の文字を表示させていくよ。
        RandomTimer.start();
    }
    
    private function onRandomTimer(e:TimerEvent):void
    {
        //文字列の初期化
        MainTextField.text="";
        for(var i:int=0; i < Length; i++) 
        {
            //ランダムな文字列にする
            MainTextField.appendText(RandSource.charAt(Math.floor(Math.random() * (RandSource.length - 1))));
        }
    }
    
    /*
      MouseOut = ランダム終了。徐々に文字を表示
    */
    private function onMouseOut(e:MouseEvent):void
    {
        //タイマーが走っていたら止める
        if(RandomTimer.running) RandomTimer.stop();
        //本物のすでに表示済みの文字数を初期化
        ReplaceCount = 0;
        //タイマースタート
        ReplaceTimer.start();
    }

    private function onReplaceTimer(e:TimerEvent):void
    {
        //文字列の初期化
        MainTextField.text = "";
        var strNum:int = 0;
        var i:int = 0;
        for(i=0; i < ReplaceCount; i++) 
        {
            //本物の文字を入れる
            MainTextField.appendText(MainString.charAt(i));
        }
        
        for(i=0; i < Length - ReplaceCount; i++) 
        {
            //ランダム番目の文字を入れる
            strNum = Math.floor(Math.random() * (RandSource.length - 1));
            MainTextField.appendText(RandSource.charAt(strNum));
        }
        
        //全て本物になったらタイマーを止める
        if(ReplaceCount==Length) ReplaceTimer.stop();
        //本物の文字が1文字増えたよ
        ReplaceCount++;
    }
}