/**
 * Copyright k2xl.com ( http://wonderfl.net/user/k2xl.com )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ytQj
 */

package {
    import flash.utils.Proxy;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var pts:Vector.<Dot>;
        private var midPt:Point;
        private var deleteMode:Boolean;
        public function FlashTest() {
            inittrace(stage);
            
            midPt = new Point(stage.stageWidth/2,stage.stageHeight/2);
            pts = new Vector.<Dot>();
            createPoints();
            reorder();
            drawScreen();
            stage.addEventListener(MouseEvent.CLICK,onClick);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
        }
        public function createPoints(numPts:int = 10):void
        {
            for (var j:int = 0; j < numPts; j++)
            {
                pts.push(new Dot(new Point(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight)));
            }
        }

        public function onKeyDown(e:KeyboardEvent):void
        {
            if (e.keyCode == Keyboard.CONTROL)
            {
                deleteMode = true;
            }
        }
        public function onKeyUp(e:KeyboardEvent):void
        {
            deleteMode = false;
        }
        public function getClosestDotTo(killpt:Point):Dot
        {
            var minDist:Number = 999999;
            var minDot:Dot = null;
            var numPts:int = pts.length;
            for (var j:int = 0; j < numPts; j++)
            {
                var tempDot:Dot = pts[j];
                var tempDis:Number = tempDot.distTo(killpt);
                if (tempDis < minDist)
                {
                    minDist = tempDis;
                    minDot = pts[j];
                }
            }
            return minDot;
        }
        public function removeDot(dot:Dot):void
        {
            var temp:Vector.<Dot> = new Vector.<Dot>;
            var numDots:int = pts.length;
            // Using normal for loop rather than for each will prevent having to call reorder after deletion
            // not sure if for each guarranties any order
            for (var j:int = 0; j < numDots; j++)
            {
                if (pts[j] != dot)
                    temp.push(pts[j]);
            }
            pts = temp;
        }

        public function onClick(e:MouseEvent):void
        {
            var clickedPt:Point = new Point(e.stageX,e.stageY);
            if (deleteMode)
                removeDot(getClosestDotTo(clickedPt));
            else
                pts.push(new Dot(clickedPt));
            reorder();
            drawScreen();
        }
        public function averagePoint():Point
        {
            var numPts:int = pts.length;
            var sumX:Number=0;
            var sumY:Number=0;
            for (var j:int = 0; j<numPts; j++)
            {
                sumX+=pts[j].x;
                sumY+=pts[j].y;
            }
            return new Point(sumX/numPts,sumY/numPts);
        }

        public function reorder():void
        {
            midPt = averagePoint();
            pts.sort(orderFunc);            
        }
        public function orderFunc(a:Dot,b:Dot):int
        {
            var ang1:Number = a.angleTo(midPt);
            var ang2:Number = b.angleTo(midPt);
            if (ang1 > ang2) { return -1; }
            else if (ang2 > ang1) { return 1; }
            return 0;
        }

        public function drawScreen():void
        {
            this.graphics.clear();
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            this.graphics.beginFill(0xFFFFFF);
            this.graphics.drawCircle(midPt.x,midPt.y,1);
            this.graphics.endFill();
            var numPts:int = pts.length;
            this.graphics.lineStyle(1,0xFFFFFF);
            if (numPts > 0)
                this.graphics.moveTo(pts[0].x,pts[0].y);
            for (var j:int = 0; j < numPts; j++)
            {
                this.graphics.lineTo(pts[j].x,pts[j].y);
                pts[j].draw(this);
                this.graphics.moveTo(pts[j].x,pts[j].y);
            }
            if (numPts > 0)
                this.graphics.lineTo(pts[0].x,pts[0].y);         
        }
    }
}
import flash.geom.Point;
import flash.display.Sprite;
import flash.display.DisplayObject;
    class Dot extends Sprite
    {
        private var pt:Point;
        public function Dot(pt:Point)
        {
            this.pt = pt;
        }
        public override function get x():Number
        {
            return pt.x;
        }
        public override function get y():Number
        {
            return pt.y;
        }
        public function angleTo(pt2:Point):Number
        {
            return Math.atan2(pt2.y-pt.y,pt2.x-pt.x);
        }
        public function distTo(pt2:Point):Number
        {
            return Math.sqrt(((pt2.y-pt.y)*(pt2.y-pt.y))+((pt2.x-pt.x)*(pt2.x-pt.x)));
        }

        public function draw(canvas:Sprite):void
        {
            canvas.graphics.beginFill(0xFFFFFF,.5);
            canvas.graphics.drawCircle(pt.x,pt.y,10);
            canvas.graphics.endFill();
        }
    }
    
    
    
/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}
