/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ytGg
 */

// forked from gaziya's 練習１
package {
    import flash.geom.ColorTransform;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter
    import flash.geom.Matrix3D
    import flash.display.Shape
    import flash.events.Event
    import flash.geom.Vector3D
    import flash.display.Sprite
    [SWF(width=465,height=465,frameRate=30)]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            graphics.beginFill(0x5)                
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)            
            var container:Sprite= addChild(new Sprite) as Sprite
            with (container) {
                x = stage.stageWidth/2
                y = stage.stageHeight/2
                z = -150
            }
            var shapes:Vector.<Shape> = new Vector.<Shape>                       
            for (var i:int = 0; i <1000; i++){
                var radius:Number = Math.sqrt(Math.random())*200 + 100
                var theta_x:Number = Math.random()*360
                var theta_y:Number = Math.random()*360
                var rect:Shape = container.addChild(new Shape) as Shape
                shapes.push(rect)
                var rect_size:int = Math.random()*20 + 10
                with (rect) {
                    graphics.beginFill(0xffffff)                
                    graphics.drawRect(-rect_size/2, -rect_size/2,rect_size,rect_size)                            
                    rotationX = -theta_x
                    rotationY = theta_y
                    x = radius * Math.cos(theta_x*Math.PI/180) * Math.sin(theta_y*Math.PI/180)
                    y = radius * Math.sin(theta_x*Math.PI/180)
                    z = radius * Math.cos(theta_x*Math.PI/180) * Math.cos(theta_y*Math.PI/180)   
                }             
            }          
            addEventListener(Event.ENTER_FRAME, loop)                                      
            var theta:Number = 0
            var tilt:Number = 0
            function loop(e:Event):void {
                theta = (theta+1)%360
                tilt = (tilt+0.1)%360
                var matrix:Matrix3D = new Matrix3D              
                matrix.appendRotation(theta,Vector3D.Y_AXIS)    
                var position_z:Array = new Array
                var i:int
                for (i = 0; i < shapes.length;i++) {
                    var vector:Vector3D = matrix.transformVector(new Vector3D(shapes[i].x,shapes[i].y,shapes[i].z))
                    position_z.push({idx:i, z:vector.z})
                }
                position_z.sortOn("z", Array.NUMERIC | Array.DESCENDING)
                for (i = 0; i < container.numChildren; i++) {container.removeChildAt(0)}                
                for (i = 0; i < shapes.length;i++) {
                    if (position_z[i].z > 30) {
                        container.addChild(shapes[position_z[i].idx])
                        var color:ColorTransform = new ColorTransform
                        with (color) {
                            redMultiplier = 0.5
                            greenMultiplier = 0.5
                            blueMultiplier = i/shapes.length*2
                        }
                        shapes[position_z[i].idx].transform.colorTransform = color                        
                    }
                }
                container.rotationY = theta
                container.rotationZ = tilt          
            }    
        }
    }
}
