/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yt9Y
 */

package {
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import org.libspark.betweenas3.tweens.ITweenGroup;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    
    public class FlashTest extends Sprite {
        private var myStage:Sprite = new Sprite();
        private var qTaro:Sprite = new Sprite();
        private var myPen:Sprite = new Sprite();
        private var myParts:Array = new Array();
        private var myCount:int = 0;
        
        private var myTween:ITween;
        
        private var drawHair2:ITween;
        private var drawHair:ITween;
        private var drawHead:ITween;
        private var drawHand:ITween;
        private var drawEyeIn:ITween;
        private var drawEyeOut:ITween;
        private var drawMouse:ITween;
        private var drawMouseLine:ITween;
        private var drawReset:ITween;
        private var drawBody:ITween;
        private var drawFoot:ITween;
        private var drawShake1:ITween;
        private var drawShake2:ITween;
        private var drawLast:ITweenGroup;
        
        public function FlashTest() {
            myStage.x = 230;
            myStage.y = 230;
            myStage.scaleX = 1.5;
            myStage.scaleY = 1.5;
            addChild(myStage);
            myPen.graphics.beginFill(0xff0000);
            myPen.graphics.drawCircle(0, 0, 5);
            qTaro.x = -94;
            qTaro.y = -130;
            myStage.addChild(qTaro);
            myStage.rotation = 180;
            
            drawReset = BetweenAS3.serial(
                BetweenAS3.tween(myPen, {x:0, y:0}, null, 0)
            );            
            drawMouse = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:100, y:0}, {x:[0, 50, 100], y:[-6, 0, -6]}, 0.8),
                BetweenAS3.bezierTo(myPen, {x:0, y:0}, {x:[100, 50, 0], y:[12, 25, 12]}, 0.8)
            );
            drawMouseLine = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:70, y:0}, {x:[35], y:[10]}, 0.8)
            );
            drawEyeOut = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:0, y:-70}, {x:[10, 20, 10], y:[0, -35, -70]}, 0.6),
                BetweenAS3.bezierTo(myPen, {x:0, y:0}, {x:[-10, -20, -10], y:[-70, -35, 0]}, 0.6)
            );
            drawEyeIn = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:0, y:8}, {x:[-1, -2, -1], y:[0,4,8]}, 0.25),
                BetweenAS3.bezierTo(myPen, {x:0, y:0}, {x:[1,2,1], y:[8,4,0]}, 0.25)
            );
            drawHand = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:-2, y:25}, {x:[-50],y:[-30]}, 0.8)
            );
            drawHead = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:53, y:-108}, {x:[-5,5,33], y:[-40,-85,-108]}, 0.8),
                BetweenAS3.bezierTo(myPen, {x:106, y:0}, {x:[76, 104, 111], y:[-108, -85, -40]}, 0.8)
            );
            drawHair = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:0, y:-16}, {x:[3], y:[-8]}, 0.4)
            );
            drawHair2 = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:-12, y:-10}, {x:[-3], y:[-5]}, 0.4)
            );
            drawBody = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:0, y:70}, {x:[-3], y:[35]}, 0.8),
                BetweenAS3.bezierTo(myPen, {x:106, y:70}, {x:[-13,50,119], y:[90, 100, 90]}, 0.8),
                BetweenAS3.bezierTo(myPen, {x:106, y:0}, {x:[109], y:[35]}, 0.8)
            );
            drawFoot = BetweenAS3.serial(
                BetweenAS3.bezierTo(myPen, {x:15, y:12}, {x:[0, 15], y:[14, 14]}, 0.3),
                BetweenAS3.bezierTo(myPen, {x:30, y:14}, {x:[15, 30], y:[18, 18]}, 0.3),
                BetweenAS3.bezierTo(myPen, {x:45, y:8}, {x:[30, 45], y:[16,16]}, 0.3)
            );
            
            myCount = 0;
            drawPlay();
        }
        
        private function drawPlay():void {
            myParts[myCount] = new Sprite();
            qTaro.addChild(myParts[myCount]);
            myParts[myCount].graphics.lineStyle(5, 0x000000);
            
            var myX:int;
            var myY:int;
            var myTime:Number = (myCount == 0) ? 1:0;
            
            switch(myCount) {
                case 0:
                myX = 50; myY = 100; myTween = drawMouse;
                break;
                
                case 1:
                myX = 65; myY = 105; myTween = drawMouseLine;
                break;
                
                case 2:
                myX = 94; myY = 57; myTween = drawEyeIn;
                break;
                
                case 3:
                myX = 107; myY = 57; myTween = drawEyeIn;
                break;
                
                case 4:
                myX = 83; myY = 96; myTween = drawEyeOut;
                break;
                
                case 5:
                myX = 118; myY = 96; myTween = drawEyeOut;
                break;
                
                case 6:
                myX = 47; myY = 120; myTween = drawHand;
                break;
                
                case 7:
                myX = 153; myY = 120; myTween = drawHand;
                myParts[myCount].scaleX *= -1;
                break;
                
                case 8:
                myX = 47; myY = 120; myTween = drawHead;
                break;
                
                case 9:
                myX = 100; myY = 10; myTween = drawHair;
                break;
                
                case 10:
                myX = 100; myY = 10; myTween = drawHair2;
                break;
                
                case 11:
                myX = 100; myY = 10; myTween = drawHair2;
                myParts[myCount].scaleX *= -1;
                break;
                
                case 12:
                myX = 47; myY = 135; myTween = drawBody;
                break;
                
                case 13:
                myX = 50; myY = 227; myTween = drawFoot;
                break;
                
                case 14:
                myX = 150; myY = 227; myTween = drawFoot;
                myParts[myCount].scaleX *= -1;
                break;
                
                default:
                drawShake1 = BetweenAS3.serial(
                    BetweenAS3.tween(myParts[6], {rotation:2}, null, 0.42),
                    BetweenAS3.tween(myParts[6], {rotation:-2}, null, 0.42)
                );
                drawShake2 = BetweenAS3.serial(
                    BetweenAS3.tween(myParts[7], {rotation:-2}, null, 0.42),
                    BetweenAS3.tween(myParts[7], {rotation:2}, null, 0.42)
                );
                drawLast = BetweenAS3.parallel(drawShake1, drawShake2);
                drawLast.stopOnComplete = false;
                BetweenAS3.tween(myStage, {rotation:0}, null, 2, Elastic.easeInOut).play();
                drawLast.play();
                break;
            }
            
            myParts[myCount].x = myX;
            myParts[myCount].y = myY;
            if(myCount <= 14) {
                myParts[myCount].addChild(myPen);
                BetweenAS3.delay(myTween, myTime).play();
                myTween.addEventListener(TweenEvent.UPDATE, myDrawLine);
                myTween.addEventListener(TweenEvent.COMPLETE, nextDraw);
            }
        }
        
        private function nextDraw(e:Event = null):void {
            myTween.removeEventListener(TweenEvent.UPDATE, myDrawLine);
            myTween.removeEventListener(TweenEvent.COMPLETE, nextDraw);
            myParts[myCount].removeChild(myPen);
            myPen.x = 0;
            myPen.y = 0;
            
            myCount++;
            
            drawPlay();
        }
        
        private function myDrawLine(e:Event = null):void
        {
            myParts[myCount].graphics.lineTo(myPen.x, myPen.y);
        }
        
        private function init():void {
            
        }





    }
}