/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yt6h
 */

package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.RadioButton;
    
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    import net.hires.debug.Stats;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends MovieClip 
    {
        
        /* Property */
        /////////////////////////////////////////////////////////////////////////
        
        private var W:Number;
        private var H:Number;
        private var _stg:Sprite, _bg:Sprite;
        
        
        /* Main Function */
        /////////////////////////////////////////////////////////////////////////　
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            _bg = addChild( new Sprite ) as Sprite;
            _stg = addChild( new Sprite ) as Sprite;
            uiset();
            
            setStage();
            removeEventListener(Event.ADDED_TO_STAGE, init );
            loaderInfo.addEventListener(Event.UNLOAD, remove );            
                        
            main();
            
            addEventListener(Event.ENTER_FRAME,function(e:Event):void{
                _stg.rotation += 0.1;
            });
        }
        
        
        /* MainCode */
        /////////////////////////////////////////////////////////////////////////
        
        private var _balls:Vector.<Ball> = new Vector.<Ball>();
        private const NUM:uint = 1000;        // ボールの数
        private const density:uint = 21;    // 密度
        
        private function main():void
        {
            write();
        }
        
        private function write(e:Event=null):void
        {
            _stg.x = W>>1;
            _stg.y = H>>1;
            
            clear();
            for(var i:Number = 0; i < NUM; i++){
                _balls[i] = _stg.addChild(new Ball( p1.value*0.1, fillBtn.selected, (colBtn.selected)? 0xFFFFFF*Math.random() : 0xFF0000 )) as Ball;
                var kakudo:Number = i*(p2.value*0.01)*Math.PI*((1 + Math.sqrt( p0.value ))/2);    //螺旋が34本の場合。21本の場合は2.0を取る
                _balls[i].x = (i + p3.value)*Math.cos(kakudo);
                _balls[i].y = (i + p4.value)*Math.sin(kakudo);
                _balls[i].scaleX = _balls[i].scaleY  += i*(p5.value*0.001) ;
            }            
        }
        private function clear():void{
            for (var i:int = 0; i < _balls.length; i++) 
            {
                if(_balls[i].parent){
                    _stg.removeChild( _balls[i] );
                }
            }
        }
        
        
        private var p0:HUISlider, p1:HUISlider, p2:HUISlider, p3:HUISlider, p4:HUISlider, p5:HUISlider;
        private var fillBtn:CheckBox, colBtn:CheckBox;
        
        private function uiset():void
        {
            p0 = new HUISlider( this, 5, 10, 'p0', write );
            p1 = new HUISlider( this, 5, 25, 'p1', write );
            p2 = new HUISlider( this, 5, 40, 'p2', write );
            p3 = new HUISlider( this, 5, 55, 'p3', write );
            p4 = new HUISlider( this, 5, 70, 'p4', write );
            p5 = new HUISlider( this, 5, 85, 'p5', write );
            
            p0.value = 26;
            p1.value = 
            p2.value = 
            p3.value = 
            p4.value = 
            p5.value = 20;
            
            fillBtn = new CheckBox( this, 25, 108, 'Fill', write );
            fillBtn.selected = true;
            
            colBtn = new CheckBox( this, 60, 108, 'Color', write );
        }
        
        
        
        
        
        
        /* REMOVE Event */
        /////////////////////////////////////////////////////////////////////////　
        
        private function remove(e:Event):void{
            stage.removeEventListener(Event.RESIZE, resizeHandler);
            loaderInfo.removeEventListener(Event.UNLOAD, remove );            
        }
    
        /* Stage Setting & Resize Event */
        /////////////////////////////////////////////////////////////////////////　
        
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeHandler);
            resizeHandler(null);
        }
        public function resizeHandler(e:Event=null):void
        {
            W = stage.stageWidth;
            H = stage.stageHeight;
            
            _bg.graphics.clear();
            _bg.graphics.beginFill(0x000000);
            _bg.graphics.drawRect(0,0,W,H);
            
            write();
        }
        
    }
    
}
import flash.display.Sprite;

class Ball extends Sprite 
{
    public function Ball($size:Number=1, $bool:Boolean=true, $col:Number=0xFF0000 )
    {
        if($bool){
            graphics.beginFill( $col );
        }else{
            graphics.lineStyle( 1 , $col );
        }
        graphics.drawCircle(0,0,$size);
    }
}



