/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ysyd
 */

package  {
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "000000")]
    public class Box2d1 extends Sprite {
        private var m_physScale:int = 100;
        private var m_step:Number = 1 / 30;
        private var stageW:Number = 465;
        private var stageH:Number = 465;
        private var wallT:Number = 0.5;
        
        private var world:b2World;        
        
        public function Box2d1() {
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            var gravity:b2Vec2 = new b2Vec2(0, 9.8);
            
            world = new b2World(worldAABB, gravity, true);
            
            // wall
            var leftArr:Array = [stageW / 2, wallT / 2, stageW - wallT / 2];
            var topArr:Array = [stageW - wallT /2, stageH /2, stageH /2];
            var widthArr:Array = [stageW, wallT, wallT];
            var heightArr:Array = [wallT, stageW, stageW];
            var len:uint = leftArr.length;
            
            for (var i:uint = 0; i < len; i++)
            {
                var floorBodyDef:b2BodyDef = new b2BodyDef();
                floorBodyDef.position.Set(leftArr[i] / m_physScale, topArr[i] / m_physScale);
                
                var floorShapeDef:b2PolygonDef = new b2PolygonDef();
                floorShapeDef.SetAsBox(widthArr[i] /2 / m_physScale, heightArr[i] /2 / m_physScale);
                
                var floorBody:b2Body = world.CreateBody(floorBodyDef);
                floorBody.CreateShape(floorShapeDef);
            }
            
            // Debug
            
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = this;
            debugDraw.m_drawScale = m_physScale;
            debugDraw.m_fillAlpha = 0.3;
            debugDraw.m_lineThickness = 1;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            
            var timer:Timer = new Timer(100, 60 * 2);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(stageW / 2 / m_physScale + Math.random() * 0.4 - 0.2, 0);
            
            var shapeDef:b2CircleDef = new b2CircleDef();
            shapeDef.radius = 0.1;
            shapeDef.density = 1;
            shapeDef.restitution = 0.5;
            
            var body:b2Body = world.CreateBody(bodyDef);
            body.CreateShape(shapeDef);
            body.SetMassFromShapes();
        }
        
        private function enterFrameHandler(event:Event):void {
            world.Step(m_step, 10);
        }
    }
}