/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ys7o
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite
	{
		private var data:Array = [];

		public function Main()
		{
			for (var y:int = 0; y < 5; y++)
			{
				for (var x:int = 0; x < 5; x++)
				{
					var circle:Circle = new Circle();
					circle.x = Circle.RADIUS * x * 2 + 20;
					circle.y = Circle.RADIUS * y * 2 + 20;
					addChild(circle);
					data.push(circle);
				}
			}
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
		}
		
		private function onMouseClick(event:MouseEvent):void 
		{
			data.forEach
			(
				function(e:Circle, ...a):void
				{
					e.init();
				}
			);
		}
		
		private function onMouseMove(event:MouseEvent):void 
		{
			for (var i:int = 0; i < data.length; i++)
			{
				var circle:Circle = data[i];
				var scale:Number = Math.sqrt(Math.pow(mouseX - circle.x, 2) + Math.pow(mouseY - circle.y, 2)) / (Circle.RADIUS * 5);
				circle.scaleX = circle.scaleY = scale;
			}
		}
	}
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;

class Circle extends Sprite
{
	public static const RADIUS:Number = 50;
	
	public function Circle()
	{
		init();
	}
	
	public function init():void
	{
		graphics.clear();
		graphics.beginFill(Math.random() * int.MAX_VALUE);
		graphics.drawCircle(0, 0, RADIUS);
		graphics.endFill();
		
		this.filters = [new DropShadowFilter()];
	}
}