/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yrWp
 */

package
{
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.CheckBox;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.external.ExternalInterface;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.FileReference;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.ui.Keyboard;
    import flash.utils.ByteArray;
    import jp.progression.commands.Command;
    import jp.progression.commands.CommandList;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.commands.net.LoadURL;
    
    /**
     * Main
     * @author Yukiya Okuda<alumican.net>
     */
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#000000")] 
    public class Main extends Sprite
    {
        //----------------------------------------
        //CLASS CONSTANTS
        
        private const API_KEY:String = "api_key=7608254c3026007b688a201dd72a09db";
        private const API_URL:String = "http://api.flickr.com/services/rest/?method=flickr.photos.search";
        private const API_TAG:String = "tags=sky,sun,blue";
        private const PER_PAGE:String = "per_page=200";
        
        private const PRESET:Vector.<String> = Vector.<String>([
            "http://farm8.staticflickr.com/7100/7238894126_e01ac72c6a_z.jpg",
            "http://farm4.staticflickr.com/3108/3242590757_ffcd7a2571_z.jpg",
            "http://farm8.staticflickr.com/7214/7239105096_268dfc4c83_z.jpg",
            "http://farm8.staticflickr.com/7085/7178696166_84a1209433_z.jpg",
            "http://farm8.staticflickr.com/7240/7238888366_269ec0b564_z.jpg",
            "http://farm8.staticflickr.com/7090/7235593244_4d257b1bb6_z.jpg",
            "http://farm9.staticflickr.com/8022/7211399750_b10c61a445_z.jpg"
        ]);
        
        
        
        
        //----------------------------------------
        //VARIABLES
        
        private var _bg:Sprite;
        
        private var _container:Sprite;
        
        private var _moonRing:Bitmap;
        private var _moonGlow:Sprite;
        private var _moonShadow:Sprite;
        private var _moon:Sprite;
        private var _moonR:Number;
        private var _moonX:Number;
        private var _moonY:Number;
        
        private var _moonTr:Number;
        private var _moonTx:Number;
        private var _moonTy:Number;
        
        private var _isRing:Boolean;
        
        private var _photoUrls:Vector.<String>;
        private var _photoIndex:int;
        private var _photo:Bitmap;
        private var _photoBmd:BitmapData;
        
        private var _saveButton:PushButton;
        private var _nextButton:PushButton;
        private var _modeCb:CheckBox;
        
        private var _loadCommand:Command;
        
        
        
        
        //----------------------------------------
        //STAGE INSTANCES
        
        
        
        
        
        //----------------------------------------
        //METHODS
        
        /**
         * Constructor
         */
        public function Main():void
        {
            Wonderfl.disable_capture();
            //Wonderfl.capture_delay(20);
            
            _log("start");
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 60;
            
            Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm1.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
            
            var self:* = this;
            var command:SerialList = new SerialList(null,
                function():void
                {
                    _bg = Sprite(addChild(new Sprite()));
                    _bg.graphics.beginFill(0x0);
                    _bg.graphics.drawRect(0, 0, 465, 465);
                    _bg.graphics.endFill();
                    
                    _container = Sprite(addChild(new Sprite()));
                    
                    _photo = Bitmap(_container.addChild(new Bitmap()));
                    
                    _moon = Sprite(_container.addChild(new Sprite()));
                    _moonTx = _moonTy = _moonTr = _moonX = _moonY = _moonR = 0;
                    _moon.mouseEnabled = _moon.mouseChildren = false;
                    
                    _moonRing = Bitmap(_moon.addChild(new Bitmap()));
                    _moonRing.visible = false;
                    
                    _moonShadow = Sprite(_moon.addChild(new Sprite()));
                    _moonShadow.visible = false;
                    
                    _moonGlow = Sprite(_moon.addChild(new Sprite()));
                    _moonGlow.visible = false;
                    
                    _nextButton = new PushButton(self, 10, 10, "NEXT PHOTO", _nextButtonClickHandler);
                    _saveButton = new PushButton(self, 120, 10, "SAVE", _saveButtonClickHandler);
                    
                    _modeCb = new CheckBox(self, 230, 15, "MODE", _modeCbChangeHandler);
                    _modeCb.selected = false;
                },
                function():void
                {
                    var url:String = "http://asset.alumican.net/eclipse/ring.png";
                    var loadBitmapData:LoadBitmapData = new LoadBitmapData(new URLRequest(url), { context : new LoaderContext(true) } );
                    CommandList(this.parent).insertCommand(
                        loadBitmapData,
                        function():void
                        {
                            _moonRing.bitmapData = BitmapData(loadBitmapData.data);
                            _moonRing.smoothing = true;
                        }
                    );
                },
                function():void
                {
                    var url:String = API_URL + "&" + API_KEY + "&" + API_TAG + "&" + PER_PAGE;
                    var loadUrl:LoadURL = new LoadURL(new URLRequest(url));
                    CommandList(this.parent).insertCommand(
                        loadUrl,
                        function():void
                        {
                            _photoUrls = new Vector.<String>();
                            var xml:XML = XML(loadUrl.data);
                            _log("xml : " + xml);
                            if (xml.@stat == "ok")
                            {
                                for each(var photo:XML in xml.photos.photo)
                                {
                                    var url:String = "http://farm" + photo.@farm + ".static.flickr.com/" + photo.@server + "/" + photo.@id + "_" + photo.@secret + ".jpg";
                                    _photoUrls.push(url);
                                }
                            }
                            _photoUrls = PRESET.concat(_photoUrls);
                        }
                    );
                },
                function():void
                {
                    addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
                    _container.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDownHandler);
                    stage.addEventListener(KeyboardEvent.KEY_DOWN, _keyDownHandler);
                    
                    _photoIndex = -1;
                    _updateMode();
                    _next();
                }
            );
            command.execute();
        }
        
        private function _saveButtonClickHandler(e:MouseEvent):void 
        {
            var bmd:BitmapData = new BitmapData(_photo.width, _photo.height, false, 0x0);
            bmd.draw(_container, new Matrix(1, 0, 0, 1, -_photo.x, -_photo.y));
            var bytes:ByteArray = PNGEncoder.encode(bmd);
            new FileReference().save(bytes, "eclipse.png");
            bytes.clear();
            bmd.dispose();
        }
        
        private function _modeCbChangeHandler(e:Event):void 
        {
            _isRing = !_isRing;
            _updateMode();
        }
        
        private function _nextButtonClickHandler(e:MouseEvent):void 
        {
            if (!_photoUrls) return;
            _next();
        }
        
        private function _updateMode():void
        {
            if (_isRing)
            {
                _moonRing.visible = true;
                _moonGlow.visible = false;
                _moonShadow.visible = false;
            }
            else
            {
                _moonRing.visible = false;
                _moonGlow.visible = true;
                _moonShadow.visible = true;
            }
        }
        
        private function _next():void
        {
            if (_loadCommand) return;
            
            _loadCommand = new SerialList(null,
                function():void
                {
                    if (_photoBmd)
                    {
                        _photoBmd.dispose();
                        _photoBmd = null;
                    }
                    
                    if (++_photoIndex >= _photoUrls.length) _photoIndex = 0;
                    var url:String = _photoUrls[_photoIndex];
                    _log("load : " + url);
                    var loadBitmapData:LoadBitmapData = new LoadBitmapData(new URLRequest(url), { context : new LoaderContext(true) } );
                    CommandList(this.parent).insertCommand(
                        loadBitmapData,
                        function():void
                        {
                            _photoBmd = BitmapData(loadBitmapData.data);
                            _photo.bitmapData = _photoBmd;
                            _photo.smoothing = true;
                            
                            var rect:Rectangle = BoundaryResizer.resize(_photoBmd.rect, new Rectangle(0, 0, 465, 465), BoundaryResizer.SHOW_ALL, BoundaryResizer.CENTER);
                            _photo.x = rect.x;
                            _photo.y = rect.y;
                            _photo.width = rect.width;
                            _photo.height = rect.height;
                            
                            _moonR = _moonTr = 0;
                        }
                    );
                },
                function():void
                {
                    _loadCommand = null;
                }
            );
            _loadCommand.execute();
        }
        
        private function _keyDownHandler(e:KeyboardEvent):void 
        {
            var amount:Number = e.shiftKey ? 10 : 1;
            switch (e.keyCode)
            {
                case Keyboard.UP:
                    _moonTy -= amount;
                    break;
                
                case Keyboard.DOWN:
                    _moonTy += amount;
                    break;
                
                case Keyboard.LEFT:
                    _moonTx -= amount;
                    break;
                
                case Keyboard.RIGHT:
                    _moonTx += amount;
                    break;
            }
        }
        
        private function _mouseDownHandler(e:MouseEvent):void 
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _mouseMoveHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, _mouseUpHandler);
            
            var dx:Number = mouseX - _moonTx;
            var dy:Number = mouseY - _moonTy;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            
            if (dist > _moonTr)
            {
                _moonX = _moonTx = mouseX;
                _moonY = _moonTy = mouseY;
                _moonR = _moonTr = 0;
            }
        }
        
        private function _mouseMoveHandler(e:MouseEvent):void
        {
            var dx:Number = mouseX - _moonTx;
            var dy:Number = mouseY - _moonTy;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            _moonTr = dist;
        }
        
        private function _mouseUpHandler(e:MouseEvent):void 
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, _mouseMoveHandler);
            stage.removeEventListener(MouseEvent.MOUSE_UP, _mouseUpHandler);
        }
        
        private function _enterFrameHandler(e:Event):void
        {
            _moonX += (_moonTx - _moonX) * 0.3;
            _moonY += (_moonTy - _moonY) * 0.3;
            _moonR += (_moonTr - _moonR) * 0.3;
            
            _drawMoon();
        }
        
        private function _drawMoon():void
        {
            var gs:Graphics = _moonShadow.graphics;
            var gg:Graphics = _moonGlow.graphics;
            gs.clear();
            gg.clear();
            
            if (_moonR > 0)
            {
                if (_isRing)
                {
                    /*
                    gg.beginFill(0x0);
                    gg.drawCircle(_moonX, _moonY, _moonR);
                    gg.endFill();
                    
                    gs.lineStyle(MathUtil.map(_moonR, 0, 100, 1, 3), 0xffffff);
//                    gs.beginFill(0x0, 0.3);
                    gs.drawCircle(_moonX, _moonY, _moonR);
//                    gs.endFill();
                    
                    var a:Number = MathUtil.map(_moonR, 0, 100, 4, 10);
                    _moonGlow.filters = [
                        new GlowFilter(0xffffff, 0.5, a, a, a * 0.5, 3, false, true)
                    ];
                    */
                    
                    var scale:Number = _moonR / (_moonRing.bitmapData.width / 2);
                    _moonRing.scaleX = _moonRing.scaleY = scale;
                    _moonRing.x = _moonX - _moonRing.width / 2;
                    _moonRing.y = _moonY - _moonRing.height / 2;
                }
                else
                {
                    gs.beginFill(0x0);
                    gs.drawCircle(_moonX, _moonY, _moonR);
                    gs.endFill();
                    
                    _moonGlow.filters = [
                    ];
                }
            }
        }
        
        private function _log(m:*):void
        {
            //ExternalInterface.call("console.log", String(m));
            trace(m);
        }
    }
}

//package net.alumican.as3.geom
//{
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.geom.Rectangle;
    
    /**
     * BoundaryResizer
     * 様々なリサイズをRectangleベースで実行するクラスです．
     * @see http://blog.alumican.net/2009/10/07_225251
     * @author alumican.net<Yukiya Okuda>
     */
    internal class BoundaryResizer
    {
        //-------------------------------------
        //CLASS CONSTANTS
        
        /**
         * scaleMode
         * リサイズ方法を操作するscaleModeには以下の定数を指定できます．
         */
        static public const EXACT_FIT:String = StageScaleMode.EXACT_FIT; // targetとboundaryが完全に一致するようにリサイズされます．多くの場合，targetの縦横比は保たれません．
        static public const SHOW_ALL:String  = StageScaleMode.SHOW_ALL;  // targetが縦横比を保ち，かつtargetがboundaryの内側にフィットするようにリサイズされます．targetがトリミングされることはありませんが，上下または左右に隙間ができることがあります．
        static public const NO_BORDER:String = StageScaleMode.NO_BORDER; // targetが縦横比を保ち，かつboundaryがtargetの内側にフィットするようにリサイズされます．targetとboundaryの間に隙間ができることはありませんが，targetがトリミングされることがあります．
        static public const NO_SCALE:String  = StageScaleMode.NO_SCALE;  // リサイズがおこなわれず，alignによる基準点合わせのみがおこなわれます．
        
        /**
         * align
         * リサイズ後のオブジェクトの基準点を操作するalignには以下の定数を指定できます．
         */
        static public const TOP_LEFT:String     = StageAlign.TOP_LEFT;     // x軸方向:左  , y軸方向:上
        static public const TOP:String          = StageAlign.TOP;          // x軸方向:中央, y軸方向:上
        static public const TOP_RIGHT:String    = StageAlign.TOP_RIGHT;    // x軸方向:右  , y軸方向:上
        static public const LEFT:String         = StageAlign.LEFT;         // x軸方向:左  , y軸方向:中央
        static public const CENTER:String       = "";                      // x軸方向:中央, y軸方向:中央
        static public const RIGHT:String        = StageAlign.RIGHT;        // x軸方向:右  , y軸方向:中央
        static public const BOTTOM_LEFT:String  = StageAlign.BOTTOM_LEFT;  // x軸方向:左  , y軸方向:下
        static public const BOTTOM:String       = StageAlign.BOTTOM;       // x軸方向:中央, y軸方向:下
        static public const BOTTOM_RIGHT:String = StageAlign.BOTTOM_RIGHT; // x軸方向:右  , y軸方向:下
        
        
        
        
        
        //-------------------------------------
        //METHODS
        
        /**
         * targetをboundaryに合わせてリサイズした矩形を返します．
         * リサイズ方法と基準点をscaleMode，alignで指定できます．
         * @param   target    リサイズ対象オブジェクトの矩形を指定します．(例)リサイズしたい画像の矩形
         * @param   boundary  リサイズの基準となる矩形を指定します．(例)リサイズ後の画像を収める枠
         * @param   scaleMode リサイズ時のスケールモードを指定します．このパラメータはStageScaleModeと互換性があります．このパラメータを省略した場合はBoundaryResizer.NO_SCALEとなり，リサイズはおこなわれません．
         * @param   align     boundaryに対するtargetの基準位置を指定します．このパラメータはStageAlignと互換性があります．このパラメータを省略した場合はBoundaryResizer.CENTERとなり，縦横ともに中央揃えとなります．
         * @return            リサイズ後の矩形が返されます．target及びboundaryは変更しません．
         */
        static public function resize(target:Rectangle, boundary:Rectangle, scaleMode:String = "noScale", align:String = ""):Rectangle
        {
            var tx:Number = target.x,
                ty:Number = target.y,
                tw:Number = target.width,
                th:Number = target.height,
                bx:Number = boundary.x,
                by:Number = boundary.y,
                bw:Number = boundary.width,
                bh:Number = boundary.height;
            
            switch (scaleMode)
            {
                case SHOW_ALL:
                case NO_BORDER:
                    var ratioW:Number = bw / tw,
                        ratioH:Number = bh / th,
                        ratio:Number  = (scaleMode == SHOW_ALL) ? ( (ratioW < ratioH) ? ratioW : ratioH ) :
                                                                  ( (ratioW > ratioH) ? ratioW : ratioH ) ;
                    tw *= ratio;
                    th *= ratio;
                    break;
                
                case EXACT_FIT:
                    return new Rectangle(bx, by, bw, bh);
            }
            
            tx = bx + ( (align == TOP_LEFT    || align == LEFT   || align == BOTTOM_LEFT ) ? 0               :
                        (align == TOP_RIGHT   || align == RIGHT  || align == BOTTOM_RIGHT) ? (bw - tw)       :
                                                                                             (bw - tw) / 2 ) ;
            ty = by + ( (align == TOP_LEFT    || align == TOP    || align == TOP_RIGHT   ) ? 0               :
                        (align == BOTTOM_LEFT || align == BOTTOM || align == BOTTOM_RIGHT) ? (bh - th)       :
                                                                                             (bh - th) / 2 ) ;
            
            return new Rectangle(tx, ty, tw, th);
        }
    }
//}

//package net.alumican.as3.utils
//{
    /**
     * MathUtil
     *
     * @author alumican.net<Yukiya Okuda>
     */
    
    internal class MathUtil
    {
        /**
         * 値を指定区間内に丸める
         */
        static public function map(value:Number, srcMin:Number, srcMax:Number, dstMin:Number, dstMax:Number):Number
        {
            value = value < srcMin ? srcMin : value > srcMax ? srcMax : value;
            return dstMin + (dstMax - dstMin) * (value - srcMin) / (srcMax - srcMin);
        }
        
        /**
         * 2点(p1, p2)をd1:d2に内分する点を求める
         */
        static public function internallyDividingPoint(p1:Number, p2:Number, d1:Number, d2:Number):Number
        {
            return p1 == p2 ? p1 : ((d2 * p1 + d1 * p2) / (d1 + d2));
        }
        
        /**
         * 2点(p1, p2)をd1:d2に外分する点を求める
         */
        static public function externallyDividingPoint(p1:Number, p2:Number, d1:Number, d2:Number):Number
        {
            return p1 == p2 ? p1 : ((d2 * p1 - d1 * p2) / (d2 - d1));
        }
        
        /**
         * 符号を求める
         */
        static public function sign(value:Number):Number
        {
            return value < 0 ? -1 : 1;
        }
    }
//}