/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yr3T
 */

// forked from yawakisin's forked from: Papervision3d入門 3.2.7
/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト	
	
	code 3.2.8
*/

package 
{
	import flash.display.*;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	
	[SWF(width = "800", height = "600", frameRate = "12", backgroundColor = "#404040")]
	public class ShadeMaterialSample extends BasicView {
		
		// コンストラクタ
		public function ShadeMaterialSample() 
		{
			// Loaderクラスを使用して画像ファイルを読み込む(外部のパスを指定)
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
			loader.load(
				new URLRequest("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"),
				new LoaderContext(true));		
		}
		
		private function compHandler(e:Event):void 
		{
			// 画像ファイルを読み込んだ場合、loaderのcontentプロパティがビットマップ画像になっている
			var bmpData:BitmapData = Bitmap(Loader(e.target.loader).content).bitmapData;

			// ライトを作成
			var light:PointLight3D = new PointLight3D(true, false);
			scene.addChild(light);

			// マテリアルを作成
			const lightColor:uint = 0xFFFFFF;
			const ambientColor:uint = 0x111111;
			const specularLevel:uint = 50;
			const color1:int = 0xFFFFFF;
			const color2:int = 0x111111;
			const steps:int = 4;
			
			// フラットシェーディング
//			var material:FlatShadeMaterial = new FlatShadeMaterial(
//			var material:GouraudMaterial = new GouraudMaterial(
//			var material:PhongMaterial = new PhongMaterial(
//				light, lightColor, ambientColor, specularLevel);
//			var material:CellMaterial = new CellMaterial(
//				light, color1, color2, steps);
			var material:EnvMapMaterial = new EnvMapMaterial(
				light, bmpData, null, 0x000000);

			// 球体と直方体を作成
			var sphere:Sphere = new Sphere(material, 250, 20, 20);
			var cube:Cube = new Cube(new MaterialsList( { all:material } ),
										300, 300, 300, 5, 5, 5);
			sphere.x = -250;
			cube.x = 250;
			cube.rotationX = -45;
			
			// 3D空間に球体を追加
			scene.addChild(sphere);
			scene.addChild(cube);
			
			// レンダリング
			startRendering();

			// フレームイベント
			addEventListener(Event.ENTER_FRAME, function():void
				{
					// ライトの位置をマウスの座標と連動
					light.x = 2 * (mouseX - stage.stageWidth / 2);
					light.y = -2 * (mouseY - stage.stageHeight / 2);
					light.z = -400;
				});
		}
	}
}
