/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yr1X
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getTimer;
	
	/**
	 * ...
	 * @author Arthur "nibb13" Makhonko
	 */
	public class Main extends Sprite {
		
		private const SHIPS_COUNT:int = 1000;
		
		private var tf:TextField;
		
		public function Main():void {
			
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
			
		}
		
		private function init(e:Event = null):void {
			
			removeEventListener(Event.ADDED_TO_STAGE, init);

			tf = new TextField();
			tf.width = stage.stageWidth;
			tf.height = stage.stageHeight;
			tf.text = 'Built-in vs. Static benchmark for '+SHIPS_COUNT.toString()+' objects, v 1.0\nClick to run benchmark again\n\n';
			addChild(tf);
			
			stage.addEventListener(MouseEvent.CLICK, runBench);
			
			runBench();
			
		}
		
		private function runBench(evt:MouseEvent = null):void {
			
			var ships:Vector.<Ship> = new Vector.<Ship>();
			
			for (var i:int = 0; i < SHIPS_COUNT; i++) {
				ships.push(new Ship(Math.round(Math.random() * stage.stageWidth), Math.round(Math.random() * stage.stageHeight)));
			}
			
			tf.appendText('Benchmark "Built-in" time: ' + runBench1(ships).toString() + ' ms\n');
			tf.appendText('Benchmark "Static" time: ' + runBench2(ships).toString() + ' ms\n\n');
			tf.scrollV = tf.maxScrollV;
			
		}
		
		private function runBench1(ships:Vector.<Ship>):int {
			
			////
			/// Benchmark 1
			//
			
			var benchStart:int = getTimer();
			
			for (var i:int = 0; i < ships.length; i++ ) {
				
				for (var j:int = 0; j < ships.length; j++ ) {
					
					if (ships[i] != ships[j]) {
						
						var dist:Number = ships[i].getDist(ships[j]);
						
					}
				}
			}
			
			return getTimer() - benchStart;
			
		}
		
		private function runBench2(ships:Vector.<Ship>):int {
			
			////
			/// Benchmark 2
			//
			
			var benchStart:int = getTimer();
			
			for (var i:int = 0; i < ships.length; i++ ) {
				
				for (var j:int = 0; j < ships.length; j++ ) {
					
					if (ships[i] != ships[j]) {
						
						var dist:Number = Distance.getDist(ships[i], ships[j]);
						
					}
				}
			}
			
			return getTimer() - benchStart;
			
		}
		
	}
	
}

class Ship {
		
	public var x:int;
	public var y:int;
	
	public function Ship(_x:int, _y:int) {
		
		x = _x;
		y = _y;
		
	}
	
	public function getDist(otherShip:Ship):Number {
		
		return Math.sqrt(Math.pow(x - otherShip.x, 2) + Math.pow(y - otherShip.y, 2));
		
	}
	
}

class Distance {
	
	public static function getDist(ship1:Ship, ship2:Ship):Number {
		
		return Math.sqrt(Math.pow(ship1.x - ship2.x, 2) + Math.pow(ship1.y - ship2.y, 2));
		
	}
	
}