/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yqy7
 */

// forked from grapefrukt's forked from: just four circles
// forked from grapefrukt's just four circles
package {
    
    import adobe.utils.CustomActions;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author Martin Jonasson (m@grapefrukt.com)
     */
    
    [SWF(backgroundColor="#000000", frameRate="60", width="450", height="450")]

    public class Main extends Sprite {
        
        static private const STAGE_W     :int = 450;
        static private const STAGE_H     :int = 450;
        static private const NUM_CIRCLES :int = 4;
        static private const BASE_RADIUS :Number = 50;
        static private const RADIUS_INC  :Number = 40;
        static private const DISTANCE    :Number = 40;
        static private const SIZE        :Number = 16;
        static private const ANGLE_NUDGE :Number = 12.5;
        
        private var _rings               :Vector.<Sprite>;
        private var _offset              :int = 0;
        private var _last_frame          :Number = 0;
        
        public function Main():void {
            stage.quality = StageQuality.BEST;
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, STAGE_W, STAGE_H);
            
            _rings = new Vector.<Sprite>(NUM_CIRCLES, true);
            
            for (var i:int = 0; i < NUM_CIRCLES ; i++) {
                var circumference:Number = (BASE_RADIUS + RADIUS_INC * i) * 2 * Math.PI;
                var count:int = circumference / DISTANCE;
                count -= count % 2;
                
                _rings[i] = new Sprite;
                _rings[i].x = STAGE_W / 2;
                _rings[i].y = STAGE_H / 2;
                addChild(_rings[i]);
                
                for (var j:int = 0; j < count; j++) {    
                    var shape:Shape = new Shape;
                    
                    shape.graphics.beginFill(j % 2 ? 0xd1dadd : 0x92A7AD);
                    
                    shape.graphics.drawRect( -SIZE / 2, -SIZE / 2, SIZE, SIZE);
                    shape.x = Math.sin((j / count) * Math.PI * 2) * (BASE_RADIUS + RADIUS_INC * i);
                    shape.y = Math.cos((j / count) * Math.PI * 2) * (BASE_RADIUS + RADIUS_INC * i);
                    shape.rotation = ((count-j) / count)  * 360;
                    shape.rotation += ( i % 2 ) ? -ANGLE_NUDGE : ANGLE_NUDGE;
                    _rings[i].addChild(shape);
                }
            }
            
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);
        }
        
        private function handleEnterFrame(e:Event):void {
            _offset += (getTimer() - _last_frame);
            for (var i:int = 0; i < _rings.length; i++) {
                _rings[i].rotation = (BASE_RADIUS + RADIUS_INC * (NUM_CIRCLES - i)) * _offset * 0.0002;
            }
            _last_frame = getTimer();
        }
        
    }
    
}