/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yqc6
 */

// forked from littlepad's flash on 2010-7-10
package {
    import flash.utils.Timer;
    import flash.filters.BlurFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
    
    public class FlashTest extends Sprite {
        private const WIDTH:Number = 465;        // ステージの横サイズ
        private const HEIGHT:Number = 465;    // ステージの縦サイズ
        private var _canvas:BitmapData;        // キャンバス
        private var _glow:BitmapData;
        private var _rect:Rectangle;            // 
        private var _cTra:ColorTransform;        //    
        private var _particles:Array;            // パーティクル情報配列
        private var _chars:Array;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0xFF000000);
            addChild(new Bitmap(_canvas));
            
            _glow = new BitmapData(WIDTH/4, HEIGHT/4, false, 0x0);
            var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
            bm.scaleX = bm.scaleY = 4;
            bm.blendMode = BlendMode.ADD;
            
            var format:TextFormat = new TextFormat();
            //format.font = '_ゴシック';
            format.size = 70;
            format.color = 0xffffff;
            var text:TextField = new TextField();
            text.defaultTextFormat = format;
           
            text.text = 'SUMMER\n2010';
            text.autoSize = TextFieldAutoSize.LEFT;
            var bmpd:BitmapData = new BitmapData(text.textWidth + 4, text.textHeight, false, 0x000000);
            bmpd.draw(text);
            var bmp:Bitmap = new Bitmap(bmpd);
            bmp.x = (stage.stageWidth - bmp.width) / 2;
            bmp.y = (stage.stageHeight - bmp.height) / 2;
            
            _chars = new Array();
            for(var xx:Number = 0; xx < bmpd.width; xx++){
                for(var yy:Number = 0; yy < bmpd.height; yy++){
                    if(bmpd.getPixel(xx, yy) == 0xffffff) {
                        _chars.push(new Point(xx + (stage.stageWidth - bmpd.width)/2, yy + (stage.stageHeight - bmpd.height)/2));
                    }
                }
            }
            
            
            _particles = new Array();
            _rect = new Rectangle(0, 0, WIDTH, HEIGHT);
            _cTra = new ColorTransform(.8, .8, .9, 1);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);     
            timer.start();  
        }
        
        private function onTimer(e:TimerEvent):void {
            (_cTra.redMultiplier > 0.9)? _cTra.redMultiplier = 0.8 : _cTra.redMultiplier += 0.01;
            
            var pn:uint = 100;    // 一度に描画する座標の数
            var m:uint = _chars.length;
            
            for( var i:uint = 0; i < pn; i++){
            var rn:uint = uint(Math.random() * m);
            var rx:uint = _chars[rn].x;
            var ry:uint = _chars[rn].y;
            
                // 一度に描画されるパーティクルの数
            var n:uint = 20;
            
            while(n--) {
                var p:Particle = new Particle();
                p.x = rx;
                p.y = ry
                
                var radius:Number = Math.random() * 2;
                var angle:Number = Math.random() * Math.PI*2;
                p.vx = Math.cos(angle) * radius;
                p.vy = Math.sin(angle) * radius;
                
                _particles.push(p);
            }
            }
        }            
        
        private function onEnterFrame(e:Event):void {
                // パフォーマンスを向上させるため、
                // BitmapData をロックして変更を反映させないようにする
            _canvas.lock();
            
            for(var i:uint = 0; i<_particles.length; i++){
                var p:Particle = _particles[i];
                p.vy += 0.2;
                p.vx *= 0.7;
                p.vy *= 0.9;
                p.x += p.vx;
                p.y += p.vy;
                _canvas.setPixel32(p.x, p.y, p.c);
                
                // ステージ外に出たパーティクルを配列から取り除く
                if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01)
                {
                    _particles.splice(i, 1);
                }
            }
            // ブラーフィルター
            _canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(1,1));
            
            // カラー変換
            _canvas.colorTransform(_rect, _cTra);
            
            // BitmapData のロックを解除し、変更を反映する
            _canvas.unlock();
            
            _glow.draw(_canvas, new Matrix(0.25, 0, 0, 0.25));
        }
    }
}

class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:uint;
    
    public function Particle()
    {
        this.x = 0;
        this.y = 0;
        this.vx = 0;
        this.vy = 0;
        this.c = 0xFFFFFFFF;
    }
}