/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yqVz
 */

//
//	東風谷早苗スペルカード「グレイソーマタージ」の☆の部分風な処理
//	かなり目コピなんで計算方法はムリがあるかも
//
//	クリックすると新しい☆が生成されます
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(backgroundColor = "0x000000", frameRate = "60")]

	/**
	 * 
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var	patternList:Array = new Array();
		
		private var moveBullet:Array = new Array();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2) );
			
			addEventListener(Event.ENTER_FRAME, EnterFrame );
			stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
		}
		
		private function EnterFrame(event:Event):void 
		{
			var i:int = 0;
			

			for ( i = 0; i < patternList.length; i++ )
			{
				var bullet:Bullet = patternList[i].Run();
				if ( bullet != null )
				{
					addChild( bullet );
				}
			}
			for ( i = patternList.length - 1; i >= 0; i-- )
			{
				if ( patternList[i].isEnd() )
				{
					//	待機リストから移動リストへ
					for ( var j:int = 0; j < patternList[i].waitBullet.length; j++ )	moveBullet.push( patternList[i].waitBullet[j] );						
					patternList.splice( i, 1 );						
				}
			}
					
			//	弾移動
			if ( moveBullet.length > 0 )
			{
				for ( i = moveBullet.length - 1; i >= 0; i-- )
				{
					moveBullet[i].x += Math.cos( moveBullet[i].moveAngle * Math.PI / 180 ) * 1;
					moveBullet[i].y += Math.sin( moveBullet[i].moveAngle * Math.PI / 180 ) * 1;
					
					if ( moveBullet[i].x < -50 || moveBullet[i].x > stage.stageWidth + 50 || moveBullet[i].y < -50 || moveBullet[i].y > stage.stageHeight + 50 )
					{
						removeChild( moveBullet[i] );
						moveBullet.splice( i, 1 );
					}
				}
			}
		}
		
		private function MouseDown(event:MouseEvent):void
		{
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2) );
		}
		
	}
	
}
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
import flash.display.Sprite;
import flash.geom.Point;

//-----------------------------
//	弾幕パターンクラス
class Pattern {
	
	private var end:Boolean = false;
	private var count:int = 0;
	
	private var defX:int = 0;
	private var defY:int = 0;
		
	private var gAngle:Number = 0;	//	弾発生角度
	
	private var target:Array = new Array();
	
	private static const PATH_OBJ_NUM:int = 20;		//	１辺に出す弾の数
	private static const TARGET_NUM:int = 5;
	private static const TARGET_ANGLE:Array = [ 270 + 72 * 3, 270 + 72 * 1, 270 + 72 * 4, 270 + 72 * 2, 270 ];	//	パスの目標地点の角度
	
	public	var waitBullet:Array = new Array();		//	保持用バッファ
	
	public function Pattern(_gx:int = 0, _gy:int = 0) {
		count = 0;
		defX = _gx;
		defY = _gy;
		gAngle = 0;
		
		for ( var i:int = 0; i < 5; i++ )
		{
			target[i] = new Point( Math.cos( TARGET_ANGLE[i] * Math.PI / 180 ) * 100, Math.sin( TARGET_ANGLE[i] * Math.PI / 180 ) * 100 );
		}
	}
	/**
	 * 弾発生処理
	 * @return
	 */
	public function Run() : Bullet {
		
		var bullet:Bullet = new Bullet();
			
		var targetNo:int = int(count / PATH_OBJ_NUM);
		var targetRate:int = int(count % PATH_OBJ_NUM);
		var p:Point;

		//	弾の座標を出す
		p = Point.interpolate( target[targetNo], target[(targetNo+(TARGET_NUM-1))%TARGET_NUM], targetRate / PATH_OBJ_NUM );		
		bullet.x = p.x + defX;
		bullet.y = p.y + defY;
		
		//	弾の移動角度を出す
		p.x = target[targetNo%TARGET_NUM].x - target[(targetNo + (TARGET_NUM - 1)) % TARGET_NUM].x;
		p.y = target[targetNo%TARGET_NUM].y - target[(targetNo + (TARGET_NUM - 1)) % TARGET_NUM].y;
		var angle1:Number = Math.atan2( p.y, p.x ) * 180/Math.PI;
		p.x = target[(targetNo+1)%TARGET_NUM].x - target[targetNo%TARGET_NUM].x;
		p.y = target[(targetNo+1)%TARGET_NUM].y - target[targetNo%TARGET_NUM].y;
		var angle2:Number = Math.atan2( p.y, p.x ) * 180/Math.PI;
		var angleVal:Number = angle2 - angle1;	
		if ( angleVal > 180 )
		{
			angleVal = -(360 - angleVal);
		}
		bullet.moveAngle = (angleVal * targetRate / PATH_OBJ_NUM) + angle1;
		bullet.moveAngle += 25;
		
		waitBullet.push( bullet );
		
		count++;
		if ( count == TARGET_NUM * PATH_OBJ_NUM )	end = true;
		
		return	bullet;
	}

	public	function isEnd() : Boolean {	return	end;	}
}

//-----------------------------
//	弾クラス
class Bullet extends Sprite {
	
	public	var moveAngle:Number = 0;
	
	public function Bullet() {
		super();
		
		graphics.beginFill(0x5555FF);
		graphics.drawCircle(0, 0, 5);
		graphics.endFill();
		
		graphics.beginFill(0xFFFFFF, 0.5);
		graphics.drawCircle(0, 0, 3);
		graphics.endFill();
		
	}
	
}