/**
 * Copyright rokubou ( http://wonderfl.net/user/rokubou )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/yqTV
 */

/**
 * FLARToolKit sample - away3d
 * --------------------------------------------------------------------------------
 * Copyright (C)2010 rokubou
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For further information please contact.
 *	http://www.libspark.org/wiki/saqoosha/FLARToolKit
 * 
 * Contributors
 *  rokubou
 */
package {
	import away3d.containers.ObjectContainer3D;
	import away3d.containers.Scene3D;
	import away3d.containers.View3D;
	import away3d.lights.PointLight3D;
	import away3d.materials.WireframeMaterial;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;
	
	import org.libspark.flartoolkit.core.FLARCode;
	import org.libspark.flartoolkit.core.param.FLARParam;
	import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
	import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
	import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
	import org.libspark.flartoolkit.support.away3d.FLARBaseNode;
	import org.libspark.flartoolkit.support.away3d.FLARCamera3D;
	
	[SWF(width=640, height=480, backgroundColor=0x808080, frameRate=30)]
	
	public class FLARToolKit_Sample_Single_SimpleCube_Away3D extends Sprite
	{
		/**
		 * 画面の幅と高さ
		 */
		protected var canvasWidth:int;
		protected var canvasHeight:int;
		
		/**
		 * 画面の幅と高さ
		 */
		protected var captureWidth:int;
		protected var captureHeight:int;
		
		/**
		 * マーカーの一辺の長さ(px)
		 */
		protected var codeWidth:int;
		
		/**
		 * カメラパラメータのファイル名
		 * 内部的に初期化される処理が含まれるので読み込む必要は無い。
		 * 例外的に 16:9 で使う場合は、それようのパラメータファイルを読み込むこと。
		 */
		protected var cameraParamFile:String;
		
		/**
		 * マーカーパターンのファイル名
		 */
		protected var markerPatternFile:String;
		
		/**
		 * パラメータファイル、マーカーパターンファイルの読込み用
		 * @see flash.net.URLLoader
		 */
		private var urlLoader:URLLoader;
		
		/**
		 * カメラパラメータデータ
		 * アスペクト比や歪みなどの補正のための情報が含まれる
		 * @see org.libspark.flartoolkit.core.param.FLARParam
		 */
		protected var cameraParam:FLARParam;
		
		/**
		 * マーカーパターン
		 * マーカーを複数パターン使う場合はVectorなどで管理する
		 * @see org.libspark.flartoolkit.core.FLARCode
		 */
		protected var markerPatternCode:FLARCode;
		
		/**
		 * @see flash.media.Camera
		 */
		protected var webCamera:Camera;
		
		/**
		 * flash.media.Video
		 */
		protected var video:Video;
		
		/**
		 * Webカメラからの入力をBitmapに確保する
		 * @see flash.display.Bitmap
		 */
		private var capture:Bitmap;
		
		/**
		 * ラスタイメージ
		 * @see org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData
		 */
		private var raster:FLARRgbRaster_BitmapData;
		
		/**
		 * Marker detector
		 * @see org.libspark.flartoolkit.detector.FLARSingleMarkerDetector
		 */
		private var detector:FLARSingleMarkerDetector;
		
		/**
		 * 3Dモデル表示用
		 * @see away3d.containers.View3D
		 */
		protected var view3d:View3D;
		
		/**
		 * 3Dモデル表示用
		 * @see org.papervision3d.scenes.Scene3D
		 */
		protected var scene3d:Scene3D;
		
		/**
		 * 3Dモデル表示字の視点
		 * @see org.libspark.flartoolkit.support.away3d.FLARCamera3D
		 */
		protected var camera3d:FLARCamera3D;
		
		/**
		 * Marker base node
		 * @see org.libspark.flartoolkit.support.away3d.FLARBaseNode
		 */
		protected var markerNode:FLARBaseNode;
		
		/**
		 * 表示モデルを一括して押し込めるコンテナ
		 * @see away3d.containers.ObjectContainer3D
		 */
		protected var container:ObjectContainer3D;
		
		/**
		 * 認識したマーカーの情報を格納
		 * @see org.libspark.flartoolkit.core.transmat.FLARTransMatResult
		 */
		protected var resultMat:FLARTransMatResult = new FLARTransMatResult();
		
		/**
		 * Constructor
		 * ここから初期化処理を呼び出して処理をスタート
		 */
		public function FLARToolKit_Sample_Single_SimpleCube_Away3D()
		{
			
			this.initialize();
		}
		
		/**
		 * initialize
		 *  各種サイズの初期化
		 */
		protected function initialize():void
		{
			// 各種サイズの初期化
			captureWidth = 320;
			captureHeight = 240;
			canvasWidth = 640
			canvasHeight = 480;
			codeWidth = 80;
			
			//
			markerPatternFile = 'http://assets.wonderfl.net/static/flar/flarlogo.pat';
			
			// パラメータファイルの読込み
			// 今回は省略して初期値を用いる
			this.cameraParam = new FLARParam();
			this.cameraParam.changeScreenSize(captureWidth, captureHeight);
			
			// マーカーパターンファイルの読込み
			this.urlLoader = new URLLoader();
			this.urlLoader.dataFormat = URLLoaderDataFormat.TEXT;
			this.urlLoader.addEventListener(Event.COMPLETE, this.onLoadCode);
			this.urlLoader.addEventListener(IOErrorEvent.IO_ERROR, dispatchEvent);
			this.urlLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, dispatchEvent);
			this.urlLoader.load(new URLRequest(markerPatternFile));
		}
		
		/**
		 * マーカーパターンを読み込む
		 * @param e Event
		 */
		protected function onLoadCode(e:Event):void
		{
			// URL Loader関連のイベントを削除
			this.urlLoader.removeEventListener(Event.COMPLETE, this.onLoadCode);
			
			// 分割数(縦・横)、黒枠の幅(縦・横)
			this.markerPatternCode = new FLARCode(16, 16, 50, 50);
			this.markerPatternCode.loadARPatt(this.urlLoader.data);
			// loaderがgc対象になるようにnullを突っ込む
			this.urlLoader = null;
			
			// 初期化
			dispatchEvent(new Event(Event.INIT));
			this.onInit();
		}
		
		/**
		 * Webカメラの設定と、ARToolKitの準備
		 */
		protected function onInit():void
		{
			// setup webcam
			this.webCamera = Camera.getCamera();
			if (!this.webCamera) {
				throw new Error('No webcamera!');
			}
			this.webCamera.setMode(this.captureWidth, this.captureHeight, 30);
			
			this.video = new Video( this.captureWidth, this.captureHeight);
			this.video.attachCamera(this.webCamera);
			
			// setup ARToolKit
			this.capture = new Bitmap(new BitmapData(this.captureWidth, this.captureHeight, false, 0),
									   PixelSnapping.AUTO,
									   true);
			// ウェブカメラの解像度と表示サイズが異なる場合は拡大する
			this.capture.width = this.canvasWidth;
			this.capture.height= this.canvasHeight;
			
			// キャプチャーしている内容からラスタ画像を生成
			this.raster = new FLARRgbRaster_BitmapData( this.capture.bitmapData);
			
			// キャプチャーしている内容を addChild
			this.addChild(this.capture);
			
			// setup Single marker detector
			this.detector = new FLARSingleMarkerDetector(this.cameraParam,
														  this.markerPatternCode,
														  this.codeWidth);
			this.detector.setContinueMode(true);
			
			// 3Dオブジェクト関係の初期化へ
			this.supportLibsInit();
			
			// start
			this.start();
		}
		
		/**
		 * 3Dオブジェクト関係の初期化
		 * 使用する3Dライブラリに応じてこの部分を書き換える。
		 */
		protected function supportLibsInit(): void
		{
			
			// シーンの生成
			this.scene3d = new Scene3D();
			this.markerNode = new FLARBaseNode();
			this.scene3d.addChild(this.markerNode);
			
			// 3Dモデル表示時の視点を設定
			this.camera3d = new FLARCamera3D();
			this.camera3d.setParam(this.cameraParam);
			
			// PV3DのViewport3Dと似たようなもの
			this.view3d = new View3D({scene:this.scene3d, camera:camera3d});
			
			// 微調整
			this.view3d.x = this.captureWidth -6;
			this.view3d.y = this.captureHeight;
			this.addChild(this.view3d);
		}
		
		/**
		 * モデルデータを書く場所
		 */
		protected function setModelData(_container:ObjectContainer3D):void
		{
			// ワイヤーフレームで,マーカーと同じサイズを Plane を作ってみる。
			var wmat:WireframeMaterial = new WireframeMaterial(0x0000ff);
			// 幅と透過度を設定
			wmat.width = 2;
			wmat.alpha = 1;
			
			var _plane:Plane = new Plane(); // 80mm x 80mm。
			_plane.width = 80;
			_plane.height = 80;
			_plane.material = wmat;
			
			// Cube
			var _cube:Cube = new Cube();
			_cube.width = 40;
			_cube.height = 40;
			_cube.depth = 40;
			_cube.y = 20
			
 			// _container に 追加
			_container.addChild(_plane);
			_container.addChild(_cube);
		}
		
		/**
		 * マーカーの認識と3次元モデルの描写を開始する
		 */
		public function start():void
		{
			// モデル格納用のコンテナ作成
			this.container = new ObjectContainer3D();
			
			// 3Dオブジェクト生成
			this.setModelData(this.container);
			
			// Marker Node に追加
			this.markerNode.addChild(this.container);

			// マーカー認識・非認識時用のイベントを登録
			this.addEventListener(MarkerEvent.MARKER_ADDED, this.onMarkerAdded);
			this.addEventListener(MarkerEvent.MARKER_UPDATED, this.onMarkerUpdated);
			this.addEventListener(MarkerEvent.MARKER_REMOVED, this.onMarkerRemoved);
			
			// 処理開始
			this.addEventListener(Event.ENTER_FRAME, this.run);
		}
		
		public function onMarkerAdded(e:Event=null):void
		{
//			trace("[add]");
			this.detector.getTransformMatrix(this.resultMat);
			this.markerNode.setTransformMatrix(this.resultMat);
			// View3dまるごと表示・非表示を切り替えるとかマルチマーカーにしたときにありえない書き方だけれど、
			// PV3Dのように処理する方法がわからない。
			this.view3d.visible = true;
		}
		
		public function onMarkerUpdated(e:Event=null):void
		{
			// 今回は実装していない
		}

		public function onMarkerRemoved(e:Event=null):void
		{
			// View3dまるごと表示・非表示を切り替えるとかマルチマーカーにしたときにありえない書き方だけれど、
			// PV3Dのように処理する方法がわからない。
			this.view3d.visible = false;
		}
		
		/**
		 * ここで処理振り分けを行っている
		 */
		public function run(e:Event):void
		{
			this.capture.bitmapData.draw(this.video);
			
			// Marker detect
			var detected:Boolean = false;
			try {
				detected = this.detector.detectMarkerLite(this.raster, 80) && this.detector.getConfidence() > 0.5;
			} catch (e:Error) {}
			
			// 認識時の処理
			if (detected) {
				// 一工夫できる場所
				// 前回認識した場所と今回認識した場所の距離を測り、
				// 一定範囲なら位置情報更新 MARKER_UPDATED を発行するなど、
				// 楽しい工夫が出来る。 参照: FLARManager
				this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_ADDED));
			// 非認識時
			} else {
				this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_REMOVED));
			}
			this.view3d.render();
		}
		
	}
}


import flash.events.Event;

/**
 * イベント制御用の簡易クラス
 */
class MarkerEvent extends Event
{
	/**
	 * Markerを認識した時
	 */
	public static const MARKER_ADDED:String = "markerAdded";
	
	/**
	 * Marker更新時
	 */
	public static const MARKER_UPDATED:String = "markerUpdated";
	
	/**
	 * Markerが認識しなくなった時
	 */
	public static const MARKER_REMOVED:String = "markerRemoved";
	
	public function MarkerEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false)
	{
		super(type, bubbles, cancelable);
	}
}