/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yqCJ
 */

// forked from onedayitwillmake's BetweenAS3 ColorMatrix
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    
    import flash.filters.ColorMatrixFilter;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width='465', height='465', frameRate='120', backgroundColor='#000')]
        
    public class OneDayItWillMake extends Sprite {
        
        private var loader:Loader = new Loader();
        
        public function OneDayItWillMake()
        {        
            Wonderfl.disable_capture();
            Wonderfl.capture_delay(2);
             
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleImageLoaded);
            loader.load(new URLRequest("http://farm4.static.flickr.com/3642/3556373834_3d37302602.jpg?v=0"));
        }
        
        private function handleImageLoaded(e:Event):void
        {
            loader.x = stage.stageWidth * 0.5 - loader.width * 0.5;
            addChild(loader)
            
            var t:ITween; // I usually make one variable for this and just keep reusing it 
            t = BetweenAS3.tween
				(loader,
					{ // TO
						_colorMatrixFilter: // Filter Tweens are in the format _~ilterNameLikeThis, where ~ is lowercase first char
						{matrix: // All filters are added as their own objects, as if you were calling new X filter
							[
								1, 0, 0, 0, 0,
								0, 1, 0, 0, 0,
								0, 0, 1, 0, 0,
								0, 0, 0, 1, 0
							]
						}

                                                ,_blurFilter: 
						{
						 blurX: 0,
						 blurY: 0,
						 quality: 3
						}
					},
					{ // FROM
						_colorMatrixFilter: 
						{matrix:
							[
								4.2, 0, 0, 0, 0,
								0, 4, 0, 0, 0,
								0, 0, 4.2, 0, 0,
								0, 0, 0, 1, 0
							]
						}
                                                ,_blurFilter: 
						{
						 blurX: 4,
						 blurY: 4,
						 quality: 3
						}
                                        }, 1, Cubic.easeOut, 0.25)
            
              t = BetweenAS3.serial(t, BetweenAS3.tween(loader, {alpha: 0}, null, 2, Sine.easeOut, 1))
              t.stopOnComplete = false;
              t.play();
              
              Wonderfl.capture(stage)
        }
    }
}