/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yqCF
 */

// forked from makc3d's forked from: forked from: Batman Equation
// forked from marsspider's forked from: Batman Equation
// forked from Quasimondo's Batman Equation
package {
    import flash.display.*;
    
    //Flash port from http://i.imgur.com/CNy9J.jpg
    
    public class BatmanEquation extends Sprite {
        
        
        public function BatmanEquation() {
            run();
        }
        
        private function run():void
        {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            var map:BitmapData = new BitmapData(465,300,true,0 );
            var display:Bitmap = new Bitmap( map, "auto", true );
            addChild( display );    
            display.width = stage.stageWidth;
            display.scaleY = display.scaleX;
            renderBatman( -9, 9, -4.5, 4.5, map );
        }
        private function nz (n:Number):Number {
			var e:Number = 1e-10;
			if (n < e) {
				if (n > 0) return e;
			} else if (n > -e) {
				if (n < 0) return -e;
			}
			return n;
		}
        private function renderBatman( xFrom:Number, xTo:Number, yFrom:Number, yTo:Number, target:BitmapData ):void
        {
            var xStep:Number = (xTo - xFrom ) / target.width;
            var yStep:Number = (yTo - yFrom ) / target.height;
            var px:int = 0;
            var py:int = 0;

            const const1:Number = 3 * Math.sqrt(33) / 7;
            const const2:Number = 6 * Math.sqrt(10);

			var arg:Complex = new Complex;
			var sqrt1:Complex = new Complex;
			var sqrt2:Complex = new Complex;
			var value:Complex = new Complex;
			var component1:Complex = new Complex;
			var component2:Complex = new Complex;
			var component3:Complex = new Complex;
			var component4:Complex = new Complex;
			var component5:Complex = new Complex;
			var component6:Complex = new Complex;

            for ( var y:Number = yFrom; y <= yTo; y+= yStep )
            {
                px = 0;
                for ( var x:Number = xFrom; x <= xTo; x+= xStep )
                {
                    
                    var abs_x:Number = Math.abs(x);
                    
                    arg.x = (Math.abs (abs_x - 3)) / nz (abs_x - 3);
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = (Math.abs (y + const1)) / nz (y + const1);
					arg.sqrtr ().saveTo (sqrt2);

					sqrt1.mulr (Math.pow (x / 7, 2)).add (
					sqrt2.mulr (Math.pow (y / 3, 2))).saveTo (component1);
					component1.x -= 1; // 1

					arg.x = 1 - Math.pow (Math.abs ( abs_x - 2) - 1, 2);
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = Math.abs (x / 2) - ( const1 / 112 )  * (x * x) - 3 - y;
					arg.add (sqrt1).saveTo (component2); // 2

					arg.x = Math.abs ((abs_x - 1) * (abs_x - 0.75)) / nz ((1 - abs_x) * (abs_x - 0.75));
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = - 8 * abs_x - y;
					arg.add (sqrt1.mulr (9)).saveTo (component3); // 3

					arg.x = ((abs_x - 0.75) * (abs_x - 0.5)) / nz ((0.75 - abs_x) * (abs_x - 0.5));
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = 3 * abs_x - y;
					arg.add (sqrt1.mulr (0.75)).saveTo (component4); // 4

					arg.x = Math.abs ((x - 0.5) * (x + 0.5)) / nz ((0.5 - x) * (0.5 + x));
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = -y;
					arg.add (sqrt1.mulr (2.25)).saveTo (component5); // 5;

					arg.x = Math.abs (abs_x - 1) / nz (abs_x - 1);
					arg.sqrtr ().saveTo (sqrt1);

					arg.x = 4 - Math.pow (abs_x - 1, 2);
					arg.sqrtr ().saveTo (sqrt2);

					arg.x = const2 / 7 - y;
					arg.add (sqrt1.mulr (1.5 - 0.5 * abs_x)).sub (sqrt2.mulr (const2 / 14)).saveTo (component6); // 6

					component1.mul (component2).mul (component3).mul (component4).mul (component5).mul (component6).saveTo (value);

                    target.setPixel32 (px, target.height - py,
						0xff000000 +
						//0x10101 * int ( Math.min (255, value.abs ()) )
						((value.x > 0) ? 255 : 0) +
						((value.y > 0) ? 255 * 256 : 0)
					);
                    

                    px++;
                }
                py++;
            }

        }


        
        
    }
}

// from http://wonderfl.net/c/yE9I
class Complex {
	public var x:Number;
	public var y:Number;

	private static var pool:Vector.<Complex> = new Vector.<Complex>;
	private static var index:int = 0;

	private function pick ():Complex {
		if (index == pool.length) {
			pool [index] = new Complex;
		}
		index++;
		return pool [index - 1];
	}

	public function saveTo (result:Complex):void {
		result.x = x;
		result.y = y;
		index = 0;
	}

	public function Complex (x:Number = 0, y:Number = 0) {
		this.x = x;
		this.y = y;
	}

	public function add (b:Complex):Complex {
		var c:Complex = pick ();
		c.x = x + b.x;
		c.y = y + b.y;
		return c;
	}

	public function sub (b:Complex):Complex {
		var c:Complex = pick ();
		c.x = x - b.x;
		c.y = y - b.y;
		return c;
	}

	public function mulr (n:Number):Complex {
		var c:Complex = pick ();
		c.x = x * n;
		c.y = y * n;
		return c;
	}

	public function mul (b:Complex):Complex {
		var c:Complex = pick ();
		c.x = x * b.x - y * b.y;
		c.y = y * b.x + x * b.y;
		return c;
	}

	public function div (b:Complex):Complex {
		var c:Complex = pick ();
		var D:Number = b.x * b.x + b.y * b.y;
		c.x = (x * b.x + y * b.y) / D;
		c.y = (y * b.x - x * b.y) / D;
		return c;
	}

	public function pow (n:uint):Complex {
		var c:Complex = pick (); c.x = 1; c.y = 0;
		for (var i:int = 0; i < n; i++) {
			var _x:Number = x * c.x - y * c.y;
			var _y:Number = y * c.x + x * c.y;
			c.x = _x;
			c.y = _y;
		}
		return c;
	}

	public function sqrtr ():Complex {
		var c:Complex = pick ();
		c.x = (x > 0) ? Math.sqrt (x) : 0;
		c.y = (x < 0) ? Math.sqrt (-x) : 0;
		return c;
	}

	public function toString (p:uint = 4):String {
		return x.toPrecision (p) + " " + ((y > 0) ? "+" : "") + y.toPrecision (p) + "i";
	}

	public function abs ():Number {
		return Math.sqrt (x * x + y * y);
	}
}