/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ypXU
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.filters.GlowFilter;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var brush:BitmapData;
		private var prev:Point = new Point();
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
			 
			var text:Bitmap = Text.textToBitmap(Text.createTextField("FLASH", 60, 0x8BB300));
			text.filters = [new GlowFilter(0x00083F, 1, 6, 6, 30, 1, false, false)];
			brush = new BitmapData(text.width, text.height, true, 0x0);
			brush.draw(text);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			var tx:Number = (mouseX - prev.x) / 10;
			var ty:Number = (mouseY - prev.y) / 10;
 
			for (var i:int = 0; i < 10; i++)
			{
				bd.copyPixels(brush, brush.rect, new Point(prev.x - brush.width / 2, prev.y - brush.height / 2));
				prev.x += tx;
				prev.y += ty;
			}
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFormat;
 
class Text
{
	public static function createTextField(text:String, size:int, color:int):TextField
	{
		var tf:TextField = new TextField();
		tf.defaultTextFormat = new TextFormat("_typeWriter", size, color, true);
		tf.text = text;
		tf.autoSize = "left";
		tf.selectable = false;
 
		return tf;
	}
 
	public static function textToBitmap(tf:TextField, transparent:Boolean = true):Bitmap
	{
		var bd:BitmapData = new BitmapData(tf.width, tf.height, transparent, 0x0);
		bd.draw(tf);
 
		return new Bitmap(bd);
	}
}
