/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ypV7
 */

/*
http://www.logicalyze.net/blog/?p=2715を参考に。
自分なりの書き方になおしてみやす

音が鳴ったら
_onNoteOnが発動してその中で指定した_createNoteShapeが発動して丸を描く。
それを_onEnterFrameで動かす＆薄くする。
*/
package {
    import flash.display.*;
    import flash.events.*;
    
    import org.si.sion.*;
    import org.si.sion.events.*;
    
    public class Main extends Sprite {
        // ドライバ・インスタンスを生成
        public var driver:SiONDriver = new SiONDriver();
        // MML data（SiONData型を宣言）
        public var mainMelody:SiONData;
        
        public function Main() {
            /* トリガー・コマンド (%t)を付加してコンパイルする
			第1 トリガーID , 第2 ノートオン時のトリガータイプ , 第3 ノートオフ時のトリガータイプ
			1=ノート（音？？）がレンダリングされる直前に発行される ， 2=ノートが発音されるタイミングに発行*/
            mainMelody = driver.compile("%t0,1,1 t100 l8 [ccggaag4 ffeeddc4 | [ggffeed4]2 ]2");
            
            // トリガー用のイベントリスナーを設定
            driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME,  _onNoteOn);
            //driver.addEventListener(SiONTrackEvent.NOTE_OFF_FRAME, _onNoteOff);
            
            addEventListener("enterFrame", _onEnterFrame);
            
            // 再生
            driver.play(mainMelody);
        }
        
        // ノート・オン(発音)時のイベント
        private function _onNoteOn(e:SiONTrackEvent) : void {
            _createNoteShape(e.note);
        }
        
        // ノート・オフ(消音)時のイベント
        /*private function _onNoteOff(e:SiONTrackEvent) : void {
        }*/
        
        // シェイプを作成
        private function _createNoteShape(noteNumber:int) : Shape {
            var shape:Shape = new Shape();
			//beginFill 塗りの色 (色，透明度)
			//[0xff8080, 0x80ff80, 0x8080ff, 0xffff80][int(Math.random()*4)] randomによって色が変わるみたい。
            shape.graphics.beginFill([0xff8080, 0x80ff80, 0x8080ff, 0xffff80][int(Math.random()*4)]);
            shape.graphics.drawCircle(0, 0, Math.random()*20+10);
            shape.graphics.endFill();
            shape.x = (noteNumber - 60) * 30 + 100;
            shape.y = 300;
            addChild(shape);
            return shape;
        }
        
        // フレーム毎のアクション
        private function _onEnterFrame(e:Event) : void {
			//子の数
            var imax:int = numChildren;
			
            for (var i:int=0; i<imax ; i++) {
                var child:DisplayObject = getChildAt(i);
				//どんどん上に上げて薄くする
                child.y -= 2;
                child.alpha *= 0.98;
                if (child.y < -30 || child.alpha < 0.1) {
                    removeChild(child);
                    imax--;
                    i--;
                }
            }
        }
    }
}
