/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yo7T
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    public class Main extends Sprite {
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private var notes:Vector.<Note>;
        
        private var note:BitmapData;
        
        public static const NUM_NOTES:int = 120;
        public static const LANE_LENGTH:int = 50;
        public static const NOTE_WIDTH:int = 6;
        public static const BACKGROUND_CELLSIZE:int = 20;
        public static const LENGTH:int = NUM_NOTES * LANE_LENGTH;
        
        private var background:BitmapData;
        
        private var bitmap:Bitmap;
        private var data:BitmapData;
        private var rect:Rectangle = new Rectangle(0, 0, /*NOTE_WIDTH * LANE_LENGTH*/465, 465);
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.frameRate = 60;
            
            // BACKGROUND
            background = new Background(465, 465, BACKGROUND_CELLSIZE);
            //addChild(background);
            
            // LANE
            notes = new Vector.<Note>(LENGTH);
            for (var i:int = 0; i < LENGTH; i++) {
                notes[i] = new Note(i % LANE_LENGTH, Math.random() * rect.height);
            }
            
            note = new BitmapData(NOTE_WIDTH, 3, false, 0xFF0000);
            data = new BitmapData(rect.width, rect.height, true);
            bitmap = new Bitmap(data, PixelSnapping.AUTO, false);
            bitmap.cacheAsBitmap = true;
            addChild(bitmap);
            
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private const G:Number = 2;
        private const ZERO:Point = new Point();
        
        private function render(e:Event):void {
            data.lock();
            data.copyPixels(background, background.rect, ZERO);
            //data.fillRect(data.rect, 0x00000);
            for (var i:int = 0; i < LENGTH; i++) {
                notes[i].point.y += G;
                if (notes[i].point.y > rect.height) {
                    notes[i].point.y = 0; continue;
                }
                data.copyPixels(note, note.rect, notes[i].point);
            }
            data.unlock();
        }
        
    }
}

import flash.display.BitmapData;
import flash.geom.Point;
import flash.geom.Rectangle;
class Note {
    public var point:Point;
    public function Note(lane:int, pos:Number) {
        point = new Point(lane * Main.NOTE_WIDTH, pos);
    }
}

class Background extends BitmapData {
    public function Background(width:Number, height:Number, cellSize:int) {
        super(width, height, false);
        var p:Point = new Point(0, 0);
        var c:uint = 0;
        while (true) {
            fillRect(new Rectangle(p.x, p.y, cellSize, cellSize), c = ~c);
            p.x += cellSize;
            if (p.x > width) {
                p.x = 0; c = ~c;
                p.y += cellSize;
                if (p.y > height) break;
            }
        }
    }
    
    
}