/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ynrI
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
    
    public class FlashTest extends Sprite {
        public static var laserSp:Sprite = new Sprite();
        
        public function FlashTest() {
            addChild(laserSp);
            addChild(new Stats());
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, laserFire);            
        }
        
        private function laserFire(e:MouseEvent):void {
            var myLaser:Lasers = new Lasers();
            laserSp.addChild(myLaser);
        }
    }
}

import flash.display.*;
import flash.events.Event;
import flash.geom.Point;

class Lasers extends Sprite {
    private var bombSp:Sprite = new Sprite();
    
    private const firstLength:uint = 50;
    private const spd:Number = 0.3;
    private const bureRate:Number = 0;
    
    private var no:uint = 0;
    private var startPoint:Point;
    private var endPoint:Point;
    private var laserPoint:Point;
    private var controlPoint1:Point = new Point();
    private var controlPoint2:Point = new Point();
    private var dis:Number;
    private var bure:Number;
    private var laserArray:Array = [];
    private var rndColor:Number;
    
    public function Lasers() {
        startPoint = new Point(Math.ceil(Math.random() * 465), 465);
        laserPoint = startPoint;
        controlPoint1.x = startPoint.x;
        controlPoint1.y = 465 - firstLength;
        
        rndColor = Math.ceil(Math.random() * 0xffffff);
        
        this.addEventListener(Event.ENTER_FRAME, dlawLine); 
    }
    
    private function dlawLine(e:Event):void {
        endPoint = new Point(mouseX, mouseY);
        dis = Point.distance(laserPoint, endPoint);
        bure = dis * bureRate;
        
        var kaku:Number = Math.atan2(endPoint.y - laserPoint.y, endPoint.x - laserPoint.x) + Math.PI / 2;
        var dx:int = Math.floor((Math.random() * bure - bure / 2) * Math.cos(kaku));
        var dy:int = Math.floor((Math.random() * bure - bure / 2) * Math.sin(kaku));
        controlPoint2.x = controlPoint1.x + (endPoint.x - controlPoint1.x)+spd + dx;
        controlPoint2.y = controlPoint1.y + (endPoint.y - controlPoint1.y) * spd + dy;
        var sp:Sprite = new Sprite();
        sp.graphics.lineStyle(2, rndColor, 1);
        sp.graphics.moveTo(laserPoint.x, laserPoint.y);
        
        if(dis < 15)
        {
            sp.graphics.curveTo(controlPoint1.x, controlPoint1.y, endPoint.x, endPoint.y);
            this.removeEventListener(Event.ENTER_FRAME, dlawLine);
            setBomb();
        }
        else {
            laserPoint.x = controlPoint1.x + (controlPoint2.x - controlPoint1.x)/2;
            laserPoint.y = controlPoint1.y + (controlPoint2.y - controlPoint1.y)/2;
            
            sp.graphics.curveTo(controlPoint1.x, controlPoint1.y, laserPoint.x, laserPoint.y);
            controlPoint1.x = controlPoint2.x;
            controlPoint1.y = controlPoint2.y;
        }
        
        addChild(sp);
        laserArray.push(sp);
        laserArray[no].addEventListener(Event.ENTER_FRAME, delLine);
        no++;
    }
    
    private function delLine(e:Event):void {
        e.currentTarget.alpha -= 0.08;
        if(e.currentTarget.alpha < 0) {
            e.currentTarget.alpha = 0;
            e.currentTarget.removeEventListener(Event.ENTER_FRAME, delLine);
            removeChild(DisplayObject(e.currentTarget));
        }
    }
    
    private function setBomb():void {
        bombSp.graphics.beginFill(rndColor, 1);
        bombSp.graphics.drawCircle(0, 0, 5);
        bombSp.x = endPoint.x;
        bombSp.x = endPoint.x;
        bombSp.y = endPoint.y;
        addChild(bombSp);
        
        bombSp.addEventListener(Event.ENTER_FRAME, effectBomb);
    }
    
    private function effectBomb(e:Event):void {
        bombSp.scaleX += (4 - bombSp.scaleX) * 0.1;
        bombSp.scaleY += (4 - bombSp.scaleY) * 0.1;
        bombSp.alpha -= 0.04;
        if(bombSp.alpha < 0) {
            bombSp.alpha = 0;
            bombSp.removeEventListener(Event.ENTER_FRAME, effectBomb);
            removeChild(bombSp);
        }

    }
}
