/**
 * Copyright smirnov48 ( http://wonderfl.net/user/smirnov48 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ync8
 */

// forked from greentec's Diffusion-Limited Aggregation
package {
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    public class FlashTest extends Sprite {
        
        public var centerX:Number = 465 / 2;
        public var centerY:Number = 465 / 2;
        
        public var _bitmap:Bitmap;
        public var _bitmapData:BitmapData;
        
        public var _baseBitmap:Bitmap;
        public var _baseBitmapData:BitmapData;
        
        public var hitBitmapData:BitmapData;
        
        public var particleNum:int = 5000;
        public var particles:Array = [];
        
        private var tx:Number = 0;
        private var ty:Number = 0;
        private var i:int = 0;
        private var n:int = 0;

        public function FlashTest() {
            stage.frameRate = 100;
            
            _bitmapData = new BitmapData(465, 465, true, 0xff292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            _baseBitmapData = new BitmapData(465, 465, true, 0x00ffffff);
            _baseBitmapData.fillRect(new Rectangle(465 / 2 - 2, 465 / 2 - 2, 4, 4), 0xff00ffff);
            _baseBitmap = new Bitmap(_baseBitmapData);
            addChild(_baseBitmap);
            _baseBitmap.alpha = 1;
            
            hitBitmapData = new BitmapData(2, 2, true, 0xffffffff);
            
            initParticles();
            
            var _button:PushButton = new PushButton(this, 10, 465 - 30, "Hide", onShow);
            _button.alpha = 0.8;
            _button.toggle = true;
            _button.selected = true;
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        public function onShow(e:Event):void
        {
            if (e.target.selected == true)
            {
                e.target.label = "Hide";
                _baseBitmap.alpha = 1;
            }
            else
            {
                e.target.label = "Show";
                _baseBitmap.alpha = 0;
            }
        }
        
        public function onLoop(e:Event):void
        {
//            _bitmapData.fillRect(_bitmapData.rect, 0xff292929);
            for (i = 0; i < particleNum; i += 20)
            {
                updateParticle(particles[i]);
                updateParticle(particles[i+1]);
                updateParticle(particles[i+2]);
                updateParticle(particles[i+3]);
                updateParticle(particles[i+4]);
                updateParticle(particles[i+5]);
                updateParticle(particles[i+6]);
                updateParticle(particles[i+7]);
                updateParticle(particles[i+8]);
                updateParticle(particles[i+9]);
                updateParticle(particles[i+10]);
                updateParticle(particles[i+11]);
                updateParticle(particles[i+12]);
                updateParticle(particles[i+13]);
                updateParticle(particles[i+14]);
                updateParticle(particles[i+15]);
                updateParticle(particles[i+16]);
                updateParticle(particles[i+17]);
                updateParticle(particles[i+18]);
                updateParticle(particles[i+19]);
            }
            for (i = 0; i < particleNum; i += 20)
            {
                updateParticle(particles[i]);
                updateParticle(particles[i+1]);
                updateParticle(particles[i+2]);
                updateParticle(particles[i+3]);
                updateParticle(particles[i+4]);
                updateParticle(particles[i+5]);
                updateParticle(particles[i+6]);
                updateParticle(particles[i+7]);
                updateParticle(particles[i+8]);
                updateParticle(particles[i+9]);
                updateParticle(particles[i+10]);
                updateParticle(particles[i+11]);
                updateParticle(particles[i+12]);
                updateParticle(particles[i+13]);
                updateParticle(particles[i+14]);
                updateParticle(particles[i+15]);
                updateParticle(particles[i+16]);
                updateParticle(particles[i+17]);
                updateParticle(particles[i+18]);
                updateParticle(particles[i+19]);
            }            
            for (i = 0; i < particleNum; i += 20)
            {
                updateParticle(particles[i]);
                updateParticle(particles[i+1]);
                updateParticle(particles[i+2]);
                updateParticle(particles[i+3]);
                updateParticle(particles[i+4]);
                updateParticle(particles[i+5]);
                updateParticle(particles[i+6]);
                updateParticle(particles[i+7]);
                updateParticle(particles[i+8]);
                updateParticle(particles[i+9]);
                updateParticle(particles[i+10]);
                updateParticle(particles[i+11]);
                updateParticle(particles[i+12]);
                updateParticle(particles[i+13]);
                updateParticle(particles[i+14]);
                updateParticle(particles[i+15]);
                updateParticle(particles[i+16]);
                updateParticle(particles[i+17]);
                updateParticle(particles[i+18]);
                updateParticle(particles[i+19]);
            }            
            for (i = 0; i < particleNum; i += 20)
            {
                updateParticle(particles[i]);
                updateParticle(particles[i+1]);
                updateParticle(particles[i+2]);
                updateParticle(particles[i+3]);
                updateParticle(particles[i+4]);
                updateParticle(particles[i+5]);
                updateParticle(particles[i+6]);
                updateParticle(particles[i+7]);
                updateParticle(particles[i+8]);
                updateParticle(particles[i+9]);
                updateParticle(particles[i+10]);
                updateParticle(particles[i+11]);
                updateParticle(particles[i+12]);
                updateParticle(particles[i+13]);
                updateParticle(particles[i+14]);
                updateParticle(particles[i+15]);
                updateParticle(particles[i+16]);
                updateParticle(particles[i+17]);
                updateParticle(particles[i+18]);
                updateParticle(particles[i+19]);
            }
            for (i = 0; i < particleNum; i += 20)
            {
                updateParticle(particles[i]);
                updateParticle(particles[i+1]);
                updateParticle(particles[i+2]);
                updateParticle(particles[i+3]);
                updateParticle(particles[i+4]);
                updateParticle(particles[i+5]);
                updateParticle(particles[i+6]);
                updateParticle(particles[i+7]);
                updateParticle(particles[i+8]);
                updateParticle(particles[i+9]);
                updateParticle(particles[i+10]);
                updateParticle(particles[i+11]);
                updateParticle(particles[i+12]);
                updateParticle(particles[i+13]);
                updateParticle(particles[i+14]);
                updateParticle(particles[i+15]);
                updateParticle(particles[i+16]);
                updateParticle(particles[i+17]);
                updateParticle(particles[i+18]);
                updateParticle(particles[i+19]);
            }
        }

        public function updateParticle(p:Particle):void
        {
            n = p.x;
            tx = n < 0 ? n + .5 == (n | 0) ? n : n - .5 : n + .5;
            n = p.y;
            ty = n < 0 ? n + .5 == (n | 0) ? n : n - .5 : n + .5;
            if (_baseBitmapData.hitTest(new Point(_baseBitmapData.rect.x, _baseBitmapData.rect.y), 255, hitBitmapData, new Point(tx, ty)) == true)
            {
                if (p.x > tx)
                {
                    tx += 1;
                }

                if (p.y > ty)
                {
                    ty += 1;
                }

                _baseBitmapData.setPixel32(tx, ty, 0xff00ffff);
                
                //respawn
                if (Math.random() < .5)
                {
                    p.x = Math.random() * 465;
                    p.y = Math.random() < .5 ? 0 : 465;
                }
                else
                {
                    p.x = Math.random() < .5 ? 0 : 465;
                    p.y = Math.random() * 465;
                }
                //end respawn
            }
            else
            {

                p.vx += Math.random() * .1 - .05;
                p.vy += Math.random() * .1 - .05;
                p.x += p.vx;
                p.y += p.vy;
                p.vx *= .99;
                p.vy *= .99;
                
                if (p.x > 465)
                {
                    p.x -= 465;
                }
                else if (p.x < 0)
                {
                    p.x += 465;
                }
                
                if (p.y > 465)
                {
                    p.y -= 465;
                }
                else if (p.y < 0)
                {
                    p.y += 465;
                }
//                _bitmapData.setPixel32(p.x, p.y, 0x20ffffff);
            }
        }
        
        public function initParticles():void
        {
            var i:int;
            var p:Particle;
            for (i = 0; i < particleNum; i += 1)
            {
                p = new Particle(Math.random() * 465, Math.random() * 465);
                particles.push(p);
            }

        }
    }
}

Class
{
    class Particle 
    {
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
        
        public function Particle(x:Number, y:Number) 
        {
            this.x = x;
            this.y = y;
            this.vx = Math.random() * .1 - .05;
            this.vy = Math.random() * .1 - .05;
        }
    }
}
