/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ynSb
 */

/*
multipart project 2
part 1 of, I don't know, like 5

Background:
Importing Base64Decoder adds a lot to the SWF size. Convert
a base 64 encoded string to an array (note that this
increases the AS size). Determine if this results in a
smaller SWF file.

Task:
- learn how to use minimalcomps
- decode a base 64 encoded string
- write a JSON array of values
- check how this affects SWF size
*/
package {
	import mx.utils.Base64Decoder;
	import com.bit101.components.*;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.utils.ByteArray;
	import flash.errors.EOFError;
	import flash.events.Event;
	[SWF(width=400, height=400)]
	public class SixtyFour extends Sprite {
		
		private var t_in:TextArea;
		private var t_out:TextArea;
		
		public function SixtyFour() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			new Label(this, 0, 0, "Base64");
			t_in = new TextArea(this, 0, 20);
			t_in.width = 400;
			t_in.height = 150;
				
			new PushButton(this, 150, 180, "Convert", conv);
				
			new Label(this, 0, 190, "JSON");
			t_out = new TextArea(this, 0, 210);
			t_out.width = 400;
			t_out.height = 190;
		}
		
		private function conv(e:Event):void {
			var dec:Base64Decoder = new Base64Decoder();
			dec.decode(t_in.text);
			var data:ByteArray = dec.toByteArray();
			var len:int = data.length;
			data.length = Math.ceil(data.length / 4.) * 4;
			// Have we learned nothing from all those plus
			// vs array join experiments? To all the cool
			// kids, try switching the order of the two
			// test calls and tell me the results.
			var out:Vector.<int> = new Vector.<int>(data.length / 4, true);
			for (var i:int = 0; data.bytesAvailable >= 4; i++)
				out[i] = data.readInt();
			t_out.text = len + ', [' + out.join(',') + ']';
		}
		
		/** use this to go back to ByteArray */
		private static function ba(l:int, d:Array):ByteArray {
			var r:ByteArray = new ByteArray();
			for each (var w:int in d)
				r.writeInt(w);
			r.length = l;
			return r;
		}
		
	}
}