/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ymYw
 */

// forked from sinketu's 読み込んだ画像を、matrixで歪ませながら拡大させる。
// forked from y_tti's てらこ23で発表したものの説明２
//http://wonderfl.net/c/wJDq/

/*
構造は、fork前と同じです。
_containerの中に、_canvas,_p0,_p1,_p2,_p3が入ってます。
ゆがんでいるイメージを描画しているのはｄｒａｗ()のなかのbeginBitmapFill()です。
歪ませるのにはＭatrixが必要です。そのMatrixは_getTransformMatrix（）で設定しています。
このMatrixの設定のために、_p0,_p1,_p2,_p3（fork前のインスタンス名は_cP0,_cP1,_cP2,_cP3）の位置情報を使用しています。
手軽に試す場合は、
１．bitmapImageStringArrayのイメージＵＲＩを差し替える。
２．TestImageの画像サイズ（縦横400）を適宜変更する。
３．Tweenerのプロパティをいじる
などしてくみてださい。

※連打するとTweenerがわやわやですが、これ以上複雑にするのをやめます。
調整する必要があれば、フラグを立ててがんばってください。

※画像が静止すると、下に１ピクセル余計な線ができます。
簡単な調整として、TestImageの高さを-1してます。

※policyfileの読み込み待ち用TIMERは不細工です。
もっとスマートな方法があれば教えてください
*/
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.utils.Timer;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import  caurina.transitions.Tweener;
	import net.hires.debug.Stats;
	import flash.system.Security;
	import flash.events.TimerEvent;
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x000000")]
	public class Main extends MovieClip
	{
		private var _container:Sprite;
		private var _canvas:Sprite;
		private var _bmd:BitmapData;
		private var _stageW:Number = 465;
		private var _stageH:Number = 465;
		private var _p0:CirclePoint;
		private var _p1:CirclePoint;
		private var _p2:CirclePoint;
		private var _p3:CirclePoint;
		private var myBitmapMaker:BitmapMaker;
		private var _counter:uint = 0;
		private var miniBitmapSize:uint = 40;
		
		public function Main()
		{
			Security.loadPolicyFile("http://www.sinketu.com/wonderfl/crossdomain.xml");
			//var lpTimer:Timer=new Timer(500,1);
			//policyfileの読み込み待ち用TIMER
			//lpTimer.addEventListener(TimerEvent.TIMER,setBitmap);
			//lpTimer.start();
		//}
		//public function setBitmap(e:TimerEvent):void{
			myBitmapMaker = new BitmapMaker(this);
		}
		public function init():void {
			_bmd = Bitmap(new TestImage()).bitmapData;
			_canvas = new Sprite();
			_container = new Sprite();
			_container.addChild(_canvas);
			addChild(_container);
			_container.x = (_stageW - _bmd.width)/2;
			_container.y = (_stageH - _bmd.height)/2;
			_p0 = new CirclePoint(0,0);
			_p1 = new CirclePoint(_bmd.width,0);
			_p2 = new CirclePoint(0,_bmd.height);
			_p3 = new CirclePoint(_bmd.width,_bmd.height);
			_container.addChild(_p0);
			_container.addChild(_p1);
			_container.addChild(_p2);
			_container.addChild(_p3);
			xClick(null);	
			_container.addEventListener(MouseEvent.CLICK, xClick);
			_container.buttonMode=true;
			addEventListener(Event.ENTER_FRAME, xEnterFrame);
		}
		
		private function xEnterFrame(e:Event):void 
		{
				_draw();
		}
		
		private function xClick(e:MouseEvent):void 
		{
			var sw:Number = stage.stageWidth / 2;
			var sh:Number = stage.stageHeight / 2;
			_container.visible = true;
			_bmd.draw(myBitmapMaker.bitmaapArray[_counter % myBitmapMaker.bitmaapArray.length]);			
			_p0.x = -miniBitmapSize+_bmd.width/2;
			_p1.x = miniBitmapSize+_bmd.width/2;
			_p2.x = -miniBitmapSize+_bmd.width/2;
			_p3.x = miniBitmapSize+_bmd.width/2;
			_p0.y = -miniBitmapSize+_bmd.height/2;
			_p1.y = -miniBitmapSize+_bmd.height/2;
			_p2.y = miniBitmapSize+_bmd.height/2;
			_p3.y = miniBitmapSize+_bmd.height/2;
			Tweener.addTween(_p0, { x:_p0.initPoint.x, y:_p0.initPoint.y, time:Math.floor(0.5*Math.random()*10)/10+0.3, transition:"easeOutBack",delay:0.1});
			Tweener.addTween(_p1, { x:_p1.initPoint.x, y: _p1.initPoint.y, time:Math.floor(0.5*Math.random()*10)/10+0.3, transition:"easeOutBack",delay:0.15});
			Tweener.addTween(_p2, { x:_p2.initPoint.x, y: _p2.initPoint.y, time:Math.floor(0.5*Math.random()*10)/10+0.3, transition:"easeOutBack" ,delay:0.2});
			Tweener.addTween(_p3, { x:_p3.initPoint.x, y: _p3.initPoint.y, time:Math.floor(0.5*Math.random()*10)/10+0.3, transition:"easeOutBack",delay:0.25} );
			_counter++;
		}
		
		private function _draw():void {	
			//初期状態のポイント取得
			var aP0:Point = _p0.initPoint;
			var aP1:Point = _p1.initPoint;
			var aP2:Point = _p2.initPoint;
			var aP3:Point = _p3.initPoint;
			//初期状態のポイントよりマトリックス取得
			var initMatrix1:Matrix = _getTransformMatrix( aP0 , aP1 , aP2 );
			var initMatrix2:Matrix = _getTransformMatrix( aP3 , aP2 , aP1 );
			
			//変更状態のポイント取得
			var bP0:Point = new Point(_p0.x , _p0.y );
			var bP1:Point = new Point(_p1.x , _p1.y );
			var bP2:Point = new Point(_p2.x , _p2.y );
			var bP3:Point = new Point(_p3.x , _p3.y );
			//変更状態のポイントよりマトリックス取得
			var editMatrix1:Matrix = _getTransformMatrix( bP0 , bP1 , bP2 );
			var editMatrix2:Matrix = _getTransformMatrix( bP3 , bP2 , bP1 );
			
			//初期状態と変更状態のマトリックスを合体
			var newMatrix1:Matrix = initMatrix1.clone();
			newMatrix1.concat(editMatrix1);
			var newMatrix2:Matrix = initMatrix2.clone();
			newMatrix2.concat(editMatrix2);
			
			//前のをすべて消去
			_canvas.graphics.clear();
			//マトリックスを適応
			//分割した１個目を描画
			_canvas.graphics.beginBitmapFill(_bmd , newMatrix1 );
			_canvas.graphics.moveTo(bP0.x , bP0.y );
			_canvas.graphics.lineTo(bP1.x , bP1.y );
			_canvas.graphics.lineTo(bP2.x , bP2.y );
			_canvas.graphics.endFill();
			
			//分割した２個目を描画
			_canvas.graphics.beginBitmapFill(_bmd , newMatrix2 );
			_canvas.graphics.moveTo(bP3.x , bP3.y );
			_canvas.graphics.lineTo(bP1.x , bP1.y );
			_canvas.graphics.lineTo(bP2.x , bP2.y );
			_canvas.graphics.endFill();
		}
		private function _getTransformMatrix($pt0:Point, $pt1:Point, $pt2:Point):Matrix
		{
			var w:Number = _bmd.width;
			var h:Number = _bmd.height;
			var mat:Matrix = new Matrix();
			mat.a = ($pt1.x - $pt0.x) / w;
			mat.b = ($pt1.y - $pt0.y) / w;
			mat.c = ($pt2.x - $pt0.x) / h;
			mat.d = ($pt2.y - $pt0.y) / h;
			mat.tx = $pt0.x;
			mat.ty = $pt0.y;
			return mat;
		}
	}
}

import flash.display.Loader;
import flash.display.MovieClip;
import flash.display.LoaderInfo;
import flash.display.Bitmap;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.net.URLRequest;
import flash.geom.Point;
class CirclePoint extends Sprite {
	public var initPoint:Point;
	public function CirclePoint($x:Number , $y:Number) {
		this.x = $x;
		this.y = $y;
		this.initPoint = new Point( $x , $y );
	}
}
class TestImage extends Bitmap {
	private var _w:Number = 400;
	private var _h:Number = 400-1;
	public function TestImage():void {		
		var bmd:BitmapData = new BitmapData(_w, _h);
		this.bitmapData = bmd;
	}
}
class BitmapMaker
{
	private var info:LoaderInfo;
	public var bitmaapArray:Array = new Array();
	public static const bitmapImageStringArray:Array = ["http://www.sinketu.com/wonderfl/sample01.jpg","http://www.sinketu.com/wonderfl/sample02.jpg"];
	private var _counter:uint=0;
	private var myLoader:Loader;
	private var _mc:MovieClip;
	public function BitmapMaker(mc:MovieClip)
	{
		_mc = mc;
		_counter = 0;
		makeBitmap();
	}
	private function makeBitmap():void
	{
		myLoader = new Loader();
		myLoader.load(new URLRequest(bitmapImageStringArray[_counter]));
		info = myLoader.contentLoaderInfo;
		info.addEventListener(Event.COMPLETE, xImgLoaded);
	}
	private function xImgLoaded(e:Event):void 
	{
		bitmaapArray.push(myLoader);
		_counter++
		if (_counter >= bitmapImageStringArray.length) {
			_mc.init() ;
		}else {
			makeBitmap();
		}
	}
}

