/**
 * Copyright bradford.sedito ( http://wonderfl.net/user/bradford.sedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yldO
 */

// forked from psdev's forked from: flash on 2012-3-22
// forked from 1110101100101001's flash on 2012-3-22
package
{
    import flash.display.Sprite;
    public class QwnTest
    extends Sprite
    {
        public function QwnTest()
        {
            addChild( new WimiGame() );
        }
    }
}


    // Game /////////////////////////////////////////////////
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    class WimiGame
    extends Sprite
    {
        public var version:String = "00.00.00 alpha 2012.03.12"
        public var debugMemo:LLLMemo;
        
        public function WimiGame()
        {
            stage ? _init() : addEventListener( Event.ADDED_TO_STAGE, _init );
        }
        public function _init( event:Event = null ):void
        {
            LLL.init( stage, this );
            LLL.contextMenu.clear();
            LLL.contextMenu.addItem( "frameRate = 0;" ,function():void{ LLL.stage.frameRate = 0 } );
            LLL.contextMenu.addItem( "frameRate = 1;" ,function():void{ LLL.stage.frameRate = 1 } );
            LLL.contextMenu.addItem( "frameRate = 30;" ,function():void{ LLL.stage.frameRate = 30 } );
            LLL.contextMenu.addItem( "frameRate = 60;" ,function():void{ LLL.stage.frameRate = 60 } );
            LLL.input.$axis("x" ,"A J LEFT" ,"D L RIGHT");
            LLL.input.$axis("y" ,"W I UP"   ,"S K DOWN");
            
            
            //LLL.assets.addBitmapData("image/face").addLoadedHandler( onAssetLoaded );
            //LLL.assets.$("image/face").loadFromBase64( "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQAAAADsdIMmAAAAFUlEQVQImWNgAII0IJRgsGFQYWAAAApIAUVqh9WeAAAAAElFTkSuQmCC" );
            LLL.assets.$(
                "image/face" 
                ,"BitmapData"
                ,[onAssetLoaded]
                ,"Base64"
                ,"iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQAAAADsdIMmAAAAFUlEQVQImWNgAII0IJRgsGFQYWAAAApIAUVqh9WeAAAAAElFTkSuQmCC"
            ).load().createBitmap( this ,0 ,0 );
            
            debugMemo = new LLLMemo( this, 0, 0, " " );
            
            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        }
        public function onAssetLoaded( event:Event ):void
        {
            LLL.assets.$("image/face").editor.recolor( 0xFF000000, 0xFFFF00FF );
        }
        
        public function _onEnterFrame( event:Event ):void
        {
            var x:Number, y:Number;
            
            x = LLL.input.$axis("x");
            y = LLL.input.$axis("y");
            
            debugMemo.text = "Hello World From PsDev"
            + "\n"
            + LLL.input.getKey( [[0x25]] ).toString()
            + "\n"
            + LLL.input.atKeyCode( 0x25 ).toString()
            + "\n"
            + LLL.input.$("From PsDev").toString()
            + "\n"
            + LLL.input.$axis("y").toString()
            + "\n"
            + LLL.input.debugText;
        }
    }
    
    
    import flash.display.Sprite;
    class WimiCard
    extends Sprite
    {
        public var title:LLLMemo;
        public var memo:LLLMemo;
        public var still:Bitmap;
        
        public function WimiCard( root:DisplayObjectContainer ,x:Number = 0 ,y:Number = 0 ,title:String = " " , memo:String = " " ,image:BitmapData = null )
        {
            stage ? _init() : addEventListener( Event.ADDED_TO_STAGE ,_init );
            
            this.x = x;
            this.y = y;
            root.addChild( this );
            
            this.title = new LLLMemo( this ,0 ,0 ,title );
            this.memo = new LLLMemo( this ,0 ,20 ,memo );
            image ? null : image = new BitmapData( 1 ,1 ,true ,0 );
            still = new Bitmap( image );
            addChild( still );
        }
        private function _init( event:Event = null ):void
        {
            title.textFormat.size = 20;
            title.text = title.text;
        }
    }
    
    
    
    
    
    
    
    
    
    
    // Map /////////////////////////////////////////////////
    import flash.geom.Vector3D;
    class WimiMap
    extends EventDispatcher
    {
        public var map:Vector.<uint> = new Vector.<uint>( 0x10000 );
        public var width:Vector3D = new Vector3D();
        public var xForce   :Number = 0;
        public var xFriction:Number = 0;
        public var yForce   :Number = 0;
        public var yFriction:Number = 0;
        public var heat     :Number = 0;
        public var bounceRate:Vector3D = new Vector3D();
        public var frictionRate:Vector3D = new Vector3D();
        public var typeColorTally:uint = 0x0F0F0F0F;
        public var viewColorTally:uint = 0xF0F0F0F0;
        public function WimiMap()
        {
            //heat.x = force.x * frictionRate.x;
            //force.x = force.x - heat.x;
            //force.x = force.x - ( force.x * bounceRate.x );
            
        }
    }
    // Doll /////////////////////////////////////////////////
    import flash.display.Bitmap;
    import flash.events.EventDispatcher;
    class WimiDoll
    extends EventDispatcher
    {
        public var id:uint = 0;
        public var name:String = "";
        
        public var map:WimiMap;
        
        public var typeCode:uint = 0;
        public var faceCode:uint = 0;
        public var viewModelCode:uint = 0;
        public var viewPoseCode:uint = 0;
        
        
        public var forceX   :Number = 0;
        public var forceY   :Number = 0;
        public var frictionX:Number = 0;
        public var frictionY:Number = 0;
        public var x        :Number = 0;
        public var y        :Number = 0;
        public var heat     :Number = 0;
        
        public function WimiDoll()
        {
            
        }
        
        public function toDebugString():String
        {
            var result:String = ""
            + x.toString()
            + ","
            + y.toString()
            
            return result;
        }
    }
    
    
    
    
    
    
    
    
    
    
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////
    
    
    
    
    
    
    
    
    
    
    
    
    
    // LLLAssets ////////////////////////////////////////////////////
    import flash.utils.Dictionary;
    class LLLAssets
    {
        private var _dictionary:Dictionary;
        private var _array:Array = [];
        
        public function createThis():LLLAssets{ return new LLLAssets() }
        public function LLLAssets()
        {
            _dictionary = new Dictionary();
        }
        /*
        assets.addBitmapData( "image/portrait/player.png", new BitmapData( 8,8,true,0xFF0000FF ) );
        addChild( assets.of( "image/portrait/player.png" ).createBitmap() )
        assets.addBitmapDataFromAsset( "asset/image/face", "asset/image/portrait" )
        
        */
        public function of( name:String ):*
        {
            return _dictionary[name];
        }
        public function at( index:int ):*
        {
            return _array[index];
        }
        public function $( name:String, type:String = null, handlers:Array = null, format:String = null, data:* = null ):*
        {
            switch( type )
            {
                case null:
                    return( _dictionary[name] );
                    break;
                    
                case "BitmapData":
                    var imageLoader:LLLBitmapData = new LLLBitmapData();
                    for each( var imageHandler:Function in handlers )
                    {
                        imageLoader.addEventListener( Event.COMPLETE, imageHandler );
                    }
                    imageLoader.ready( format, data );
                    imageLoader.name = name;
                    _array[_array.length] = imageLoader;
                    _dictionary[name] = imageLoader;
                    return imageLoader;
                    
                case "Sound":
                    var soundLoader:LLLSound = new LLLSound();
                    for each( var soundHandler:Function in handlers )
                    {
                        soundLoader.addEventListener( Event.COMPLETE, soundHandler );
                    }
                    soundLoader.ready( format, data );
                    soundLoader.name = name;
                    _array[_array.length] = soundLoader;
                    _dictionary[name] = soundLoader;
                    return soundLoader;
                    
                default :
                    return null;
            }
        }
        public function addBitmapData( name:String, data:BitmapData = null ):LLLBitmapData
        {
            var loader:LLLBitmapData = new LLLBitmapData();
            loader.name = name;
            loader.ready( "BitmapData" ,data );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
        public function addBitmapDataFromAsset( name:String, copyAssetName:String ):LLLBitmapData
        {
            var loader:LLLBitmapData = new LLLBitmapData();
            loader.name = name;
            loader.ready( "BitmapData" ,$(copyAssetName) );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
        public function addBitmapDataFromBase64( name:String, data:String ):LLLBitmapData
        {
            var loader:LLLBitmapData = new LLLBitmapData();
            loader.name = name;
            loader.ready( "Base64" ,data );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
        public function addBitmapDataFromURI( name:String, data:String ):LLLBitmapData
        {
            var loader:LLLBitmapData = new LLLBitmapData();
            loader.name = name;
            loader.ready( "URI" ,data );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
        public function addSound( name:String, data:Sound ):LLLSound
        {
            var loader:LLLSound = new LLLSound();
            loader.name = name;
            loader.ready( "Sound" ,data );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
        public function addSoundFromBase64( name:String, data:String ):LLLSound
        {
            var loader:LLLSound = new LLLSound();
            loader.name = name;
            loader.ready( "Base64" ,data );
            _array[_array.length] = loader;
            _dictionary[name] = loader;
            
            return loader;
        }
    }
    
    
    
    // LLLSound ////////////////////////////////////////////////////
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.media.Sound;
    import flash.net.URLRequest;
    class LLLSound
    extends EventDispatcher
    {
        public var name:String = null;
        private var _data:Sound;
        private var _receivers:Array = [];
        private var _base64:LLLBase64 = new LLLBase64();
        
        public function LLLSound():void
        {
        }
        
        public function get data():Sound{ return _data }
        public function getData():Sound{ return _data }
        public function setData( data:Sound ):void
        {
            this._data = data;
            _onLoaded();
        }
        
        
        
        private var _readyFormat:String;
        private var _readyCode:String;
        private var _readyData:Sound;
        public function ready( format:String ,data:* ):void
        {
            _readyFormat = format;
            if( data is String )
            {
                _readyCode = data;
            }
            else if( data is Sound )
            {
                _readyData = data;
            }
        }
        
        public function load():void
        {
            switch( _readyFormat )
            {
                case "Base64":
                    loadFromBase64( _readyCode );
                    break;
                case "Sound":
                case null :
                    setData( _readyData );
                    break;
            }
        }
        
        
        public function loadFromBase64( code:String ):void
        {
            // wavかmp3か判断する処理がここに欲しい
            //TODO 20120318 need switcher ( wav , mp3 )
            _base64.code = code;
            _data.addEventListener( Event.COMPLETE, _onLoaded );
            _data.loadPCMFromByteArray( _base64.byteArray, _base64.byteArray.length );
        }
        public function loadPCMFromBase64( code:String ):void
        {
            _base64.code = code;
            _data.addEventListener( Event.COMPLETE, _onLoaded );
            _data.loadPCMFromByteArray( _base64.byteArray, _base64.byteArray.length );
        }
        public function loadCompressedDataFromBase64( code:String ):void
        {
            _base64.code = code;
            _data.addEventListener( Event.COMPLETE, _onLoaded );
            _data.loadCompressedDataFromByteArray( _base64.byteArray, _base64.byteArray.length );
        }
        public function addReceiver( receiver:*, name:String = "sound" ):void
        {
            _receivers.push( { receiver:receiver, name:name } );
        }
        public function removeReceiver( receiver:*, name:String = "sound" ):void
        {
            var index:int = _receivers.indexOf( {receiver:receiver,name:name} );
            if( 0 <= index )
            {
                _receivers[index] = null;
            }
        }
        private function _receive( receiver:*, name:String = "sound" ):void
        {
            receiver[name] = _data;
        }
        private function _receiveAll():void
        {
            var i:int,iMax:int = _receivers.length;
            for( i=0;i<iMax;++i )
            {
                _receive( _receivers[i].receiver, _receivers[i].name );
            }
        }
        private function _onLoaded( event:Event = null ):void
        {
            _receiveAll()
            _base64.clear(); //FIXME 20120312 delete base64
            dispatchEvent( new Event( Event.COMPLETE ) );
        }
    }
    
    // LLLBitmapData ////////////////////////////////////////////////////
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObjectContainer;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.net.URLRequest;
    import flash.system.ImageDecodingPolicy;
    import flash.system.ApplicationDomain;
    import mx.graphics.codec.JPEGEncoder;
    import mx.graphics.codec.PNGEncoder;
    
    /*
    var asset:LLLBitmapData = new LLLBitmapData()
    asset.loadFromBase64( "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQAAAADsdIMmAAAAFUlEQVQImWNgAII0IJRgsGFQYWAAAApIAUVqh9WeAAAAAElFTkSuQmCC" )
    addChild( asset.createBitmap() );
    */
    class LLLBitmapData
    extends EventDispatcher
    {
        public var name:String = null;
        public var editor:LLLBitmapDataEditor;
        private var _receivers:Array = [];
        private var _data:BitmapData;
        private var _base64:LLLBase64 = new LLLBase64();
        private var _loader:Loader;
        
        public function get data():BitmapData{ return _data }
        public function getData():BitmapData{ return _data }
        public function setData( data:BitmapData ):void
        {
            this._data = data;
            _onLoaded();
        }
        
        
        public function LLLBitmapData()
        {
            editor = new LLLBitmapDataEditor( new BitmapData( 1,1,true,0 ) );
        }
        
        
        private var _readyFormat:String;
        private var _readyCode:String;
        private var _readyData:BitmapData;
        public function ready( format:String ,data:* ):void
        {
            _readyFormat = format;
            if( data is String )
            {
                _readyCode = data;
            }
            else if( data is BitmapData )
            {
                _readyData = data;
            }
        }
        public function load():LLLBitmapData
        {
            switch( _readyFormat )
            {
                case "Base64":
                    loadFromBase64( _readyCode );
                    break;
                case "BitmapData":
                case null :
                    setData( _readyData );
                    break;
            }
            return this;
        }
        
        
        public function addLoadedHandler( handler:Function ):LLLBitmapData
        {
            super.addEventListener( Event.COMPLETE ,handler );
            return this;
        } 
        
        public function loadFromBase64( code:String = null ):LLLBitmapData
        {
            code ? code : code = _readyCode;
            _base64.code = code;
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _onLoaded );
            //var loaderContext:LoaderContext = new LoaderContext();
            //loaderContext.imageDecodingPolicy = ImageDecodingPolicy.ON_LOAD;
            _loader.loadBytes( _base64.byteArray  );
            return this;
        }
        public function loadFromZlibBase64( code:String = null ):LLLBitmapData
        {
            code ? code : code = _readyCode;
            _base64.code = code;
            _base64.uncompress( "zlib" );
            _loader = new Loader();
            _loader.loaderInfo.addEventListener( Event.COMPLETE, _onLoaded );
            //var applicationDomain:ApplicationDomain;
            //var loaderContext:LoaderContext = new LoaderContext();
            //loaderContext.applicationDomain = ApplicationDomain.currentDomain.parentDomain;
            //loaderContext.imageDecodingPolicy = ImageDecodingPolicy.ON_LOAD;
            //loaderContext.allowCodeImport = true;
            _loader.loadBytes( _base64.byteArray  );
            return this;
        }
        public function loadFromURI( code:String = null ):LLLBitmapData
        {
            code ? code : code = _readyCode;
            _loader = new Loader();
            _loader.loaderInfo.addEventListener( Event.COMPLETE, _onLoaded );
            _loader.load( new URLRequest( code )  );
            return this;
        }
        
        public function fromAsset( name:String ):LLLBitmapData
        {
            
            return this;
        }
        
        public function addReceiver( receiver:*, name:String = "bitmapData" ):void
        {
            _receivers.push( { receiver:receiver, name:name } );
        }
        public function removeReceiver( receiver:*, name:String = "bitmapData" ):void
        {
            var index:int = _receivers.indexOf( {receiver:receiver,name:name} );
            if( 0 <= index )
            {
                _receivers[index] = null;
            }
        }
        
        public function createBitmap( root:DisplayObjectContainer = null ,x:Number = 0 ,y:Number = 0 ):Bitmap
        {
            var bitmap:Bitmap = new Bitmap( new BitmapData( 1,1,true,0 ) );
            addReceiver( bitmap );
            ( _data ) ? bitmap.bitmapData = _data : null;
            
            bitmap.x = x;
            bitmap.y = y;
            root ? root.addChild( bitmap ) : null;
            
            return bitmap;
        }
        public function toByteArray():ByteArray
        {
            if( _data )
            {
                return _data.getPixels( _data.rect )
            }
            else return null;
        }
        public function toBase64():String
        {
            if( _data )
            {
                var base64:LLLBase64 = new LLLBase64();
                base64.byteArray = _data.getPixels( _data.rect );
                return base64.code;
            }
            else return null;
        }
        public function toPNGByteArray():ByteArray
        {
            if( _data )
            {
                var encoder:PNGEncoder = new PNGEncoder();
                return encoder.encode( _data );
            }
            else return null;
            
        }
        public function toJPEGByteArray():ByteArray
        {
            if( _data )
            {
                var encoder:JPEGEncoder = new JPEGEncoder( 100.0 );
                return encoder.encode( _data );
            }
            else return null;
        }
        
        
        
        
        // private function
        private function _receive( receiver:*, name:String = "bitmapData" ):void
        {
            receiver[name] = _data;
        }
        private function _receiveAll():void
        {
            var i:int,iMax:int = _receivers.length;
            for( i=0;i<iMax;++i )
            {
                _receive( _receivers[i].receiver, _receivers[i].name );
            }
        }
        private function _onLoaded( event:Event = null ):void
        {
            if( _loader )
            {
                _data = Bitmap( _loader.content ).bitmapData;
            }
            _loader = null;
            editor.data = _data;
            _receiveAll()
            _base64.clear(); //FIXME 20120312 delete base64
            dispatchEvent( new Event( Event.COMPLETE ) );
        }
        
        
    }
    import flash.system.Security;
    
    // LLLBitmapDataEditor /////////////////////////////////
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.IBitmapDrawable;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    class LLLBitmapDataEditor
    {
        public var _canvas:BitmapData;
        public var _colorTransform:ColorTransform
        public var _matrix:Matrix
        public var _point:Point
        public var _glowFilter:GlowFilter
        public var _blurFilter:BlurFilter
        public var _displaceFilter:DisplacementMapFilter;
        
        public function LLLBitmapDataEditor( bitmapData:BitmapData = null )
        {
            _colorTransform = new ColorTransform();
            _matrix = new Matrix();
            _point = new Point();
            _blurFilter =  new BlurFilter();
            _glowFilter =  new GlowFilter();
            _displaceFilter =  new DisplacementMapFilter();
        }
        public function set data(value:BitmapData):void{ _canvas = value }
        
        public function open( bitmapData:BitmapData = null ):void
        {
            bitmapData ? _canvas = bitmapData : null;
            _canvas.lock();
        }
        public function close():void
        {
            _canvas.unlock();
        }
        /**/
        public function recolor( targetColor:uint = 0xFFFFFFFF ,replacedColor:uint = 0x00000000 ):void
        {
            var list:Vector.<uint> = _canvas.getVector(_canvas.rect);
            var i:uint,iMax:uint = list.length;
            for(i=0;i<iMax;++i)
            {
                list[i] === targetColor ? list[i] = replacedColor : null;
            }
            _canvas.setVector( _canvas.rect ,list );
        }
        public function scale( xScale:Number = 1.0 ,yScale:Number = 1.0 ):void
        {
            var seal:BitmapData = _canvas.clone();
            fill( 0x00000000 );
            _matrix.a = xScale;
            _matrix.b = 0;
            _matrix.c = 0;
            _matrix.d = yScale;
            _matrix.tx = 0;
            _matrix.ty = 0;
            _canvas.draw( seal ,_matrix );
        }
        /*
            横反転。画像の左右を反転させます。
        */
        public function flipX():void
        {
            var seal:BitmapData = _canvas.clone();
            fill( 0x00000000 );
            _matrix.a = -1.0;
            _matrix.b = 0;
            _matrix.c = 0;
            _matrix.d = 1.0;
            _matrix.tx = seal.rect.width;
            _matrix.ty = 0;
            _canvas.draw( seal ,_matrix );
        }
        /*
            縦反転。画像の上下を反転させます。
        */
        public function flipY():void
        {
            var seal:BitmapData = _canvas.clone();
            fill( 0x00000000 );
            _matrix.a = 1.0;
            _matrix.b = 0;
            _matrix.c = 0;
            _matrix.d = -1.0;
            _matrix.tx = 0;
            _matrix.ty = seal.rect.height;
            _canvas.draw( seal ,_matrix );
        }
        /*
            塗りつぶし。画像全体を任意の色で塗りつぶします。画像をリセットする際などに使います。
            @param color この色で塗りつぶされます。
        */
        public function fill( color:uint = 0x00000000 ):void
        {
            _canvas.fillRect( _canvas.rect ,color );
        }
        /*
            バケツ。指定座標の色と同じ色で繋がっている範囲を任意の色で塗りつぶします。
            @param x 指定する色を持つピクセルの横の座標です。
            @param y 指定する色を持つピクセルの縦の座標です。
            @param color この色で塗りつぶされます。
        */
        public function bucket( x:int = 0 ,y:int = 0 ,color:uint = 0x00000000 ):void
        {
            _canvas.floodFill( x ,y ,color );
        }
        /*
            スポイト。指定座標の色を取得します。
            @param x 指定する色を持つピクセルの横の座標です。
            @param y 指定する色を持つピクセルの縦の座標です。
        */
        public function spoit( x:uint = 0 ,y:uint = 0 ):uint
        {
            return _canvas.getPixel32( x ,y );
        }
        public function colorAdd( alpha:int ,red:int ,green:int ,blue:int ):void
        {
            _colorTransform.alphaOffset = alpha;
            _colorTransform.redOffset   = red;
            _colorTransform.greenOffset = green;
            _colorTransform.blueOffset  = blue;
            _colorTransform.alphaMultiplier = 1.0;
            _colorTransform.redMultiplier   = 1.0;
            _colorTransform.greenMultiplier = 1.0;
            _colorTransform.blueMultiplier  = 1.0;
            _canvas.colorTransform( _canvas.rect ,_colorTransform )
        }
        /*
            ブラー。画像をぼかします。
            @param x 横方向へのぼかしの度合いです。
            @param y 縦方向へのぼかしの度合いです。
        */
        public function blur( x:Number = 1.0 ,y:Number = 1.0 ):void
        {
            _blurFilter.blurX = x;
            _blurFilter.blurY = y;
            _point.x = 0;
            _point.y = 0;
            _canvas.applyFilter( _canvas ,_canvas.rect ,_point ,_blurFilter );
        }
        /*
            グロウ。画像を発光させます。透明なピクセルは無視されます。
            @param x 横方向への発光の度合いです。
            @param y 縦方向への発光の度合いです。
            @param color 発光の色です。 
            @param strength 発光の外周の輪郭のぼかし具合です。値が大きいほど輪郭がはっきりします。
        */
        public function glow( x:Number = 1.0 ,y:Number = 1.0 ,color:uint = 0xFFFFFF ,strength:Number = 0 ):void
        {
            _glowFilter.blurX = x;
            _glowFilter.blurY = y;
            _glowFilter.color = color;
            _glowFilter.strength = strength;
            _point.x = 0;
            _point.y = 0;
            _canvas.applyFilter( _canvas ,_canvas.rect ,_point ,_blurFilter );
        }
        public function displace( x:Number ,y:Number ,brush:BitmapData ,xChannels:uint ,yChannels:uint ):void
        {
            _displaceFilter.componentX = RED | GREEN | BLUE;
            _displaceFilter.componentY = RED | GREEN | BLUE;
            _displaceFilter.alpha  = 0.0;
            _displaceFilter.scaleX = 1.0;
            _displaceFilter.scaleY = 1.0;
            _displaceFilter.mode   = DisplacementMapFilterMode.CLAMP;
            _displaceFilter.color  = 0x000000;
            _displaceFilter.mapBitmap = brush;
            _point.x = int(x);
            _point.y = int(y);
            _displaceFilter.mapPoint = _point;
            
            
        }
        
        private const ALPHA:uint = 0x8;
        private const RED  :uint = 0x4;
        private const GREEN:uint = 0x2;
        private const BLUE :uint = 0x1;
    }
    
    
    
    
    
    
    
    
    
    
    class LLLPosition
    {
        public function add( a:Vector3D, b:Vector3D ):void
        {
            a.x = a.x + b.x;
            a.y = a.y + b.y;
        }
        public function accelerate( a:Vector3D, b:Vector3D ):void
        {
            // もし現在値が 0 であれば、加算する。
            // もし現在地が 0 以下であれば、減算する。
            // もし現在地が 0 以上であれば、加算する。
            ( a.x === 0 ) ? ( a.x = a.x + b.x ) : ( a.x < 0 ) ? a.x = a.x - b.x : a.x = a.x + b.x;
            ( a.y === 0 ) ? ( a.y = a.y + b.y ) : ( a.y < 0 ) ? a.y = a.y - b.y : a.y = a.y + b.y;
        }
        public function decelerate( a:Vector3D, b:Vector3D ):void
        {
            // もし現在値が 0 であれば、何もしない。
            // もし現在地が 0 以下であれば、加算し、0 以上になったら 0 にする。
            // もし現在地が 0 以上であれば、減算し、0 以下になったら 0 にする。
            ( a.x === 0 ) ? null : ( a.x < 0 ) ? ( 0 < ( a.x + b.x ) ) ? ( a.x = 0 ) : ( a.x = a.x + b.x ) : ( ( a.x - b.x ) < 0 ) ? ( a.x = 0 ) : ( a.x = a.x - b.x );
            ( a.y === 0 ) ? null : ( a.y < 0 ) ? ( 0 < ( a.y + b.y ) ) ? ( a.y = 0 ) : ( a.y = a.y + b.y ) : ( ( a.y - b.y ) < 0 ) ? ( a.y = 0 ) : ( a.y = a.y - b.y );
        }
    }
    
    
    
    
    
    
    
    
    
    
    // LLLBase64 ////////////////////////////////////////////////////
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;
    import mx.utils.Base64Encoder;
    class LLLBase64
    {
        private var _byteArray:ByteArray;
        private var _code:String;
        private var _decoder:Base64Decoder = new Base64Decoder()
        private var _encoder:Base64Encoder = new Base64Encoder()
        public function get code():String{ return _code; }
        public function set code( value:String ):void
        {
            ( _decoder ) ? null : _decoder = new Base64Decoder();
            _decoder.decode( value );
            _byteArray = _decoder.toByteArray();
            _byteArray.position = 0;
            _decoder.reset();
        } 
        public function get byteArray():ByteArray{ return _byteArray; }
        public function set byteArray( value:ByteArray ):void
        {
            ( _encoder ) ? null : _encoder = new Base64Encoder();
            _encoder.insertNewLines = false;
            
            _encoder.encodeBytes( value, 0, value.length );
            _code = _encoder.toString();
            _encoder.reset();
        }
        public function uncompress( type:String = "zlib" ):void
        {
            _byteArray ? _byteArray.uncompress( type ) : null;
        }
        public function compress( type:String = "zlib" ):void
        {
            _byteArray ? _byteArray.compress( type ) : null;
        }
        public function clear():void
        {
            _byteArray = null;
            _code = null;
            _decoder = null;
            _encoder = null;
        }
        
    }
    
    
    
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    //FIXME 20120312 create
    class LLLZipLoader
    {
        
    }

    
    

    
    
    
    /*
    var qwn:Qwn = new Qwn();
    qwn.timeline.add( 0.001, callback );
    qwn.frameline.add( 100, callback );
    */
    import flash.events.Event;
    import flash.events.EventDispatcher;
    class Qwn
    extends EventDispatcher
    {
        public var frameline:QwnFrameline;
        public var timeline:QwnTimeline;
        
        public function Qwn()
        {
            frameline = new QwnFrameline();
            timeline = new QwnTimeline();
        }
        
    }
    
    
    /*
    add( 0.001, callback );
    */
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.utils.clearTimeout;
    import flash.utils.getTimer;
    import flash.utils.setTimeout;
    class QwnTimeline
    extends EventDispatcher
    {
        public var list:Array = [];
        public var _duration:int = 1;
        public var index:uint = 0;
        public var _time:Number = 0;
        public var _startTime:Number = 0;
        public var _stopTime:Number = 0;
        
        public function QwnTimeline()
        {
            
        }
        public function play( duration:int = 0 ):void
        {
            duration ? _duration = duration : null;
            load();
            _startTime = getTimer();
        }
        public function stop():void
        {
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                if( list[i].played === false )
                {
                    clearTimeout( list[i].id );
                    clearTimeout( list[i].onPlayedID );
                }
            }
            _stopTime = getTimer();
            _time = _stopTime - _startTime;
        }
        public function load():void
        {
            list.sortOn( "time" ,Array.NUMERIC )
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                list[i].index = i;
            }
            
            for(i=0;i<iMax;++i)
            {
                if( list[i].played === false )
                {
                    list[i].id = setTimeout( list[i].callback ,( list[i].time * 1000 ) - _time );
                    list[i].onPlayedID = setTimeout( list[i].onPlayed ,( list[i].time * 1000 ) - _time );
                }
            }
        }
        public function add( time:Number, callback:Function ):QwnTimeline
        {
            var item:QwnTimelineItem;
            item = new QwnTimelineItem();
            item.parent = this;
            item.time = time;
            item.callback = callback;
            list[list.length] = item;
            
            return this;
        }
        public function fromArray( list:Array ):QwnTimeline
        {
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                add( list[i][0], list[i][1] )
            }
            return this;
        }
        public function onItemTimeout( index:int ):void
        {
            if( index === list.length - 1 )
            {
                if( 2 <= _duration )
                {
                    _duration--;
                    reset();
                    load();
                    return;
                }
                else if( 0 === _duration )
                {
                    stop();
                    return
                }
                else if( _duration <= -1 )
                {
                    _duration = -1;
                    reset();
                    load();
                    return;
                }
            }
        }
        public function reset():void
        {
            _time = 0;
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                list[i].played = false;
            }
        }
    }
    class QwnTimelineItem
    {
        public var parent:QwnTimeline
        public var id:uint = 0;
        public var index:int = 0;
        public var time:Number = 0;
        public var callback:Function = null;
        public var played:Boolean = false;
        public var onPlayedID:uint = 0;
        public function onPlayed():void
        {
            played = true;
            parent.onItemTimeout( index );
        }
    }
    
    // Frameline //////////////////////////////////////
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    class QwnFrameline
    extends EventDispatcher
    {
        public var line:Array = [];
        public var list:Array = [];
        private var _bitmap:Bitmap
        public var _frameCount:uint = 0;
        public var _i:uint = 0;
        public var _loaded:Boolean = false;
        public var _playing:Boolean = false;
        public var _duration:int = 1;
        public var _completed:Boolean = false;
        
        public function QwnFrameline()
        {
            _bitmap = new Bitmap( new BitmapData( 1,1,true,0 ) );
            _bitmap.addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        }
        private function _onEnterFrame( event:Event ):void
        {
            if( _playing && _duration )
            {
                var iWhile:int = 0;
                while( list[_i].frameIndex === _frameCount )
                {
                    if( 100 < iWhile )
                    {
                        stop();
                        return;
                    }
                    ++iWhile;
                    
                    
                    list[_i].callback();
                    ++_i
                    if( list.length === _i )
                    {
                        // 末端まで再生したら、残数を -= 1 する
                        // 残数が 0 なら、再生をやめる
                        // 残数が 2 以上なら、もう一度再生する
                        if( 2 <= _duration )
                        {
                            _duration--;
                            _i = 0;
                            _frameCount = 0;
                            return;
                        }    
                        else if( 1 === _duration )
                        {
                            _duration = 0;
                            stop();
                            return;
                        }
                        else
                        {
                            _i = 0;
                            _frameCount = 0;
                            return;
                        }
                    }
                    
                }
                ++_frameCount;
            }
            
        }
        public function loop( duration:int = -1 ):void
        {
            _duration = duration;
            play( duration );
        }
        public function play( duration:int = 0 ):void
        {
            duration ? _duration = duration : null;
            _loaded ? null : load();
            _playing = true;
        }
        public function stop():void
        {
            _playing = false;
        }
        public function togglePlayStop():void
        {
            
        }
        public function seek( index:uint ):void
        {
            
        }
        public function reset( index:uint ):void
        {
            
        }
        
        public function add( frameIndex:uint, callback:Function ):QwnFrameline
        {
            var item:QwnFramelineItem;
            item = new QwnFramelineItem();
            item.frameIndex = frameIndex;
            item.callback = callback;
            
            list[list.length] = item;
            return this;
        }
        public function load():void
        {
            list.sortOn( "frameIndex", Array.NUMERIC );
            _loaded = true;
        }
        public function fromArray( list:Array ):QwnFrameline
        {
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                add( list[i][0], list[i][1] )
            }
            return this;
        }
    }
    class QwnFramelineItem
    {
        public var id:uint = 0;
        public var frameIndex:uint = 0;
        public var callback:Function = null;
        public var played:Boolean = false;
    }
    
    
    
    
    
    
    
    
    
    
    
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    /////////////////////   L  L  L   //////////////////////////////
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    import flash.display.InteractiveObject;
    import flash.display.Stage;
    import flash.events.Event;
    class LLL
    {
        static private var _root:InteractiveObject;
        static private var _stage:Stage;
        static public var input:LLLInput
        static public var stage:LLLStage
        static public var assets:LLLAssets
        static public var game:LLLGame
        static public var contextMenu:LLLContextMenu;
        
        static public function init( stage:Stage, root:InteractiveObject ):void
        {
            _root = root;
            _stage = stage;
            LLL.input = new LLLInput( _stage );
            LLL.stage = new LLLStage( _stage );
            LLL.assets = new LLLAssets();
            LLL.tracer = new LLLTracer();
            LLL.contextMenu = new LLLContextMenu( _root );
            LLL.game = new LLLGame();
        }
        
        static public var tracer:LLLTracer;
        static public function trace():void
        {
            
        }
    }
    
    
    class LLLGame
    {
        public var dice:LLLGameDice;
        
        public function LLLGame()
        {
            dice = new LLLGameDice();
        }
    }
    
    class LLLGameDice
    {
        public function roll( duration:uint = 1 ,pipCount:uint = 6 ,offset:int = 0 ):uint
        {
            var result:uint = 0;
            while( duration )
            {
                // Math.random() は 0 以上、1 未満の値を返す。( 0 <= n < 1 )
                // サイコロに 0 の目は無い。+1 する。
                result = result + uint( Math.random() * pipCount ) + 1;
                --duration;
            }
            result = result + offset;
            return result;
        }
        public function judge( duration:uint = 2 ,pipCount:uint = 6 ,border:uint = 4 ):uint
        {
            var result:uint = 0;
            while( duration )
            {
                if( border <= ( uint( Math.random() * pipCount ) + 1 ) )
                {
                    ++result;
                }
                
                
                // ! important
                --duration;
            }
            return result;
        }
    }
    
    
    // LLLTracer ///////////////////////////////////////////////////
    class LLLTracer
    {
        public var log:Array = [];
        
        public function trace( message:String ):void
        {
            
        }
    }
    
    
    // LLLInput ///////////////////////////////////////////////////
    import flash.display.InteractiveObject;
    import flash.utils.Dictionary;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    class LLLInput
    {
        private var _target:InteractiveObject;
        public var keyCodes:Array = [];
        public var dictionary:Dictionary;
        public var flashActivated:Boolean = true;
        public var stage:Stage;
        public var keyCount:int = 0;
        public var lastDownKeyCode:uint = 0;
        public var lastUpKeyCode:uint = 0;
        
        public var gyro:LLLInputGyro;
        public var touch:LLLInputTouch;
        
        public var x:Number = 0;
        public var y:Number = 0;
        public var delta:int = 0;
        public var pressure:Number = 0;
        
        public var downX:Number = 0;
        public var downY:Number = 0;
        public var upX:Number = 0;
        public var upY:Number = 0;
        public var radian:Number = 0;
        public var radianType:String = null;
        
        public var mouseLeftKeyCode:uint = 0x00001000;
        public var mouseRightKeyCode:uint = 0x00001001;
        public var mouseMiddleKeyCode:uint = 0x00001002;
        public var mouseWheelUpKeyCode:uint = 0x00001003;
        public var mouseWheelDownKeyCode:uint = 0x00001004;
        
        
        
        public function LLLInput( target:InteractiveObject ):void
        {
            _target = target;
            
            keyCodes = [];
            dictionary = new Dictionary();
            gyro = new LLLInputGyro();
            touch = new LLLInputTouch( _target );
            
            defaultBinder = 
            [
                 [0x00, "ANY"]
                ,[0x01, "MOUSE_LEFT"]
                ,[0x02, "MOUSE_RIGHT"]
                ,[0x04, "MOUSE_MIDDLE"]
                ,[0x08, "BACKSPACE"]
                ,[0x09, "TAB"]
                ,[0x0C, "CLEAR"]
                ,[0x0D, "ENTER"]
                ,[0x0F, "COMMAND"]
                ,[0x10, "SHIFT"]
                ,[0x11, "CTRL"]
                ,[0x11, "CONTROL"]
                ,[0x12, "ALT"]
                ,[0x12, "ALTERNATE"]
                ,[0x13, "PAUSE_BREAK"]
                ,[0x14, "CAPSLOCK"]
                ,[0x14, "CAPTAL"]
                ,[0x15, "NUMPAD"]
                ,[0x1B, "ESC"]
                ,[0x1B, "ESCAPE"]
                ,[0x1C, "CONVERT"]
                ,[0x20, " "]
                ,[0x21, "PAGE_UP"]
                ,[0x22, "PAGE_DOWN"]
                ,[0x23, "END"]
                ,[0x24, "HOME"]
                ,[0x25, "LEFT"]
                ,[0x26, "UP"]
                ,[0x27, "RIGHT"]
                ,[0x28, "DOWN"]
                ,[0x2E, "DELETE"]
                ,[0x2D, "INSERT"]
                ,[0x30, "0"]
                ,[0x31, "1"]
                ,[0x32, "2"]
                ,[0x33, "3"]
                ,[0x34, "4"]
                ,[0x35, "5"]
                ,[0x36, "6"]
                ,[0x37, "7"]
                ,[0x38, "8"]
                ,[0x39, "9"]
                ,[0x41, "A"]
                ,[0x42, "B"]
                ,[0x43, "C"]
                ,[0x44, "D"]
                ,[0x45, "E"]
                ,[0x46, "F"]
                ,[0x47, "G"]
                ,[0x48, "H"]
                ,[0x49, "I"]
                ,[0x4A, "J"]
                ,[0x4B, "K"]
                ,[0x4C, "L"]
                ,[0x4D, "M"]
                ,[0x4E, "N"]
                ,[0x4F, "O"]
                ,[0x50, "P"]
                ,[0x51, "Q"]
                ,[0x52, "R"]
                ,[0x53, "S"]
                ,[0x54, "T"]
                ,[0x55, "U"]
                ,[0x56, "V"]
                ,[0x57, "W"]
                ,[0x58, "X"]
                ,[0x59, "Y"]
                ,[0x5A, "Z"]
                ,[0x60, "NUMPAD_0"]
                ,[0x61, "NUMPAD_1"]
                ,[0x62, "NUMPAD_2"]
                ,[0x63, "NUMPAD_3"]
                ,[0x64, "NUMPAD_4"]
                ,[0x65, "NUMPAD_5"]
                ,[0x66, "NUMPAD_6"]
                ,[0x67, "NUMPAD_7"]
                ,[0x68, "NUMPAD_8"]
                ,[0x69, "NUMPAD_9"]
                ,[0x6A, "NUMPAD_MULTIPLY"]
                ,[0x6B, "NUMPAD_ADD"]
                ,[0x6C, "NUMPAD_ENTER"]
                ,[0x6D, "NUMPAD_SUBTRACT"]
                ,[0x6E, "NUMPAD_DECIMAL"]
                ,[0x6F, "NUMPAD_DIVIDE"]
                ,[0x70, "F1"]
                ,[0x71, "F2"]
                ,[0x72, "F3"]
                ,[0x73, "F4"]
                ,[0x74, "F5"]
                ,[0x75, "F6"]
                ,[0x76, "F7"]
                ,[0x77, "F8"]
                ,[0x78, "F9"]
                ,[0x79, "F10"]
                ,[0x7A, "F11"]
                ,[0x7B, "F12"]
                ,[0x90, "NUMLOCK"]
                ,[0xC0, "@"]
                ,[0xBA, ":"]
                ,[0xBB, ";"]
                ,[0xBB, "="]
                ,[0xBB, "EQUAL"]
                ,[0xBC, ","]
                ,[0xBE, "."]
                ,[0xBF, "/"]
                ,[0xBF, "SLASH"]
                ,[0xDB, "["]
                ,[0xC0, "`"]
                ,[0xC0, "BACKQUOTE"]
                ,[0xDB, "LEFTBRACKET"]
                ,[0xDC, "\\"]
                ,[0xDC, "BACKSLASH"]
                ,[0xDD, "]"]
                ,[0xDD, "RIGHTBRACKET"]
                ,[0xE2, "YEN"]
                ,[0xF3, "ZENKAKU"]
                ,[0xF4, "HANKAKU"]
                ,[0x00001000, "MOUSE_LEFT"]
                ,[0x00001001, "MOUSE_RIGHT"]
                ,[0x00001002, "MOUSE_MIDDLE"]
                ,[0x00001003, "MOUSE_WHEEL_UP"]
                ,[0x00001004, "MOUSE_WHEEL_DOWN"]
                ,[0x01000000, "RED"]
                ,[0x01000001, "GREEN"]
                ,[0x01000002, "YELLOW"]
                ,[0x01000003, "BLUE"]
                ,[0x01000004, "CHANNEL_UP"]
                ,[0x01000005, "CHANNEL_DOWN"]
                ,[0x01000006, "RECORD"]
                ,[0x0100000B, "REWIND"]
                ,[0x01000007, "PLAY"]
                ,[0x01000008, "PAUSE"]
                ,[0x0100000A, "FAST_FOWARD"]
                ,[0x0100000C, "SKIP_FORWARD"]
                ,[0x0100000D, "SKIP_BACKWARD"]
                ,[0x0100000E, "NEXT"]
                ,[0x0100000F, "PREVIOUS"]
                ,[0x01000009, "STOP"]
                ,[0x01000010, "LIVE"]
                ,[0x01000011, "LAST"]
                ,[0x01000012, "MENU"]
                ,[0x01000013, "INFO"]
                ,[0x01000014, "GUIDE"]
                ,[0x01000015, "EXIT"]
                ,[0x01000016, "BACK"]
                ,[0x01000017, "AUDIO"]
                ,[0x01000018, "SUBTITLE"]
                ,[0x01000019, "DVR"]
                ,[0x0100001A, "VOD"]
                ,[0x0100001B, "INPUT"]
                ,[0x0100001C, "SETUP"]
                ,[0x0100001D, "HELP"]
                ,[0x0100001E, "MASTER_SHELL"]
                ,[0x0100001F, "SEARCH"]
            ];
            setDictionaryFromArray( defaultBinder );
            
            
            _target.addEventListener( Event.ACTIVATE         ,onFlashActivate );
            _target.addEventListener( Event.DEACTIVATE       ,onFlashDeactivate );
            _target.addEventListener( Event.MOUSE_LEAVE      ,onFlashLeave );
            _target.addEventListener( KeyboardEvent.KEY_DOWN ,onKeyboardDown );
            _target.addEventListener( KeyboardEvent.KEY_UP   ,onKeyboardUp );
            _target.addEventListener( MouseEvent.MOUSE_DOWN  ,onMouseDown );
            _target.addEventListener( MouseEvent.MOUSE_UP    ,onMouseUp );
            _target.addEventListener( MouseEvent.MOUSE_MOVE  ,onMouseMove );
            _target.addEventListener( MouseEvent.MOUSE_WHEEL ,onMouseWheel );
        }
        
        private var _binds:Dictionary;
        public function $( name:String, bind:String = null ):Boolean
        {
            _binds ? null : _binds = new Dictionary();
            if( bind )
            {
                var item:String,list:Array = bind.split(" ");
                var i:int,iMax:int = list.length;
                for(i=0;i<iMax;++i) 
                {
                    list[i] = list[i].split("+");
                }
                _binds[name] = list;
                return false;
            }
            else
            {
                return getKey( _binds[name] );
            }
        }
        private var _axisBinds:Dictionary;
        public function $axis( name:String, minusBind:String = null, plusBind:String = null ):int
        {
            _axisBinds ? null : _axisBinds = new Dictionary();
            if( minusBind && plusBind )
            {
                var list:Array = [minusBind.split(" "),plusBind.split(" ")]
                var i:int,iMax:int = list[0].length;
                for(i=0;i<iMax;++i) 
                {
                    list[0][i] = list[0][i].split("+");
                }
                
                iMax = list[1].length;
                for(i=0;i<iMax;++i) 
                {
                    list[1][i] = list[1][i].split("+");
                }
                _axisBinds[name] = list;
                return 0;
            }
            else
            {
                return getAxis( _axisBinds[name][0] ,_axisBinds[name][1] );
            }
        }
        
        
        public function onKeyboardDown( event:KeyboardEvent = null ):void
        {
            ++keyCount;
            keyCodes [event.keyCode] = true;
            lastDownKeyCode = event.keyCode;
        }
        public function onKeyboardUp( event:KeyboardEvent = null ):void
        {
            keyCount !== 0 ? --keyCount : null;
            keyCodes [event.keyCode] = false;
            lastUpKeyCode = event.keyCode;
        }
        public function onMouseDown( event:MouseEvent = null ):void
        {
            ++keyCount;
            keyCodes[mouseLeftKeyCode] = true;
            lastDownKeyCode = mouseLeftKeyCode;
            
            downX = stage.mouseX;
            downY = stage.mouseY;
        }
        public function onMouseUp( event:MouseEvent = null ):void
        {
            keyCount !== 0 ? --keyCount : null;
            keyCodes[mouseLeftKeyCode] = false;
            lastUpKeyCode = mouseLeftKeyCode;
            
            upX = stage.mouseX;
            upY = stage.mouseY;
            
            radian = Math.atan2( upX - downX, upY - downY );
        }
        public function onMouseWheel( event:MouseEvent = null ):void
        {
            delta = event.delta;
            if( delta )
            {
                if( delta < 0 )
                {
                    keyCodes[mouseWheelUpKeyCode]   = true;
                    keyCodes[mouseWheelDownKeyCode] = false;
                }
                else
                {
                    keyCodes[mouseWheelUpKeyCode]   = false;
                    keyCodes[mouseWheelDownKeyCode] = true;
                    
                }
            }
            else
            {
                keyCodes[mouseWheelUpKeyCode]   = false;
                keyCodes[mouseWheelDownKeyCode] = false;
            }
        }
        public function onMouseMove( event:MouseEvent = null ):void
        {
            x = stage.mouseX;
            y = stage.mouseY;
        }
        public function onFlashActivate( event:Event = null ):void
        {
            flashActivated = true;
            keyCount = 0;
        }
        public function onFlashDeactivate( event:Event = null ):void
        {
            flashActivated = false;
            keyCount = 0;
        }
        public function onFlashLeave( event:Event = null ):void
        {
            flashActivated = false;
            keyCount = 0;
        }
        
        
        
        public function setDictionaryFromArray( list:Array ):void
        {
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                ( list[i] ) ? addDictionaryItem( list[i][0], list[i][1] ) : null;
            }
        }
        public function addDictionaryItem( keyCode:uint, token:String ):void
        {
            dictionary[token] = keyCode;
        }
        
        
        
        public function atKeyCode( keyCode:uint ):Boolean
        {
            if( keyCodes[keyCode] ) return true;
            else return false;
        }
        public function ofToken( token:* ):Boolean
        {
            if( token is uint )
            {
                return atKeyCode( token )
            }
            else if( token is String )
            {
                if( dictionary[token] )
                {
                    return atKeyCode( dictionary[token] );
                }
                else return false;
            }
            else return false;
        }
        
        
        
        public function getKey( key:* ):Boolean
        {
            
            if( key is Array )
            {
                return merge( andFilter, key, ofToken );
            }
            else if( key is String )
            {
                if( dictionary[key] )
                {
                    return merge( andFilter, [[dictionary[key]]], ofToken );
                }
                else return false;
            }
            else if( key is uint )
            {
                return merge( andFilter, [[key]], ofToken );
            }
            else return false;
            
            
        }
        
        public function getAxis( minusKey:*, plusKey:* ):int
        {
            var minusCode:int = 0;
            var plusCode:int = 0;
            
            minusCode = uint( getKey( minusKey ) );
            plusCode = uint( getKey( plusKey ) );
            
            return ( plusCode - minusCode );
        }
        
        /*
        配列に対して関数を実行し、その返り値（Boolean）を合併させる。
        */
        public function merge( filter:Function, list:Array, callback:Function ):Boolean
        {
            var result:int = 0;
            
            var i:int,iMax:int = list.length;
            for(i=0;i<iMax;++i)
            {
                result = ( result | uint( filter( list[i], callback ) ) );
            }
            
            return Boolean( result );
        }
        
        /**/
        public function andFilter( list:Array, callback:Function ):Boolean
        {
            var count:int = 0;
            
            var i:uint,iMax:uint = list.length;
            for(i=0;i<iMax;++i)
            {
                count = count + int( callback( list[i] ) );
            }
            
            if( count === list.length )
            {
                return true;
            }
            else
            {
                return false;
            }
            
        }
        
        
        
        /* binder
        キーの名前と番号の入った配列。これを任意で差し替えることでキー設定を変えやすくする。
        [
            [keycode, keyname],
            [keycode, keyname]
        ]
        */
        private var binder:Array = [];
        private var binders:Dictionary;
        public var defaultBinder:Array = [];
        public function getBinder( name:String = null ):Array
        {
            if( name )
            {
                return binders[name];
            }
            else
            {
                return binder;
            }
        }
        public function resetBinder():void
        {
            setDictionaryFromArray( defaultBinder );
        }
        public function setBinder( name:String ,binder:Array = null ):void
        {
            if( binders == null )
            {
                binders = new Dictionary();
            }
            
            binders[name] = binder
        }
        public function changeBinder( name:String ):void
        {
            binder = binders[name];
            setDictionaryFromArray( binder );
            
        }
        
        public function get debugText():String
        {
            var result:String = ""
            + "last up   keyCode: 0x" + lastUpKeyCode.toString( 16 ) + "  " + lastUpKeyCode.toString()
            + "\n"
            + "last down keyCode: 0x" + lastDownKeyCode.toString( 16 ) + "  " + lastDownKeyCode.toString()
            
            
            return result;
        }
        
    }
    
    
    // LLLGyro ////////////////////////////////////////////////////////////////////////////
    import flash.sensors.Accelerometer;
    import flash.events.AccelerometerEvent;
    class LLLInputGyro
    {
        public var x:Number = 0;
        public var y:Number = 0;
        public var z:Number = 0;
        public var timestamp:Number = 0;
        
        private var _accelerometer:Accelerometer;
        private var _delay:Number = 0;
        
        public function LLLInputGyro( delay:Number = 0 )
        {
            _accelerometer = new Accelerometer();
            delay = ( 1 / 60 );
            _accelerometer.addEventListener( AccelerometerEvent.UPDATE, _onUpdate );
        }
        public function get muted():Boolean{ return _accelerometer.muted; }
        public function get equipped():Boolean{ return Accelerometer.isSupported; }
        
        public function get delay():Number{ return _delay; }
        public function set delay( value:Number ):void
        {
            _delay = value;
            _accelerometer.setRequestedUpdateInterval( value );
        }
        
        private function _onUpdate( event:AccelerometerEvent ):void
        {
            x = event.accelerationX;
            y = event.accelerationY;
            z = event.accelerationZ;
            timestamp = event.timestamp;
        }
    }
    
    // Touch /////////////////////////////////////////////////////////////
    import flash.display.InteractiveObject;
    import flash.events.TouchEvent; // TOUCH_BEGIN TOUCH_END TOUCH_MOVE TOUCH_OUT TOUCH_OVER TOUCH_ROLL_OUT TOUCH_ROLL_OVER TOUCH_TAP
    class LLLInputTouch
    {
        private var _items:Array = [];
        private var _target:InteractiveObject
        public function LLLInputTouch( target:InteractiveObject )
        {
            _target = target;
            activate();
        }
        public function activate():void
        {
            _target.addEventListener( TouchEvent.TOUCH_BEGIN     ,onTouchBegin    );
            _target.addEventListener( TouchEvent.TOUCH_END       ,onTouchEnd      );
            _target.addEventListener( TouchEvent.TOUCH_MOVE      ,onTouchMove     );
            _target.addEventListener( TouchEvent.TOUCH_OUT       ,onTouchOut      );
            _target.addEventListener( TouchEvent.TOUCH_OVER      ,onTouchOver     );
            _target.addEventListener( TouchEvent.TOUCH_ROLL_OUT  ,onTouchRollOut  );
            _target.addEventListener( TouchEvent.TOUCH_ROLL_OVER ,onTouchRollOver );
            _target.addEventListener( TouchEvent.TOUCH_TAP       ,onTouchTap      );
        }
        public function deactivate():void
        {
            _target.removeEventListener( TouchEvent.TOUCH_BEGIN     ,onTouchBegin    );
            _target.removeEventListener( TouchEvent.TOUCH_END       ,onTouchEnd      );
            _target.removeEventListener( TouchEvent.TOUCH_MOVE      ,onTouchMove     );
            _target.removeEventListener( TouchEvent.TOUCH_OUT       ,onTouchOut      );
            _target.removeEventListener( TouchEvent.TOUCH_OVER      ,onTouchOver     );
            _target.removeEventListener( TouchEvent.TOUCH_ROLL_OUT  ,onTouchRollOut  );
            _target.removeEventListener( TouchEvent.TOUCH_ROLL_OVER ,onTouchRollOver );
            _target.removeEventListener( TouchEvent.TOUCH_TAP       ,onTouchTap      );
        }
        public function onTouchBegin    ( event:TouchEvent ):void{ parse(event) }
        public function onTouchEnd      ( event:TouchEvent ):void{ parse(event) }
        public function onTouchMove     ( event:TouchEvent ):void{ parse(event) }
        public function onTouchOut      ( event:TouchEvent ):void{ parse(event) }
        public function onTouchOver     ( event:TouchEvent ):void{ parse(event) }
        public function onTouchRollOut  ( event:TouchEvent ):void{ parse(event) }
        public function onTouchRollOver ( event:TouchEvent ):void{ parse(event) }
        public function onTouchTap      ( event:TouchEvent ):void{ parse(event) }
        
        public function parse( event:TouchEvent ):void
        {
            !( _items[event.touchPointID] ) ? _items[event.touchPointID] = new LLLInputTouchItem() : null;
            
            var item:LLLInputTouchItem = _items[event.touchPointID];
            item.mode = "move";
            item.id = event.touchPointID
            item.sizeX = event.sizeX;
            item.sizeY = event.sizeY;
            item.x = event.localX;
            item.y = event.localY;
            item.pressure = event.pressure;
        }
    }
    class LLLInputTouchItem
    {
        public var mode:String = null;
        public var id:int = 0;
        public var pressure:Number = 0;
        public var x:Number = 0;
        public var y:Number = 0;
        public var sizeX:Number = 0;
        public var sizeY:Number = 0;
    }
    
    
        
    
    
    // LLLClipboard ////////////////////////////
    import flash.desktop.Clipboard;
    import flash.desktop.ClipboardFormats;
    /*
    clipboard.setData( data )
    clipboard.getData()
    */
    class LLLClipboard
    {
        public function LLLClipboard()
        {
            
        }
        public function getString():String
        {
            return String( Clipboard.generalClipboard.getData( ClipboardFormats.TEXT_FORMAT ) )
        }
        public function setString( value:String ):void
        {
            Clipboard.generalClipboard.setData( ClipboardFormats.TEXT_FORMAT, value );
        }
        public function getByteArray():ByteArray
        {
            return ByteArray( Clipboard.generalClipboard.getData( ClipboardFormats.RICH_TEXT_FORMAT ) );
        }
        public function setByteArray(value:ByteArray):void
        {
            Clipboard.generalClipboard.setData( ClipboardFormats.RICH_TEXT_FORMAT, value )
        }
        
        public function clear():void{ Clipboard.generalClipboard.clear(); }
        
        /**/
        // TODO 20120319 
        // http://help.adobe.com/ja_JP/FlashPlatform/reference/actionscript/3/flash/desktop/Clipboard.html#setDataHandler%28%29
        public function setDataHandler(format:String, handler:Function, serializable:Boolean = true):void
        {
            Clipboard.generalClipboard.setDataHandler( format, handler, serializable);
        }
    }
    
    
    
    // LLLContextMenu ///////////////////////////////////////////
    import com.adobe.viewsource.ViewSource; // addMenuItem( InteractiveObject, uri, hideBuildIns ) // http://help.adobe.com/ja_JP/FlashPlatform/reference/actionscript/3/com/adobe/viewsource/ViewSource.html
    import flash.display.InteractiveObject;
    import flash.events.Event;
    import flash.events.ContextMenuEvent;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuBuiltInItems;
    import flash.ui.ContextMenuClipboardItems;
    import flash.ui.ContextMenuItem;
    /*
        {
            var contextMenu:LLLContextMenu = new LLLContextMenu( this );
            contextMenu.setHandlerMenu( menuOpen );
        }
        public function menuOpen():void
        {
            addChild( new Bitmap( new BitmapData( 10,10,false,0x000000 ) );
        }
    */
    class LLLContextMenu
    {
        private var _target:InteractiveObject;
        private var _items:Array = [];
        
        public function createThis( target:InteractiveObject ):LLLContextMenu{ return new LLLContextMenu( target ) }
        public function LLLContextMenu( target:InteractiveObject )
        {
            _target = target;
            _items = [];
            _target.contextMenu = new ContextMenu();
        }
        
        //TODO 20120319 on and off  contextMenu.buildinItems
        public function builtInItemsOn():void
        {
            //target.contextMenu.hideBuiltInItems();
        }
        public function builtInItemsOff():void
        {
            _target.contextMenu.hideBuiltInItems();
        }
        
        public function fromArray( list:Array ):void
        {
            
        }
        
        public function clear():void
        {
            _target.contextMenu.customItems = _items;
            _target.contextMenu.hideBuiltInItems();
        }
        public function addCallback( eventType:String ,callback:Function ):void
        {
            switch( eventType )
            {
                case ContextMenuEvent.MENU_SELECT :
                case ContextMenuEvent.MENU_ITEM_SELECT :
                    _target.addEventListener( eventType, callback );
                    break;
                default :
                    _target.addEventListener( eventType, callback );
                    break;
            }
            
        }
        
        public function addCallbackClear     ( callback:Function ):void{ addCallback( Event.CLEAR                       ,callback ) }
        public function addCallbackCopy      ( callback:Function ):void{ addCallback( Event.COPY                        ,callback ) }
        public function addCallbackCut       ( callback:Function ):void{ addCallback( Event.CUT                         ,callback ) }
        public function addCallbackPaste     ( callback:Function ):void{ addCallback( Event.PASTE                       ,callback ) }
        public function addCallbackSelectAll ( callback:Function ):void{ addCallback( Event.SELECT_ALL                  ,callback ) }
        public function addCallbackMenu      ( callback:Function ):void{ addCallback( ContextMenuEvent.MENU_SELECT      ,callback ) }
        public function addCallbackItemSelect( callback:Function ):void{ addCallback( ContextMenuEvent.MENU_ITEM_SELECT ,callback ) }
        
        
        public function setItemAt( index:uint = 0, title:String = " ", handler:Function = null ):void
        {
            _items[index] = createItem( title, handler );
            _target.contextMenu.customItems = _items;
        }
        public function getItemAt( index:uint ):ContextMenuItem
        {
            return _items[index]
        }
        
        
        public function addItem( title:String = " ", handler:Function = null ):void
        {
            _items[_items.length] = createItem( title, handler );
            _target.contextMenu.customItems = _items;
        }
        public function removeItemAt( index:uint = 0 ):void
        {
            _items[index] = null;
            _target.contextMenu.customItems = _items[index];
        }
        public function createItem( title:String = " ", handler:Function = null ):ContextMenuItem
        {
            var result:ContextMenuItem;
            result = new ContextMenuItem( title );
            if( handler != null ){
                result.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, handler );
            }
            return result; 
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    import flash.display.Shape;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    //import org.libspark.betweenas3.BetweenAS3;
    //import org.libspark.betweenas3.tweens.ITween;
    //import org.libspark.betweenas3.easing.*;
    class LLLTween
    {
        public var frames:Array = [];
        public var target:DisplayObject;
        public var method:Function;
        public var toValues:LLLTweenDisplayObjectValues;
        public var fromValues:LLLTweenDisplayObjectValues;
        
        public function LLLTween()
        {
        }
        /*
        
        method( distance:Number, duration:Number ):Array
        
        */
        public function liner( distance:Number, duration:Number ):Array
        {
            var list:Array = [];
            var value:Number = distance / duration;
            var i:uint,iMax:uint = duration;
            for(i=0;i<iMax;++i)
            {
                list[i] = value;
            }
            return list;
            
        }
        public function sin( distance:Number, duration:Number ):Array
        {
            var list:Array = [];
            var value:Number = distance;
            var progress:Number = 1 / duration;
            var i:uint,iMax:uint = duration;
            for(i=0;i<iMax;++i)
            {
                list[i] = Math.sin( value );
            }
            return list;
        }
        public function tan( distance:Number, duration:Number ):Array
        {
            var list:Array = [];
            var value:Number = distance;
            var progress:Number = 1 / duration;
            var i:uint,iMax:uint = duration;
            for(i=0;i<iMax;++i)
            {
                list[i] = Math.tan( value );
            }
            return list;
        }
        public function cos( distance:Number, duration:Number ):Array
        {
            var list:Array = [];
            var value:Number = distance;
            var progress:Number = 1 / duration;
            var i:uint,iMax:uint = duration;
            for(i=0;i<iMax;++i)
            {
                list[i] = Math.cos( value );
            }
            return list;
        }
        public function onFrame( target:DisplayObject, toValues:Object, fromValues:Object = null, duration:Number = NaN, method:Function = null ):LLLTween
        {
            this.target = target;
            this.method = method;
            this.frames = [];
            this.blur = new BlurFilter( 0, 0 );
            this.glow = new GlowFilter( 0, 0 );
            
            this.frames = makeFrames( ["x","y","blurX","blurY"], toValues, fromValues, duration, method );
            
            
            target.addEventListener( Event.ENTER_FRAME, _onEnterFrame )
            
            
            return this;
        }
        public function makeFrames( list:Array, toValues:Object, fromValues:Object, duration:Number, method:Function ):Array
        {
            var valuesList:Object = {};
            var i:int,iMax:int=list.length;
            for(i=0;i<iMax;++i)
            {
                valuesList[list[i]] = methodMap( list[i],toValues,fromValues,duration,method );
            }
            
            var result:Array = [];
            var j:int,jMax:int = duration;
            // i == value names count
            // j == frames count
            for(j=0;j<jMax;++j)
            {
                result[j] = new LLLTweenDisplayObjectValues();
                for(i=0;i<iMax;++i)
                {
                    result[j][list[i]] = valuesList[list[i]][j];
                }
            }
            
            return result;
        }
        public function methodMap( valueName:String, toValues:Object, fromValues:Object, duration:Number, method:Function ):Array
        {
            return method( toValues[valueName] - fromValues[valueName] ,duration );
        }
        public function play():Number
        {
            _playing = true;
            return _frameCount;
        }
        public function stop():Number
        {
            _playing = false;
            return _frameCount;
        }
        public function seek( position:Number = 0 ):void
        {
            _frameCount = int( position );
        }
        public function togglePlayStop():Number
        {
            if( _playing )
            {
                return stop();
            }
            else
            {
                return play();
            }
        }
        private var blur:BlurFilter;
        private var glow:GlowFilter;
        private var _frameCount:int = 0;
        private var _playing:Boolean = false;
        private function _onEnterFrame( event:Event = null ):void
        {
            if( _playing )
            {
                var item:LLLTweenDisplayObjectValues = frames[++_frameCount];
                
                // position
                isNaN(item.x) ? null : target.x += item.x ;
                isNaN(item.y) ? null : target.y += item.y ;
                isNaN(item.z) ? null : target.z += item.z ;
                item.$x ? target.x = int( target.x + item.$x ) : null ;
                item.$y ? target.y = int( target.y + item.$y ) : null ;
                item.$z ? target.z = int( target.z + item.$z ) : null ;
                
                // width height
                isNaN(item.width)  ? null : target.width  = int( target.width  + item.width  );
                isNaN(item.height) ? null : target.height = int( target.height + item.height );
                item.$width  ? target.width  = int( target.width  + item.$width  ) : null ;
                item.$height ? target.height = int( target.height + item.$height ) : null ;
                
                // filter
                isNaN(item.blurX) ? null : blur.blurX = item.blurX;
                isNaN(item.blurY) ? null : blur.blurY = item.blurY;
                isNaN(item.glowX) ? null : glow.blurX = item.glowX;
                isNaN(item.glowY) ? null : glow.blurY = item.glowY;
                isNaN(item.glowStrength) ? null : glow.strength = item.glowStrength;
                target.filters = [glow,blur];
            }
        }
    }
    
    import flash.display.DisplayObject;
    class LLLTweenDisplayObjectValues
    {
        public var x:Number = NaN;
        public var y:Number = NaN;
        public var z:Number = NaN;
        public var width :Number = NaN;
        public var height:Number = NaN;
        public var blurQuality:int = NaN;
        public var blurX:Number = NaN;
        public var blurY:Number = NaN;
        public var glowX:Number = NaN;
        public var glowY:Number = NaN;
        public var glowAlpha:Number = NaN;
        public var glowColor:Number = NaN;
        public var glowQuality:Number = NaN;
        public var glowStrength:Number = NaN;
        
        public var $x:Number = NaN;
        public var $y:Number = NaN;
        public var $z:Number = NaN;
        public var $width :Number = NaN;
        public var $height:Number = NaN;
        public var $blurX:Number = NaN;
        public var $blurY:Number = NaN;
        public var $glowX:Number = 0;
        public var $glowY:Number = 0;
        public var $glowColor:uint = 0;
        public var $glowQuality:int = 0;
        public var $glowAlpha:Number = 0;
        public var $glowStrength:Number = 0;
        /*
        colorMatrixEnabled
        colorMatrixRedMultiply:Number = 1.0;
        colorMatrixRedOffset:Number = 0;
        colorMatrixBlueMultiply:Number = 1.0;
        colorMatrixBlueOffset:Number = 0;
        colorMatrixGreenMultiply:Number = 1.0;
        colorMatrixGreenOffset:Number = 0;
        colorMatrixAlphaMultiply:Number = 1.0;
        colorMatrixAlphaOffset:Number = 0;
        
        mapBitmapData
        mapColor
        mapComponentX:uint = 0; // 0xF
        mapComponentY:uint = 0;
        mapAlpha
        mapOriginX
        mapOriginY
        mapScaleX
        mapScaleY
        
        bevelEnabled:Boolean = false;
        bevelX:Number = NaN;
        bevelY:Number = NaN;
        bevelDistance:Number = NaN;
        bevelHighlightAlpha:Number = NaN;
        bevelHighlightColor:Number = NaN;
        bevelShadowAlpha:Number = NaN;
        bevelShadowColor:Number = NaN;
        bevelKnockout:Boolean = NaN;
        bevelStrength
        bevelQuality
        blurEnabled:Boolean = false;
        blurX:Number = NaN;
        blurY:Number = NaN;
        blurQuality:int = 0;
        */
        /*
        methodList( [x,y,z,
        */
        
        

    }
    
        // LLLNumber ///////////////////////////////////////////
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.events.IEventDispatcher;
    class LLLNumber
    extends EventDispatcher
    {
        
        private var _eventDispatcher:EventDispatcher;
        private var _value:Number = NaN;
        
        public var max:LLLNumber;
        public var min:LLLNumber;
        public var now:LLLNumber;
        
        public var dispatchEventEnabled:Boolean = false;
        
        public function LLLNumber( value:Number = NaN )
        {
            _eventDispatcher = new EventDispatcher( this );
            isNaN(value) ? null : this.value = value;
        }
        public function createThis():LLLNumber{ return new LLLNumber() }
        
        public function get value():Number{ return getValue() }
        public function set value( value:Number ):void{ setValue( value ) }
        
        public function getValue():Number{ return _value }
        public function setValue( value:Number ):void
        {
            _value = value;
            if( dispatchEventEnabled )
            {
                _eventDispatcher.dispatchEvent( new Event( Event.CHANGE ) );
            }
        }
        
        // increase
        public function increase( value:Number = 1 ):void
        {
            _eventDispatcher.dispatchEvent( new Event( "increase" ) );
            setValue( _value + value );
        }
        
        
        // decrease
        public function decrease( value:Number = 1 ):void
        {
            _eventDispatcher.dispatchEvent( new Event( "decrease" ) );
            setValue( _value - value );
        }
        
        
        // change
        public function change( value:Number ):void
        {
            setValue( value );
        }
        
        
        // equal
        public function equal( value:Number ):Boolean
        {
            return ( _value === value );
        }
        
        // not equal
        public function notEqual( value:Number ):Boolean
        {
            return ( _value !== value );
        }
        
        
        // more than
        public function moreThan( value:Number ):Boolean
        {
            return ( _value < value );
        }
        public function moreThanOrEqual( value:Number ):Boolean
        {
            return ( _value <= value );
        }
        
        
        // less than
        public function lessThan( value:Number ):Boolean
        {
            return ( _value > value );
        }
        public function lessThanOrEqual( value:Number ):Boolean
        {
            return ( _value >= value );
        }
        
        public function limit():void
        {
            if( min )
            {
                if( _value === min.value )
                {
                    if( dispatchEventEnabled )
                    {
                        _eventDispatcher.dispatchEvent( new Event( "min" ) );
                    }
                }
                else if( _value < min.value )
                {
                    _value = min.value;
                    
                    if( dispatchEventEnabled )
                    {
                        _eventDispatcher.dispatchEvent( new Event( "minLimited" ) );
                    }
                }
            }
            if( this.max )
            {
                if( _value === min.value )
                {
                    if( dispatchEventEnabled )
                    {
                        _eventDispatcher.dispatchEvent( new Event( "max" ) );
                    }
                }
                if( max.value < _value )
                {
                    _value = max.value;
                    
                    if( dispatchEventEnabled )
                    {
                        _eventDispatcher.dispatchEvent( new Event( "maxLimited" ) );
                    }
                }
            }
        }
    }
    
    // LLLArray ///////////////////////////////////////////
    class LLLArray
    {
        //TODO 20120319 create functions
        public function fill():void{}
    }
    
    // LLLBoolean ///////////////////////////////////////////
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.events.IEventDispatcher;
    class LLLBoolean
    extends EventDispatcher
    {
        private var $eventDispatcher:EventDispatcher;
        private var $value:Boolean = false;
        
        public var eventDispatchEnabled:Boolean = false;
        
        public function createThis():LLLBoolean{ return new LLLBoolean() }
        public function LLLBoolean()
        {
            $eventDispatcher = new EventDispatcher( this );
        }
        
        public function get value():Boolean{ return getValue() }
        public function set value( value:Boolean ):void{ setValue( value ) }
        public function getValue():Boolean{ return $value }
        public function setValue( value:Boolean ):void
        {
            $value = value;
            if( eventDispatchEnabled )
            {
                $eventDispatcher.dispatchEvent( new Event( Event.CHANGE ) );
            }
        }
        
        public function toggle():void
        {
            if( $value )
            {
                setValue( false );
            }
            else
            {
                setValue( true );
            }
        }
        
        
    }
    
    // LLLString ///////////////////////////////////////////
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.events.IEventDispatcher;
    import flash.text.TextField;
    class LLLString
    extends EventDispatcher
    {
        
        private var $eventDispatcher:EventDispatcher;
        private var $value:String = null;
        
        public var eventDispatchEnabled:Boolean = false;
        
        public function createThis():LLLString{ return new LLLString() }
        public function LLLString( value:String = null )
        {
            $eventDispatcher = new EventDispatcher( this );
            value ? this.value = value : null;
        }
        
        public function get value():String{ return getValue() }
        public function set value( value:String ):void{ setValue( value ) }
        
        public function getValue():String{ return $value }
        public function setValue( value:String ):void
        {
            $value = value;
            if( eventDispatchEnabled )
            {
                $eventDispatcher.dispatchEvent( new Event( Event.CHANGE ) );
            }
        }
        public function createTextField():TextField
        {
            return new TextField();
        }
    }
    
    
    
    
    // LLLMemo ///////////////////////////////////////////
    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.text.TextFormat;
    import flash.text.TextField;
    class LLLMemo
    extends Sprite
    {
        public var textFormat:TextFormat;
        public var textField:TextField;
        
        public function LLLMemo( root:DisplayObjectContainer = null, x:int = 0, y:int = 0, text:String = " " )
        {
            super()
            
            textFormat = new TextFormat();
            textFormat.leftMargin = -4;
            textFormat.rightMargin = -1;
            textFormat.align = "left";
            textFormat.font = "_等幅";     //EXAMPLE  "_等幅"  "_ゴシック"  "_明朝 "  "_typewriter"  "_serif"  "_sans"
            textFormat.size = 10;
            textFormat.color = 0x000000;
            
            textField = new TextField();
            textField.background = false;
            textField.backgroundColor = 0xFFFFFF;
            textField.border = false;
            textField.borderColor = 0x000000;
            textField.textColor = 0x000000;
            textField.autoSize = "left";
            textField.selectable = false;
            textField.multiline = true;
            textField.defaultTextFormat = textFormat;
            
            textField.text = text;
            
            addChild( textField );
            
            this.x = x;
            this.y = y;
            
            root.addChild( this );
            
            textField.addEventListener( Event.CHANGE, _onTextChange );
            
        }
        private function _onTextChange( event:Event ):void
        {
            dispatchEvent( event );
        }
        
        public function get text():String{ return textField.text; }
        public function set text( value:String ):void{ textField.text = value; }
    }
    
    import flash.display.Stage;
    class LLLStage
    {
        private var _stage:Stage;
        
        public function LLLStage( stage:Stage )
        {
            _stage = stage;
            _stage.frameRate = 60;
        }
        
        public function get value():Stage{ return _stage }
        
        public function get frameRate():uint{ return _stage.frameRate }
        public function set frameRate( value:uint ):void
        {
            _stage.frameRate = uint( value );
        }
    }