/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ylKg
 */

// forked from shapevent's Keys and 3D
package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;
	import flash.ui.*;


	[SWF(backgroundColor=0x000000, width=500, height=500)]

       public class Keys3D extends MovieClip {
           
        
		private var hsw:Number;
		private var hsh:Number;
		private var pointNum:int;
		private var points3D:Vector.<Number>;
		private var points2D:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var sorted:Array;
		private var pnt:Point;
		private var m:Matrix3D;
		private var v:Vector3D;
		private var p:PerspectiveProjection;
		private var proj:Matrix3D;
		private var rx:Number;
		private var ry:Number;
		private var key:Object;


               public function Keys3D(){
                  // init
			hsw = stage.stageWidth / 2;
			hsh = stage.stageHeight / 2;
			pointNum = 300;
			points3D = new Vector.<Number>();
			points2D = new Vector.<Number>();
			uvts = new Vector.<Number>();
			sorted = [];
			pnt = new Point();
			m = new Matrix3D();
			v = new Vector3D();
			for (var i:int = 0; i<pointNum; i++){
				v.x = 300;
				v.y = v.z = 0;
				m.identity();
				m.appendRotation(Math.random()*360, Vector3D.X_AXIS);
				m.appendRotation(Math.random()*360, Vector3D.Y_AXIS);
				m.appendRotation(Math.random()*360, Vector3D.Z_AXIS);
				v = m.transformVector(v);
				points3D.push(v.x, v.y, v.z);
				points2D.push(0,0);
				uvts.push(0,0,0);
				sorted.push(new Vector3D());
			}
			points3D.fixed = true;
			points2D.fixed = true;
			uvts.fixed = true;
			p = new PerspectiveProjection();
			proj = p.toMatrix3D();
			rx = 0, ry = 0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			
			
			// permanently applies the matrix to the points3D vector
			
			
			// basic key setup
			key = new Object();
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyPressed);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyReleased);
			
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			var i:int, j:int;
			m.identity();
			if (key[Keyboard.RIGHT]){
				rx+=3
			}else
			if (key[Keyboard.LEFT]){
				rx-=3
			}else
			if (key[Keyboard.UP]){
				ry-=3
			}else
			if (key[Keyboard.DOWN]){
				ry+=3
			}
			m.appendRotation(rx, Vector3D.Y_AXIS);
			m.appendRotation(ry, Vector3D.X_AXIS);
			m.appendTranslation(0, 0, 1000);
			m.append(proj);
			Utils3D.projectVectors(m, points3D, points2D, uvts);
			for (i = 0, j = 0; i<points2D.length; i+=2, j++){
				sorted[j].x = points2D[i] + hsw;
				sorted[j].y = points2D[i + 1] + hsh;
				sorted[j].z = uvts[j * 3 + 2];
			}
			sorted.sortOn("z", Array.NUMERIC);
			graphics.clear();
			graphics.lineStyle(2, 0x000000, 0.1);
			for(i = 0; i<sorted.length; i++){
				var zpos:Number = sorted[i].z * 12000;
				var c:int = zpos * 14;
				c = (c > 255) ? 255 : c;
				graphics.beginFill(100<<16 | 100 << 8 |c);
				graphics.drawCircle(sorted[i].x, sorted[i].y,zpos);
				graphics.endFill();
			}
		}
		private function applyTransform():void{
			m.identity();
			m.appendRotation(rx, Vector3D.Y_AXIS);
			m.appendRotation(ry, Vector3D.X_AXIS);
			var temp:Vector.<Number> = new Vector.<Number>();
			m.transformVectors(points3D, temp);
			points3D = temp;
			points3D.fixed = true;
			rx = 0, ry = 0;
		}
		private function onKeyPressed(evt:KeyboardEvent):void {
			key[evt.keyCode] = true;
			key.keyCode = evt.keyCode;
		}
		private function onKeyReleased(evt:KeyboardEvent):void { 
		  applyTransform();
		  key[evt.keyCode] = false;
		}
		

       }

}