/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ylIp
 */

// forked from mousepancyo's 泡のようなもの（Color Bubbles）
// forked from mousepancyo's Particle Light（StarDust）
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.twoD.renderers.BitmapRenderer;
    import frocessing.color.ColorHSV;

    [SWF(width = 465, height = 465, frameRate = 60, backgroundColor = 0)]
    
    public class Main extends Sprite {
        protected var emitter:Emitter;
        protected var renderer:Renderer;
        private const stw:uint = stage.stageWidth,sth:uint = stage.stageHeight;
        private var _hsv:ColorHSV;
        private var _bmd:BitmapData;
        private var _blurBmd:BitmapData;
        private var _ctf:ColorTransform;
        
        public function Main() {
            stage.scaleMode = "noScale";
            Wonderfl.capture_delay(10);
            
            _hsv = new ColorHSV(0, .8, .95);
            _bmd = new BitmapData(465, 465, false, 0);
            _ctf = new ColorTransform(.95, .9, .7);
            //
            var bm:Bitmap = new Bitmap(_bmd);
            var bbm:Bitmap = new Bitmap(_blurBmd = _bmd.clone());
            bbm.blendMode = "add"
            addChild(bm);
            addChild(bbm);
            
            emitter = new MyEmitter(new SteadyClock(2));
            renderer = new BitmapRenderer(_bmd);
            renderer.addEmitter(emitter);
            //
            addEventListener(Event.ENTER_FRAME, loop);
        }
            
        private function loop(e:Event):void {
            _ctf.redMultiplier = (_hsv.value >> 16 & 0xff) / 255;
            _ctf.greenMultiplier = (_hsv.value >> 8 & 0xff) / 255;
            _ctf.blueMultiplier = (_hsv.value & 0xff) / 255;
            //
            _bmd.colorTransform(_bmd.rect, _ctf);
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(24, 24, 2));
            _blurBmd.copyPixels(_bmd, _bmd.rect, new Point());
            //
            MyEmitter(emitter).point.x += (mouseX - MyEmitter(emitter).point.x) * .05;
            MyEmitter(emitter).point.y += (mouseY - MyEmitter(emitter).point.y) * .05;
            //
            _hsv.h++;
            emitter.step();
        }

    }
}

import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
import idv.cjcat.stardust.twoD.renderers.*;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.fields.UniformField;

class MyEmitter extends Emitter2D {
    public var point:SinglePoint = new SinglePoint();
    
    public function MyEmitter(clock:Clock = null) {
        super(clock);
        addInitializer(new DisplayObjectClass(MyCircle));
        addInitializer(new Velocity(new LazySectorZone(0.1, 0)));
        addInitializer(new Life(new UniformRandom(40, 60)));
        addInitializer(new Position(point)); 

        addAction(new AlphaCurve(10,30));        
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new Accelerate(.07));
        addAction(new Move());
        
        var bmpField:BitmapField = new BitmapField();
        bmpField.max = 0.1;
        bmpField.massless = false;
        bmpField.scaleX = bmpField.scaleY = 0;
        
        var gravity:Gravity = new Gravity();
        gravity.addField(bmpField);
        gravity.addField(new UniformField( 0, -.02));
        addAction(gravity);
    }
}

import flash.display.Sprite;
import flash.display.Shape;

class MyCircle extends Sprite {
    public function MyCircle() {
        var n:int = Math.random()*15 | 0;
        var sp:Shape = new Shape()
        //
        sp.graphics.beginFill (0xFFFFFFFF, 1);
        sp.graphics.drawCircle(-n * .3, -n * .3, n * .5);
        sp.graphics.endFill();
        sp.graphics.lineStyle(1, 0xFFFFFF, 0.0);
        sp.graphics.drawCircle(0, 0, n);
        sp.rotation = Math.random() * 180 | 0;
        //sp.alpha = 0;
        //
        addChild(sp);
    }
}