/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ylC7
 */

import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.Font;
import fl.controls.*; // You must type this yourself, plus add a ScrollBar component to the library
 
var myText:TextField = new TextField(); // Essential - Textfield
var myFormat:TextFormat = new TextFormat(); // Essential - Textformatting settings
var myScrollbar:UIScrollBar = new UIScrollBar(); // Optional - Scrollbar
 
// Essential setup
myFormat.size = 14; // Setting fontsize to 14px
myFormat.align = TextFormatAlign.LEFT; // Setting text-align to left
myFormat.font = "Verdana"; // Setting font to Verdana
 
myText.x = 0; // Positioning the textfield all the way to the left
myText.y = 0; // Positioning the textfield all the way to the top
myText.height = stage.stageHeight; // Setting textfield height to stage height
myText.width = stage.stageWidth; // Setting textfield width to stage width
myText.text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit."; // Setting content of textfield
 
// Optional setup
myFormat.rightMargin = 20; // Setting right margin to 20px
myFormat.leftMargin = 20; // Setting right margin to 20px
 
myScrollbar.direction = ScrollBarDirection.VERTICAL; // Setting vertical/horizontal scrollbar direction
myScrollbar.scrollTarget = myText; // Setting scrollbar target, which determines what it which textfield it scrolls
myScrollbar.height = myText.height; // Setting the scrollbars height to match the textfield
myScrollbar.move(myText.x + myText.width, myText.y); // Move the scrollbar to the right side of the textfield
 
 
myText.wordWrap = true; // Wraps long sentences into multiline text
myText.textColor = 0xFED100; // Setting text color in HEX
myText.antiAliasType = AntiAliasType.ADVANCED; // Activates antialiasing for the textfield
 
// Update textField with textFormat and filters
myText.defaultTextFormat = myFormat; // Connecting textfield with textformat
 
// Display
addChild(myText); // Add textfield to stage
addChild(myScrollbar); // Add scrollbar to stage