/**
 * Copyright akamario ( http://wonderfl.net/user/akamario )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ykeR
 */

// forked from miyaoka's Super Mario Cave
// forked from keim_at_Si's Super Mario Synthesizer (Data not completed)
// BGMs are from TSSCP threads.
// SEs are from http://mmltalks.appspot.com/mml/e781c745d6bac989bc13ce18dd5f4ccfb09c78cf
// Translated from http://dic.nicovideo.jp/mml_id/1868
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import org.si.sion.*;
    import com.bit101.components.*;
    import caurina.transitions.Tweener;
    
    
    [SWF(backgroundColor='#ffffff', frameRate='60')]
    public class SuperMarioCave extends Sprite {
        public var driver:SiONDriver = new SiONDriver();
        public var sounds:SuperMarioSound = new SuperMarioSound();
        
        private var SW:Number = 465;
        private var SH:Number = 465;
        private var perlinPhase:Number = 0;
        private var thPhase:Number = 0;
        private var scroll:Number = 1;
        private var scale:Number = 0.5;
        private var bg:BitmapData = new BitmapData(SW * scale, SH * scale);
        private var trail:BitmapData = new BitmapData(SW, SH, true, 0x00000000);
        private var ct:ColorTransform = new ColorTransform(1, 1, 1, 1, 0x00, 0xcf, 0xff);
        public var threshold:uint = 0xff;
        public var xPos:Number = 150;
        private var yPos:Number;
        private var yMove:Number;
        public var yAccel:Number = 0.2;
        private var yVct:Number;
        private var perlinX:Number;
        private var perlinY:Number;
        
        
        function SuperMarioCave() {
            
            driver.bpm = 200;
            driver.play();
            
            var bmp:Bitmap = new Bitmap(bg);
            bmp.scaleX = bmp.scaleY = 1 / scale;
            addChild(bmp);
            addChild(new Bitmap(trail));
            
            addEventListener(Event.ENTER_FRAME, scrollDrawHandler);
            stageInit();
            
        }
        private function stageInit():void 
        {
            yPos = SH * 0.2;
            yMove = 0;
            yVct = 1;
            alpha = 1;
            threshold = 0xff;
            xPos = 0;
            
            scroll = 3//1 + Math.floor(Math.random() * 2);
            
            perlinX = Math.random() * 0.4 + 0.2;
            perlinY = Math.random() * 0.4 + 0.2;

            yAccel = 0;
            driver.play(sounds.mario1);
            Tweener.addTween(this, {
                xPos: 150,
                threshold: 0x50,
                time: 6.0,
                yAccel: scroll * 0.06
            });
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            addEventListener(Event.ENTER_FRAME, crashCheckHandler);
            addEventListener(Event.ENTER_FRAME, thPhaseHandler);
            
        }
        private function thPhaseHandler(e:Event):void 
        {
            thPhase += Math.PI * 0.01;
        }
        private function mouseDownHandler(e:MouseEvent):void 
        {
            yMove = -yAccel*10;
            yVct = -1;
            driver.sequenceOn(sounds.jump , null, 0, 0, 0);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, function ():void 
            {
                yVct = 1;
            });
        }
        private function scrollDrawHandler(e:Event):void 
        {
            bg.lock();
            bg.perlinNoise(SW * perlinX * scale, SH * perlinY * scale, 1, 1, false, false, 1, true, [new Point(perlinPhase += scroll * scale, 0)]);
            bg.colorTransform(bg.rect, ct);
            bg.threshold(bg, bg.rect, bg.rect.topLeft, ">", 0xFF << 24 |
            Math.max(0, Math.min(0xff, (threshold + Math.sin(thPhase) * 0x08))) << 16, 0xffffffff);
            bg.unlock();
            
            var sh:Shape = new Shape();
            var g:Graphics = sh.graphics;
            g.moveTo(xPos -scroll, yPos)
            
            yPos += yMove;
            yMove += yAccel * yVct;
            
            g.lineStyle(1, 0xffffff * Math.random());
            g.lineTo(xPos, yPos);
            
            trail.lock();
            trail.scroll( -scroll, 0);
            trail.draw(sh);
//            trail.setPixel32(xPos, yPos, 0xff000000);
            trail.unlock();
        }
        private function crashCheckHandler(e:Event):void 
        {
            if (yPos < -50 || yPos > SH || bg.getPixel(xPos * scale, yPos * scale) == 0xffffff)
            {
                driver.play(sounds.miss);
                yMove = -yAccel * 30;
                stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
                removeEventListener(Event.ENTER_FRAME, crashCheckHandler);
                removeEventListener(Event.ENTER_FRAME, thPhaseHandler);
                thPhase = 0;
                Tweener.addTween(this, {
                    time: 3.0,
                    alpha: 0.0,
                    threshold: 0x00,
                    transition: "easeInOutCubic",
                    onComplete: stageInit
                });
            }
        }
    }
}




import org.si.sion.*;

// this instanse have to be created after creating SiONDrivers instance.
// All SiONData are in bpm of 200.
class SuperMarioSound {
    // bgm
    public var mario1:SiONData;
    public var mario2:SiONData;
    public var mario2start:SiONData;
    public var mario4:SiONData;
    public var areaclear:SiONData;
    public var hurryup:SiONData;
    public var miss:SiONData;
    public var gameover:SiONData;
    
    // sound effect
    public var block:SiONData;
    public var item:SiONData;
    public var iteml:SiONData;
    public var powerup:SiONData;
    public var jump:SiONData;
    public var jumpl:SiONData;
    public var poke:SiONData;
    public var fumi:SiONData;
    public var dom:SiONData;
    public var fire:SiONData;
    public var cion:SiONData;
    public var extend:SiONData;
    public var warp:SiONData;
    public var goal:SiONData;
    public var bonus:SiONData;
    public var firework:SiONData;
    
    
    function SuperMarioSound() {
        var driver:SiONDriver = SiONDriver.mutex;
        var header:String, mml:String;
        header = "t200;#EFFECT0{speaker20};";
        
        // The following 4 lines are avoiding bugs in curren version. 
        // In this version, the sequenceOn() function cannot refer tables in the SiONData, 
        // so we have to define all tables on main SiONData played by SiONDriver.play().
        // In new version(0.57), the sequenceOn() function can refer the tables in SiONData and following mmls are not requeired.
        
        
        // MML from TSSCP thread dtm 1-564 modifyed
        
        // MML from TSSCP thread dtm 1-115 modifyed


        // MML from TSSCP thread dtm 1-115 modifyed

        // MML from TSSCP thread dtm 1-115 modifyed

        
        // MML from TSSCP thread dtm 1-864 modifyed


        // MML from TSSCP thread dtm 2-805 modifyed


    }
}


