/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ykKm
 */

package {
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var bitmapData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight,false,0x0)
            addChild(new Bitmap(bitmapData))
            var noise:BitmapData = new BitmapData(30,30)
            addChild(new Bitmap(noise))
            var shape:Shape = new Shape
            var spline:Function = function(p:Vector.<Point>, t:Number):Point {
                var point:Point = new Point
                for each(var v:String in ["x","y"]){
                    point[v] =  0.5*(
                                (2*p[1][v]) +
                                (-p[0][v] + p[2][v]) * t +
                                (2*p[0][v] - 5*p[1][v] + 4*p[2][v] - p[3][v]) * Math.pow(t,2) +
                                (-p[0][v] + 3*p[1][v]- 3*p[2][v] + p[3][v]) * Math.pow(t,3) )
                }
                return point
            }                            
            var val:Number = 0
            var colorTransform:ColorTransform = new ColorTransform(0.9,0.9,0.9)
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                bitmapData.colorTransform(bitmapData.rect, colorTransform)
                val += 0.2
                noise.perlinNoise(20,10,2,100,false,true,7,true,[new Point(val,0)])
                shape.graphics.clear()
                shape.graphics.lineStyle(1, 0x2255ff)
                for (var i:int = 0; i < noise.height; i++) {
                    var points:Vector.<Point> = new Vector.<Point>
                    shape.graphics.moveTo(-10,250)
                    for (var j:int = 0; j < noise.width; j++) {
                        var value:Number = noise.getPixel(j, i) % 0x100
                        points.push(new Point(j*20-20, value*2))
                        if (points.length>3) {
                            var split:int = 5
                            for (var k:int = 0; k < split; k++) {
                                var point:Point = spline(points, k/split)
                                shape.graphics.lineTo(point.x, point.y)
                            }
                            points.shift()
                        }
                    }                  
                }            
                bitmapData.draw(shape)                    
            })              
        }
    }
}
