/**
 * Copyright tnRaro ( http://wonderfl.net/user/tnRaro )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/yjrz
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    
    public class Main extends Sprite {
        private var sx:int;
        private var sy:int;
        
        private var world:BitmapData;
        private var bitmap:Bitmap;
        
        private var timer:Timer;
        
        private var mx:int;
        private var my:int;
        
        private var ps:Vector.<Poi>;
        
        public function Main() {
            resize(null);
            
            stage.addEventListener(Event.RESIZE, resize);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, me);
            
            world = new BitmapData(sx, sy, false, 0);
            bitmap = new Bitmap(world);
            
            ps = new Vector.<Poi>();
            
            addChild(bitmap);
            
            timer = new Timer(25);
            timer.addEventListener(TimerEvent.TIMER, te);
            timer.start();
            
            mx = sx*.5;
            my = sy*.5;
            
            var l:int=10000;
            var i:int=l;
            while( i --> 0 ){         
                ps.push(new Poi(Math.random()*sx, Math.random()*sy));
            }
        }
        
        private function me(e:MouseEvent):void{
            mx = e.stageX;
            my = e.stageY;
        }
        
        public function te(e:TimerEvent):void{
            world.fillRect(world.rect, 0);
            
            var l:int = ps.length;
            for(var i:int=0;i<l;i++){
                var p:Poi = ps[i];
                
                var t:Number = Math.atan2(my-p.y, mx-p.x);
                
                p.vx += Math.cos(t);
                p.vy += Math.sin(t);
                
                p.x += p.vx;
                p.y += p.vy;
                
                world.setPixel(p.x, p.y, add(world.getPixel(p.x, p.y), 0x574110));
            }
        }
        
        private function add(p:int, v:int):int{
            var r:int = Math.min(0xff, (p>>16&0xff) + (v>>16&0xff));
            var g:int = Math.min(0xff, (p>>8&0xff) + (v>>8&0xff));
            var b:int = Math.min(0xff, (p&0xff) + (v&0xff));
            return (r<<16^g<<8^b);
        }
        
        public function resize(e:Event):void{
            sx = stage.stageWidth;
            sy = stage.stageHeight;
        }
    }
}
    
    class Poi{
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
        
        public function Poi(_x:int, _y:int){
            x = _x;
            y = _y;
            vx = 0;
            vy = 0;
        }
    }