/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yjbp
 */

package {
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.media.SoundLoaderContext;
    import flash.media.Sound;
    import flash.system.LoaderContext;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.net.URLRequest
    import flash.display.Loader;
    import flash.display.Sprite;
    public class Bach extends Sprite {
        public var loader:Loader;
        public var bach:Sprite;
        public var mouth:Sprite;
        
        public var music:Sound;
        public var channel:SoundChannel;
        
        public var restrictions:Array = [
                    {begin:0, end:17500}, // beginning part
                    {begin:25000, end:25250},
                    {begin:32500, end:33000},
                    {begin:36500, end:37000},
                    {begin:40250, end:40750},
                    
                    // after chorus
                    
                    {begin:80750, end:81750},
                    {begin:88250, end:89250},
                    {begin:96000, end:97000},
                    {begin:103500, end:104500},
                    {begin:108750, end:115500}, // piano part
                    
                    {begin:122750, end:123000},
                    {begin:130250, end:131000},
                    {begin:134250, end:134750},
                    {begin:138000, end:138500},
                    
                    // second chorus
                    
                    {begin:148000, end:149000},
                    {begin:152750, end:153000},
                    {begin:155500, end:156750},
                    {begin:171000, end:173000},
                    
                    // after second piano
                    
                    {begin:175500, end:176500},
                    {begin:180250, end:180500},
                    {begin:183000, end:184000},
                    {begin:190750, end:192000},
                    {begin:195500, end:195750},
                    {begin:198250, end:199000},
                    {begin:203500, end:218000}
                    ];
        
        public function Bach() {
            loadPortrait();
        }
        
        public function loadPortrait():void {
            loader = new Loader();
            loader.load(new URLRequest("http://upload.wikimedia.org/wikipedia/commons/d/dd/Johann_Sebastian_Bach_1746.jpg"), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
        }
        
        public function complete(e:Event):void {
            (e.currentTarget as LoaderInfo).removeEventListener(Event.ENTER_FRAME, complete);
            
            loader.height = 465;
            loader.scaleX = loader.scaleY;
            loader.x = 465 / 2 - loader.width / 2;
            loader.y = 465 / 2 - loader.height / 2;
            
            prepareBach();
            loadMusic();
        }
        
        public function prepareBach():void {
            bach = new Sprite();
            bach.addChild(loader);
            
            var mask:Sprite = new Sprite();
            mask.graphics.beginFill(0, 1);
            mask.graphics.drawRect(465 / 2 + 4.06875, 465 / 2 - 75.271875, 30.225, 31.27125);
            mask.graphics.endFill();
            
            bach.addChild(mask);
            this.addChild(bach);
            
            mouth = new Sprite();
            
            var source:BitmapData = new BitmapData(int(loader.width), int(loader.height));
            var output:BitmapData = new BitmapData(int(30.225), int(31.27125));
            
            var bitmap:Bitmap = new Bitmap(output);
            bitmap.x = 465 / 2 + 4.06875;
            bitmap.y = 465 / 2 - 75.271875;
            
            mouth.addChild(bitmap);
            
            loader.x = 0;
            source.draw(bach);
            loader.x = 465 / 2 - loader.width / 2;
            
            output.copyPixels(source, new Rectangle(source.width / 2 + 4.06875, source.height / 2 - 75.271875, 30.225, 31.27125), new Point(0, 0));
            
            this.addChild(mouth);
        }
        
        public function loadMusic():void {
            music = new Sound(new URLRequest("http://media.soundcloud.com/stream/fqZKXHw3xq4c?stream_token=MLYPR"),  new SoundLoaderContext(0, true));
            this.addEventListener(Event.ENTER_FRAME, checkLoaded);
        }
        
        public function checkLoaded(e:Event):void {
            if (music.bytesLoaded >= music.bytesTotal) {
                this.addEventListener(Event.ENTER_FRAME, sing);
                channel = music.play();
            }
        }
        
        public function sing(e:Event):void {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes);
            
            var largest:Number = -1;
            
            for (var bi:int = 0; bi < 256; bi++) {
                var cb:Number = bytes.readFloat() * 10;
                if (largest < cb) {
                    largest = cb;
                }
            }
            
            mouth.y += (largest - mouth.y) / 10;
            if (mouth.y > 8) {
                mouth.y = 8;
            }
        }
    }
}