/**
 * Copyright WindsorFarmer ( http://wonderfl.net/user/WindsorFarmer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yjZz
 */

package sprites
{
    import flash.display.*;
    import flash.events.*;

    public class vectorAnimations extends MovieClip
    {
        trace ("vectorAnimations version 1.0");

        private var alternate:Boolean = false;
        private var trailDirection:Number = 1;

        public var whirl:MovieClip;

        public function Rotation (event:Event):void
        {
            event.target.rotation += event.target.rotationAmount;
        }

        public function gfx (gParent):void
        {
            var graph:MovieClip=new MovieClip  ;
            gParent.addChild (graph);
            graph.graphics.lineStyle (26, 0, 1);
            graph.graphics.drawCircle (0,0,30);

        }
        
        public function makeWedge(wdParent, wdRadious, wdWidth):Sprite
        {
            var wedge:Sprite = new Sprite;
            wdParent.addChild (wedge);
            //wedge.graphics.lineStyle (26, 0, 1);
            //wedge.graphics.drawCircle (0,0,30);
            ///////////////////////////////////////
            var wRadious:Number = 30;
            var distFromCenter:Number = 20;
            var startY, oppX, oppY, hypY = 0;
            var startX:Number = distFromCenter;
            var firstPoint:Number = distFromCenter+wRadious;
            
            // draw the wedge:
            wedge.graphics.beginFill(0x00ffff, 50);
            wedge.graphics.lineStyle(1, 0x00ffff);
            
            wedge.graphics.moveTo(distFromCenter, startY);
            wedge.graphics.lineTo(firstPoint, startY);
            
            oppX = Math.cos(wRadious * Math.PI /180) * firstPoint;
            oppY = Math.sin(wRadious * Math.PI /180) * firstPoint;
            //wedge.graphics.lineTo(oppX, oppY);
            wedge.graphics.curveTo(firstPoint, oppY/2, oppX, oppY);
            
            hypY = Math.atan(wRadious * Math.PI /180) * firstPoint;
            wedge.graphics.lineTo(startX*.95, hypY* 0.628);
                
            //wedge.graphics.lineTo(startX, startY);
            wedge.graphics.curveTo(startX * 1.04, hypY * .25, startX, startY);
            
            wedge.graphics.endFill();
            ///////////////////////////////////////
            return(wedge);
        }
            

        public function createWhirl (wParent:MovieClip, wScale:Number, wTails:Number, wFill:Number, wRadious:Number, wWidth:Number, wbgColor=-1, wLinks=12):MovieClip
        {
            
            whirl=new MovieClip  ;
            wParent.addChild (whirl);


            if (wTails<0)
            {
                wTails*=-1;
                alternate=true;
            }

            var whirlArray:Array = new Array();
            

            if (wbgColor>-1)
            {
                whirl.graphics.lineStyle (wWidth, wbgColor, .2);
                whirl.graphics.drawCircle (0,0,wRadious);
            }

            var fade:Number=1/wLinks;
            var degrees:Number=360/wTails;

            var whirlyPart:MovieClip;

            for (var t:Number = 0; t<wTails; t++)
            {
                whirlArray[t] = ("whirlyGig"+t);
                whirlArray[t]=new MovieClip  ;
                whirl.addChild(whirlArray[t]);
                for (var j:Number = 0; j<wLinks; j++)
                {
                    whirlyPart=new MovieClip  ;
                    whirlyPart.graphics.moveTo (40,0);
                    whirlyPart.graphics.beginFill (wFill, 1);
                    whirlyPart.graphics.lineTo (67, 0);
                    whirlyPart.graphics.lineTo (66, -7.5);
                    whirlyPart.graphics.lineTo (39, -4.5);
                    whirlyPart.graphics.lineTo (40, 0);
                    whirlyPart.graphics.endFill ();
                    ////////////////////////////////////////////////////var wRadious:Number = 20;
                    
                    var startY, oppX, oppY, hypY = 0;
                    var startX:Number = wRadious*.67;
                    var firstPoint:Number = wRadious+wWidth*.5;
                    var wedgeSlice:Number = 9;
                    
                    // draw the wedge:
                    whirlyPart.graphics.beginFill(0x00ffff, 1);
                    //whirlyPart.graphics.lineStyle(1, 0);
                    
                    whirlyPart.graphics.moveTo(wRadious, startY);
                    whirlyPart.graphics.lineTo(firstPoint, startY);
                    
                    oppX = Math.cos(wedgeSlice * Math.PI /180) * firstPoint;
                    oppY = Math.sin(wedgeSlice * Math.PI /180) * firstPoint;

                    whirlyPart.graphics.curveTo(firstPoint, oppY/2, oppX, oppY);
                    
                    hypY = Math.atan(wedgeSlice * Math.PI /180) * firstPoint;
                    whirlyPart.graphics.lineTo(startX*.95, hypY* 0.628);
                        
                    whirlyPart.graphics.curveTo(startX*.97, hypY * .3, startX*.97, startY);
                    
                    whirlyPart.graphics.endFill();
                    ////////////////////////////////////////////////////
                    //whirlyPart.x=Math.PI*j/10;
                    whirlyPart.rotation-=wedgeSlice*j*trailDirection;
                    whirlyPart.alpha-=fade*j;
                    whirlArray[t].addChild (whirlyPart);
                }

                whirlArray[t].rotationAmount=5*trailDirection;
                whirlArray[t].rotation+=degrees*t;
                if (alternate==true)
                {
                    trailDirection*=-1;
                }
                
            }
            whirl.scaleX = whirl.scaleY = (0.25 * wScale);
            
            for(var w:Number = 0;w<wTails;w++)
            {
                whirl.getChildAt(w).addEventListener(Event.ENTER_FRAME, wParent.vAX.Rotation);
            }
            
            return (whirl);
        }// end createWhirl()
    }//end vectorAnimations Class
}