/**
 * Copyright yo_yamamoto ( http://wonderfl.net/user/yo_yamamoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yj76
 */

package {
	/**
	 * ...AS3 ver.
	 * @author Yo Yamamoto　http://pulltab.info
	 * 
	 * FORK : AS2 ver. author Jared Tarbell.
	 * http://www.levitated.net/daily/levGatheringLine.html
	 * 
	 */
	import flash.display.MovieClip;
	import net.hires.debug.Stats;
	[SWF(backgroundColor="0x000000", width="465", height="465", frameRate="45")]
    public class LevGatheringLine extends MovieClip {
        public function LevGatheringLine() {
			// write as3 code here..
			var hoge:poolClass = new poolClass();
			addChild(hoge);

			// debug stats
			addChild(new Stats());
			
        }
    }
}


import flash.display.MovieClip;
import flash.events.Event;

class poolClass extends MovieClip
{
	// パーティクル配置の初期設定 保持オブジェクト
	private var _stick:Object = new Object();
	// ステージサイズ
	private var _stageX:int = 465;
	private var _stageY:int = 465;
	// パーティクル移動距離
	private var _moveRage:uint = 4;

	public function poolClass()
	{
		// パーティクル 目標位置の初期値
		_stick = { x:232, y:232, vx:0, vy:0 };
		// エンターフレーム開始
		this.addEventListener(Event.ENTER_FRAME, dragStick);
	}
	
	private function dragStick(e:Event):void
	{
		// パーティクルの目標位置 X軸移動距離の決定
		if (_stick.x < 0) {
			_stick.vx += Math.random() * _moveRage;
		}else if (_stick.x > _stageX) {
			_stick.vx -= Math.random() * _moveRage;
		}else {
			_stick.vx += (Math.random() - Math.random()) * _moveRage;
		}
		// パーティクルの目標位置 Y軸移動距離の決定
		if (_stick.y < 0) {
			_stick.vy += Math.random() * _moveRage;
		}else if (_stick.y > _stageY) {
			_stick.vy -= Math.random() * _moveRage;
		}else {
			_stick.vy += (Math.random() - Math.random()) * _moveRage;
		}
		// パーティクル 目標位置の更新
		_stick.x += _stick.vx;
		_stick.y += _stick.vy;
		_stick.vx *= 0.8;
		_stick.vy *= 0.8;
		// パーティクル画面内ランダム配置
		createNode(Math.random() * _stageX, Math.random() * _stageY, _stick.x, _stick.y, 1 + (Math.random() * 2));
	}
	
	private function createNode(x:Number, y:Number, dx:Number, dy:Number, ds:Number):Object
	{
		return addChild(new NodeClass(x, y, dx, dy, ds));
	}
	
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

class NodeClass extends Sprite
{
	// タイマー
	private var _timer:Timer = new Timer(6000, 1);
	// パーティクル生成
	private var _obj:Particle = new Particle(1, 0xffffff);
	private var _vx:Number;
	private var _vy:Number;
	private var _dx:Number;
	private var _dy:Number;
	private var _vxt:Number;
	private var _vyt:Number;
	
	public function NodeClass(posX:Number, posY:Number, targetX:Number, targetY:Number, scale:Number = 1)
	{
		// addChild
		this.addChild(_obj);
		// start off near invisible
		this.alpha = 0.05;
		// initialize
		// 生成位置、大きさ
		this.x = posX;
		this.y = posY;
		this.scaleX = this.scaleY = scale;
		// 目標位置
		_dx = targetX;
		_dy = targetY;
		// 仮座標 初期化
		_vx = 0;
		_vy = 0;
		// start moving
		addEventListener(Event.ENTER_FRAME, seekDestination);
	}
	
	private function seekDestination(e:Event):void {
		// フェードイン
		if (this.alpha < 1) {
			this.alpha += 0.1;
		}
		// 仮座標 更新
		_vx += (_dx - this.x) / 50;
		_vy += (_dy - this.y) / 50;
		// 目標位置付近に到達したかチェック
		if (Math.sqrt((_dx - this.x) * (_dx - this.x) + (_dy - this.y) * (_dy - this.y)) < 1.5) {
			// タイマーイベントセット doErode関数へ
			_timer.addEventListener(TimerEvent.TIMER, doErode);
			_timer.start();
			// イベントを削除
			removeEventListener(Event.ENTER_FRAME, seekDestination);
		}
		// 現在位置更新
		this.x += _vx;
		this.y += _vy;
		// 仮座標更新
		_vx *= 0.75;
		_vy *= 0.75;
	}
	
	private function doErode(e:TimerEvent):void {
		/****** accelerate *1
		_vxt = (Math.random() - Math.random());
		_vyt = (Math.random() - Math.random());
		*******/
		// タイマーイベント削除
		_timer.removeEventListener(TimerEvent.TIMER, doErode);
		_timer = null;
		// エンターフレーム
		addEventListener(Event.ENTER_FRAME, erode);
	}
	
	private function erode(e:Event):void {
		// フェードアウト
		if (this.alpha > 0) {
			this.alpha -= 0.02;
			// 落下スピード
			_vy += 0.2;
			/****** accelerate *1
			_vx += _vxt;
			_vy += _vyt;
			// 座標更新
			this.x += _vx;
			*******/
			this.y += _vy;
		} else {
			// エンターフレーム削除
			removeEventListener(Event.ENTER_FRAME, erode);
			// パーティクルを削除
			this.removeChild(_obj);
			// ノードクラスオブジェクトを削除
			this.parent.removeChild(this);
			_obj = null;
		}
	}
}


import flash.display.Sprite;

class Particle extends Sprite 
{
	private var _color:uint;
	private var _radius:uint;
	//public var _nextObj:Object;
	
	public function Particle(rad:uint,col:uint) {
		_color = col;
		_radius = rad;
		init();
	}
	
	private function init():void {
		// Create instance
		var sp:Sprite = new Sprite();
		// begin fill color;
		sp.graphics.beginFill(_color);
		// draw circle(x, y, r)
		sp.graphics.drawCircle(0, 0, _radius);
		sp.graphics.endFill();
		//add instance
		addChild(sp);
	}
	
}