/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yiV7
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    
    [SWF(frameRate=60)]
    public class Main extends Sprite {
        private var _container:Bitmap;
        private var _canvas:BitmapData;
        private var _mouse:Boolean;
        private var _mousePos:Vector.<int>;
        
        public function Main() {
            this._canvas = new BitmapData(465, 465, false, 0xDCDCDC);
            this._container = new Bitmap(this._canvas);
            this._mouse = false;
            this._mousePos = new Vector.<int>(4, true);
            
            this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        }
        
        private function addedToStageHandler($event:Event):void {
            this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        
            this.addChild(this._container);
            this.addChild(new Stats());
            
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.stage_mouseDownHandler);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, this.stage_mouseUpHandler);
            this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
        }
        
        private function stage_mouseDownHandler($event:MouseEvent):void {
            this._mouse = true;
            this._mousePos[0] = this.stage.mouseX;
            this._mousePos[1] = this.stage.mouseY;
            this._mousePos[2] = this._mousePos[3] = 0;
        }

        private function stage_mouseUpHandler($event:MouseEvent):void {
            this._mouse = false;
        }
        
        private function enterFrameHandler($event:Event):void {
            this._mousePos[2] = this._mousePos[0];
            this._mousePos[3] = this._mousePos[1];
            this._mousePos[0] = this.stage.mouseX;
            this._mousePos[1] = this.stage.mouseY;
            
            if (this._mouse) {
                this.updateCanvas(this._mousePos[2], this._mousePos[3], this._mousePos[0], this._mousePos[1], 0);
            }
        }
        
        
        private function updateCanvas($fX:int, $fY:int, $tX:int, $tY:int, $color:uint):void {
            var $dY:int = ($tY - $fY);
            var $dX:int = ($tX - $fX);
            
            if (($dY ^ ($dY >> 31)) - ($dY >> 31) > ($dX ^ ($dX >> 31)) - ($dX >> 31)) {
                $dY ^= $dX;
                $dX ^= $dY;
                $dY ^= $dX;
                
                var $s:Boolean = true;
            }else { $s = false }
            
            var $i:int = ($dX < 0) ? (~1 + 1) : 1;
            var $m:Number = ($dX == 0) ? $dY : ($dY / $dX);
            
            this._canvas.lock();
            if ($s) { for (var $:int = 0; $ != $dX; $+=$i) { this._canvas.setPixel(($fX + $ * $m), ($fY + $), $color) }}
            else { for ($ = 0; $ != $dX; $+=$i) { this._canvas.setPixel(($fX + $), ($fY + $ * $m), $color) }}
            this._canvas.unlock();
        }
    }
}