/**
 * Copyright tomrx ( http://wonderfl.net/user/tomrx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yiKc
 */

package 
{
    /* 　矢印キーで移動　
     * 　[ctrl]で交差法、平行法切り替え
     *   [shift]+[←][→]で立体の強さを変える
     */
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import org.papervision3d.core.io.BasicExporter;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite 
    {
        private var minicube:Vector.<Cube>;
        private var minicube2:Vector.<Cube>;
        private var basex:Vector.<Number>;
        private var basey:Vector.<Number>;
        private var basez:Vector.<Number>;
        private var baser:Vector.<Number>;
        private var basecount:Vector.<Number>;
        private var pattern:Vector.<uint>;
        private var cubevx:Vector.<Number>;
        private var cubevy:Vector.<Number>;
        private var world1:BasicView;
        private var world2:BasicView;
        private var _light:PointLight3D;
        private var _myship:Sphere;
        private var _myship2:Sphere;
        private var keyState:int;
        private var parallel:int = -1;
        private var depth:int = 15;
        private var gameoverwait:uint;
        private var gameover:Boolean = true;
        private var gameovertext:TextField;
        private var gameovertext2:TextField;
        private var speed:Number = 1.0;
        private var hp:int = 5;
        private var yure:Boolean = false;;
        private var yuretime:uint = 0;
        private var cax:Number = 0;
        private var cay:Number = 0;
        private var level:uint = 0;
        private var cc:Number = 0;
        private var vx:Number = 0.0;
        private var vy:Number = 0.0;
        private var hptext:TextField;
        private var hptext2:TextField;
        private var speedtext:TextField;
        private var speedtext2:TextField;
        private var levelcount:uint = 0;
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            minicube = new Vector.<Cube>;
            minicube2 = new Vector.<Cube>;
            pattern = new Vector.<uint>();
            cubevx = new Vector.<Number>();
            cubevy = new Vector.<Number>();
            basex = new Vector.<Number>();
            basey = new Vector.<Number>();
            basez = new Vector.<Number>();
            baser = new Vector.<Number>();
            basecount = new Vector.<Number>();
            gameovertext = new TextField();
            gameovertext2 = new TextField();
            speedtext = new TextField();
            speedtext2 = new TextField();
            hptext = new TextField();
            hptext2 = new TextField();
            gameovertext = new TextField();
            gameovertext2 = new TextField();
            world1 = new BasicView(230, 230, false, true, "Free");
            world2 = new BasicView(230, 230, false, true, "Free");
            world1.camera.x = 0;
            world2.camera.x = 0;
            
            _light = new PointLight3D(true);
            _light.x = 0;
            _light.y = 0;
            _light.z = -500;
            
            var container:DisplayObject3D = new DisplayObject3D();
            world1.scene.addChild(container);
            var i:int;
            for (i = 0; i < 100; i++) {
                var _cube:Cube = new Cube(new MaterialsList( { all:new FlatShadeMaterial(_light, 0xffffff, 0xaaaaaa) } ), 50, 50, 50);
                cubevx.push(0.0);
                cubevy.push(0.0);
                basex.push(0.0);
                basey.push(0.0);
                basez.push(0.0);
                baser.push(0.0);
                basecount.push(0.0);
                minicube.push(_cube);
                minicube[i].x = 0;
                minicube[i].y = 0;
                minicube[i].z = -1500;
                pattern[i] = 0;
                
                container.addChild(minicube[i]);
            }
            var container2:DisplayObject3D = new DisplayObject3D();
            world2.scene.addChild(container2);
            for (i = 0; i < 100; i++) {
                var _cube2:Cube = new Cube(new MaterialsList( { all:new FlatShadeMaterial(_light, 0xffffff, 0xaaaaaa) } ), 50, 50, 50);
                minicube2.push(_cube2);
                minicube2[i].x = 0;
                minicube2[i].y = 0;
                minicube2[i].z = -1500;
                container2.addChild(minicube2[i]);
            }
            _myship = new Sphere(new FlatShadeMaterial(_light, 0x00ffff, 0x005555), 30, 12, 12);
            _myship2 = new Sphere(new FlatShadeMaterial(_light, 0x00ffff, 0x005555), 30, 12, 12);
            container.addChild(_myship);
            container2.addChild(_myship2);
            _myship.z = -300;
            _myship2.z = -300;
            world1.startRendering();
            world2.startRendering();
            hptext.text = "LIFE●●●●●";
            hptext2.text = "LIFE●●●●●";
            hptext.textColor = 0xffffff;
            hptext2.textColor = 0xffffff;
            hptext2.x = 310;
            hptext.x = 80;
            hptext.y = 346;
            hptext2.y = 346;
            speedtext.x = 100;
            speedtext2.x = 330;
            speedtext.y = 100;
            speedtext2.y = 100;
            speedtext.textColor = 0xffffff;
            speedtext2.textColor = 0xffffff;
            speedtext.text = "SPEED  "
            speedtext2.text = "SPEED  "
            gameovertext.textColor = 0x8080ff;
            gameovertext.x = 95;
            gameovertext.y = 180;
            gameovertext2.textColor = 0x8080ff;
            gameovertext2.x = 325
            gameovertext2.y = 180;
            addChild(hptext);
            addChild(hptext2);
            addChild(speedtext);
            addChild(speedtext2);
            addChild(world1);
            addChild(world2);
            addChild(gameovertext);
            addChild(gameovertext2);
            world1.x = -depth / 2+10;
            world2.x = depth / 2+230+10;
            world1.y = 116;
            world2.y = 116;
            world1.camera.x = cax - depth ;;
            world2.camera.x = cax + depth ;
            world1.camera.y = cay 
            world2.camera.y = cay 
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeydown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyup);
            
        }
        private function enterFrameHandler(event:Event):void {
            if (gameoverwait > 0) { gameoverwait--; }
            if (keyState != 0 && gameover == true && gameoverwait <= 0) { 
                gameover = false;
                gameovertext.text = "";
                gameovertext2.text = "";
                speed = 1;
                hp = 5;
                _myship.x = 0;
                _myship2.x = 0;
                _myship.y = 0;
                _myship2.y = 0;
                var l:int = minicube.length;
                while (l--) {
                    minicube[l].z = -1000;
                    minicube2[l].z = -1000;
                    basez[l] = -1000;
                }
                yure = false;
                yuretime = 0;
                cax = 0;
                cay = 0;
                level = 1;
            }
            if (gameover == true) { return;}
            cc -= speed;
            
            if ((keyState&3) == 0 && vx > 0) { vx = vx - 0.5; }
            if ((keyState&3) == 0 && vx < 0) { vx = vx + 0.5; }
            if ((keyState&0xc) == 0 && vy > 0) { vy = vy - 0.5; }
            if ((keyState&0xc) == 0 && vy < 0) { vy = vy + 0.5;}
            if (keyState & 1) {
                if((keyState&0x100)==0){
                vx = vx + 0.5;
                if (vx > 4.0) { vx = 4.0; }
                }else {
                    if(depth>0){depth--;}
                }
            }
            if (keyState & 2) {
                if((keyState&0x100)==0){
                vx = vx - 0.5;
                if (vx < -4.0) { vx = -4.0; }
                }else {
                    depth++;
                }
            }
            if (keyState & 4) {
                vy = vy - 0.5;
                if (vy < -4.0) { vy = -4.0;}
            }
            if (keyState & 8) {
                vy = vy + 0.5;
                if (vy > 4.0) { vy = 4.0;}
            }    
            if (cax + vx*speed + 25 > 230) { vx = 0; }
            if (cax + vx*speed - 25 < -230) { vx = 0; }
            if (cay + vy*speed > 230) { vy = 0; }
            if (cay + vy*speed < -230) { vy = 0;}
            cax += vx * speed;
            cay += vy * speed;
            if (yuretime > 0) { 
                var yurex:Number = Math.random() * 20.0;
                var yurey:Number = Math.random() * 20.0;
                yuretime--;
            }else { yurex = 0; yurey = 0; }
            world1.camera.x = cax - depth + yurex;;
            world2.camera.x = cax + depth + yurex;
            world1.camera.y = cay + yurey;
            world2.camera.y = cay + yurey;
            _myship.x += vx * speed;
            _myship2.x += vx * speed;
            _myship.y += vy*speed;
            _myship2.y += vy * speed;
            world1.camera.z = -1000;
            world2.camera.z = -1000;
            if(parallel==true){
                world1.x = -125+125;
                world2.x = 125 + 125;
                gameovertext.x = 95;
                gameovertext2.x = 105 + 220;
                world1.x = -depth / 2+10;
                world2.x = depth / 2+230+10;
            }else {
                world1.x = 125+125;
                world2.x = -125 + 125;    
                gameovertext.x = 95 ;
                gameovertext2.x = 105 + 220;
                world1.x = -depth / 2+230+10;
                world2.x = depth / 2+10;
            }
            var s:String="";
            for (var i:int = 0; i < hp; i++) {
                s += "●";
            }
            hptext.text = "LIFE"+s;
            hptext2.text = "LIFE" + s;        
            speedtext.text ="SPEED  "+ Math.floor(speed*100-100).toString(10);
            speedtext2.text = "SPEED  " + Math.floor(speed * 100 - 100).toString(10);
            if (cc <= 0) {
                var r:int = Math.floor(Math.random() * level) + 1;
                var rx:Number;
                var ry:Number;
                var rr:Number;
                var rd:Number;
                switch(r) {
                    case 1:    
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                            for (i = 0; i < 5; i++) {
                                makecube(rx, ry, 1500+i*70, 0, 0, 0, 1);
                            }
                        cc = 150;
                    break;
                    case 2: 
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                            for (i = 0; i < 5; i++) {
                                makecube(rx, ry+(i-2)*60, 1500, 0, 0, 0, 1);
                            }
                        cc = 100;
                    break;
                    case 3:        
                        makecube(Math.random() * 460 - 230, Math.random() * 460 - 230, 1500,Math.random()*90,Math.random()*90,Math.random()*90, 1); 
                        cc = 100;
                    break;
                    case 4:    
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                            for (i = 0; i < 5; i++) {
                                makecube(rx+(i-2)*60, ry, 1500, 0, 0, 0, 1);
                            }
                        cc = 100;
                    break;
                    case 5:        
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                        rr = Math.random() * 200 + 150;
                        for (i = 0; i < 10; i++) {
                            makecube(Math.cos(i*36*Math.PI/ 180)*rr+rx, Math.sin(i*36*Math.PI/ 180)*rr+ry, 1500, 0,0, i*36, 1);                        
                        }
                        cc = 100;
                    break;
                    case 6:        
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                        rr = Math.random() * 200 + 150;
                        rd = Math.random() * 10;
                        for (i = 0; i < 10; i++) {
                            makecube(Math.cos((i+rd)*36*Math.PI/ 180)*rr+rx, Math.sin((i+rd)*36*Math.PI/ 180)*rr+ry, 1500+i*40, 0,0, (i+rd)*36, 1);                        
                        }
                        cc = 150;
                    break;
                    case 7:
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50, 0, 0, 8);
                        cc = 100;
                    break;
                    case 8:    
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50, 0, 0, 5);
                        cc = 100;
                    break;
                    case 9:
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50, 0, 0, 9);
                        cc = 100;
                    break;
                    case 10:
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50, 0, 0, 6);
                        cc = 100;
                    break;
                    case 11:        
                        makecube(Math.random() * 460 - 230, Math.random() * 460 - 230, 1500,Math.random()*90,Math.random()*90,Math.random()*90, 2);
                        cc = 100;
                    break;
                    case 12:    
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50, 0, 0, 4);
                        cc = 100;
                    break;
                    case 13:
                        makecube(Math.random()*460-230, Math.random()*460-230, 1500, Math.random()*300+50,Math.random()*360, 0, 7);
                        cc = 100;
                    break;
                    case 14:
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                        rr = Math.random() * 300;
                        for (i = 0; i < 10; i++) {
                            makecube(rx, ry, 1500+i*70, 50+rr, i*10, 0, 7);
                        }
                        cc = 250;
                    break;
                    case 15:
                        rx = Math.random() * 460 - 230;
                        ry = Math.random() * 460 - 230;
                        rr = Math.random() * 300;
                        for (i = 0; i < 10; i++) {
                            makecube(rx, ry, 1500+i*70, 50+rr, i*-10, 0, 4);
                        }
                        cc = 250;
                    break;
                }
                speed += 0.01;
                levelcount++;
                if (levelcount > 10) {
                    levelcount = 0;
                    if (level < 16) {
                        level++;
                    }
                }
            }
            movecube();
        }
        private function makecube(mx:Number,my:Number,mz:Number,rx:int,ry:int,rz:int,p:uint):void {
            var l:int = minicube.length;
            var m:int = 0;
            while (l--) {
                if (m == 0 && minicube[l].z < -700) {
                    m = 1;
                    minicube[l].x = mx;
                    minicube[l].y = my;
                    minicube[l].z = mz;
                    minicube[l].rotationX = rx;
                    minicube[l].rotationY = ry;
                    minicube[l].rotationZ = rz;
                    minicube[l].visible = true;
                    minicube2[l].x = mx;
                    minicube2[l].y = my;
                    minicube2[l].z = mz;
                    minicube2[l].rotationX = rx;
                    minicube2[l].rotationY = ry;
                    minicube2[l].rotationZ = rz;
                    basez[l] = 1500;
                    minicube2[l].visible = true;
                    switch(p) {
                        case 1:
                            pattern[l] = p;
                        break;
                        case 2:
                            pattern[l] = p;
                            cubevx[l] = Math.random() * 4.0 - 2.0;
                            cubevy[l] = Math.random() * 4.0 - 2.0;
                        break;
                        case 3:
                            pattern[l] = p;
                        break;
                        case 4:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = ry;
                        break;
                        case 5:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = Math.random()*360;
                        break;
                        case 6:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = Math.random()*360;
                        break;
                        case 7:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = ry;
                        break;
                        case 8:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = Math.random()*360;
                        break;
                        case 9:
                            basex[l] = minicube[l].x;
                            basey[l] = minicube[l].y;
                            basez[l] = minicube[l].z;
                            baser[l] = rx;
                            pattern[l] = p;
                            basecount[l] = Math.random()*360;
                        break;
                    }
                }
            }
        }
        private function movecube():void {
            var l:int = minicube.length;
            var same:Number;
            while (l--) {
                switch(pattern[l]) {
                    case 1:
                        minicube[l].z -= speed*3;
                        minicube2[l].z -= speed * 3;
                        basez[l] -= speed * 3;
                    break;
                    case 2:                    
                        if (minicube[l].x + cubevx[l] * speed < -230) { cubevx[l] = -cubevx[l]; }
                        if (minicube[l].x + cubevx[l] * speed > 230) { cubevx[l] = -cubevx[l]; }
                        if (minicube[l].y + cubevy[l] * speed < -230) { cubevy[l] = -cubevy[l]; }
                        if (minicube[l].y + cubevy[l] * speed > 230) { cubevy[l] = -cubevy[l]; }
                        minicube[l].z -= speed * 3;
                        minicube[l].x += cubevx[l] * speed;
                        minicube[l].y += cubevy[l] * speed;
                        minicube2[l].z -= speed * 3;                        
                        minicube2[l].x += cubevx[l] * speed;
                        minicube2[l].y += cubevy[l] * speed;
                        basez[l] -= speed * 3;
                    break;
                    case 3:
                        minicube[l].z -= speed*3;
                        minicube2[l].z -= speed * 3;
                        basez[l] -= speed * 3;
                    break;
                    case 4:
                        basecount[l] += speed / (baser[l]/100)*2;
                        minicube[l].x =basex[l]+ Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].z = basez[l];
                        minicube[l].rotationX = 0;
                        minicube[l].rotationY = 0;
                        minicube[l].rotationZ = basecount[l];;
                        minicube2[l].x =basex[l]+ Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].z = basez[l];
                        minicube2[l].rotationX = 0;
                        minicube2[l].rotationY = 0;
                        minicube2[l].rotationZ = basecount[l];;
                        basez[l] -= speed * 3;
                    break;
                    case 5:
                        basecount[l] += speed / (baser[l] / 100) * 2;
                        minicube[l].x = basex[l];
                        minicube[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].rotationX = -basecount[l];
                        minicube[l].rotationY = 0;
                        minicube[l].rotationZ = 0;
                        minicube2[l].x = basex[l];
                        minicube2[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].rotationX = -basecount[l];
                        minicube2[l].rotationY = 0;
                        minicube2[l].rotationZ = 0;
                        basez[l] -= speed * 3;
                    break;
                    case 6:
                        basecount[l] += speed / (baser[l] / 100) * 2;
                        minicube[l].x = basex[l] + Math.sin(Math.PI / 180 * basecount[l]) * baser[l];;
                        minicube[l].y = basey[l];
                        minicube[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].rotationX = 0;
                        minicube[l].rotationY = basecount[l];
                        minicube[l].rotationZ = 0;
                        minicube2[l].x = basex[l] + Math.sin(Math.PI / 180 * basecount[l]) * baser[l];;
                        minicube2[l].y = basey[l];
                        minicube2[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].rotationX = 0;
                        minicube2[l].rotationY = basecount[l];
                        minicube2[l].rotationZ = 0;
                        basez[l] -= speed * 3;
                    break;
                    case 7:
                        basecount[l] -= speed / (baser[l]/100)*2;
                        minicube[l].x =basex[l]+ Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].z = basez[l];
                        minicube[l].rotationX = 0;
                        minicube[l].rotationY = 0;
                        minicube[l].rotationZ = basecount[l];;
                        minicube2[l].x =basex[l]+ Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].z = basez[l];
                        minicube2[l].rotationX = 0;
                        minicube2[l].rotationY = 0;
                        minicube2[l].rotationZ = basecount[l];;
                        basez[l] -= speed * 3;
                    break;
                    case 8:
                        basecount[l] -= speed / (baser[l] / 100) * 2;
                        minicube[l].x = basex[l];
                        minicube[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].rotationX = -basecount[l];
                        minicube[l].rotationY = 0;
                        minicube[l].rotationZ = 0;
                        minicube2[l].x = basex[l];
                        minicube2[l].y =basey[l]+ Math.sin(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].rotationX = -basecount[l];
                        minicube2[l].rotationY = 0;
                        minicube2[l].rotationZ = 0;
                        basez[l] -= speed * 3;
                    break;
                    case 9:
                        basecount[l] -= speed / (baser[l] / 100) * 2;
                        minicube[l].x = basex[l] + Math.sin(Math.PI / 180 * basecount[l]) * baser[l];;
                        minicube[l].y = basey[l];
                        minicube[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube[l].rotationX = 0;
                        minicube[l].rotationY = basecount[l];
                        minicube[l].rotationZ = 0;
                        minicube2[l].x = basex[l] + Math.sin(Math.PI / 180 * basecount[l]) * baser[l];;
                        minicube2[l].y = basey[l];
                        minicube2[l].z = basez[l]+Math.cos(Math.PI / 180 * basecount[l])*baser[l];
                        minicube2[l].rotationX = 0;
                        minicube2[l].rotationY = basecount[l];
                        minicube2[l].rotationZ = 0;
                        basez[l] -= speed * 3;
                    break;
                }
                if (minicube[l].hitTestObject(_myship) && yuretime<=0) {
                    yure = true; yuretime = 10;                    
                    minicube[l].z = -1000;
                    minicube[l].visible = false;
                    minicube2[l].z = -1000;
                    minicube2[l].visible = false;
                    hp--; if (hp < 0) { gameover = true; gameoverwait = 60; gameovertext.text = "Game Over"; gameovertext2.text = "Game Over"; }
                }
                if (minicube[l].z < -700 && minicube[l].visible) { 
                    minicube[l].visible = false; minicube2[l].visible = false;
                    basez[l] = -1000;                    
                }
            
            }
        }
        private function onKeydown(event:KeyboardEvent):void {
            if (event.keyCode == 39 ) { keyState = keyState | 0x01;  }//39→ 37← 38↑ 40↓
            if (event.keyCode == 37 ) { keyState = keyState | 0x02;  }
            if (event.keyCode == 40 ) { keyState = keyState | 0x04;  }
            if (event.keyCode == 38 ) { keyState = keyState | 0x08;  }
            if (event.keyCode == 88 ) { keyState = keyState | 0x80;  }//x
            if (event.keyCode == 90 ) { keyState = keyState | 0x40;  }//z        
            if (event.keyCode == 16) { keyState = keyState | 0x100; }    //ctrl
            if (event.keyCode == 17) { parallel = -parallel; }
        }
        private function onKeyup(event:KeyboardEvent):void {
            if (event.keyCode == 39) { keyState &= ~0x01; }
            if (event.keyCode == 37) { keyState &= ~0x02; }
            if (event.keyCode == 40) { keyState &= ~0x04; }
            if (event.keyCode == 38) { keyState &= ~0x08; }
            if (event.keyCode == 88) { keyState &= ~0x80; }
            if (event.keyCode == 90) { keyState &= ~0x40; }
            if (event.keyCode == 16) { keyState &= ~0x100;}
        }
    }
    
}
