/**
 * Copyright sting ( http://wonderfl.net/user/sting )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yi0I
 */

// forked from ProjectNya's ドット3D
////////////////////////////////////////////////////////////////////////////////
// 読み込んだファイルをドット3D化 [FlashPlayer10]
// ドットひよこ (ぐるぐる) [http://wonderfl.net/c/wNSx]
// ドット地形 [http://wonderfl.net/c/ticj]
// FileLoader [http://wonderfl.net/c/uIFk]
////////////////////////////////////////////////////////////////////////////////

package {

	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.PixelSnapping;
	import flash.display.BlendMode;
	import flash.geom.Matrix;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.layer.*;
	import org.papervision3d.core.geom.*;
	import org.papervision3d.core.effects.*;

	[SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

	public class Main extends Sprite {
		private var scene:Scene3D;
		private var viewport:Viewport3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		private var sw:uint = 465;
		private var sh:uint = 465;
		private var cx:uint = 232;
		private var cy:uint = 232;
		private static var cameraHeight:Number = 300;
		private static var radius:uint = 300;
		private var effect:BitmapEffectLayer;
		private var pixels:Pixels;
		private var bitmapData:BitmapData;
		private static var _scale:Number = 32;
		private static var bw:uint = 465;
		private static var bh:uint = 465;
		private var angle:Number = 90;
		private var degree:Number = 0;
		private static var radian:Number = Math.PI/180;
		private var map:Map;
		private var base:Shape;
		private var loader:FileLoader;
		private var loadBtn:Btn;
		private var bitmap:Bitmap;
		private var mapBtn:Btn;

		public function Main() {
			Wonderfl.capture_delay(30);
			init();
		}

		private function init():void {
			scene = new Scene3D();
			viewport = new Viewport3D(0, 0, true, false);
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			setup();
			addChild(viewport);
			//addEventListener(Event.ENTER_FRAME, render, false, 0, true);
			base = new Shape();
			base.graphics.beginFill(0xCCCCCC);
			base.graphics.drawRect(-10, -10, 420, 420);
			base.graphics.beginFill(0x000000);
			base.graphics.drawRect(0, 0, 400, 400);
			base.graphics.endFill();
			addChild(base);
			base.x = 32;
			base.y = 16;
			loader = new FileLoader();
			loader.addEventListener(Event.INIT, initialize, false, 0, true);
			loadBtn = new Btn();
			addChild(loadBtn);
			loadBtn.x = 232;
			loadBtn.y = 445;
			loadBtn.init({label: "load"});
			loadBtn.addEventListener(MouseEvent.CLICK, load, false, 0, true);
			var bd:BitmapData = new BitmapData(400, 400, true, 0xFF000000);
			bitmap = new Bitmap(bd);
			addChild(bitmap);
			bitmap.x = 32;
			bitmap.y = 16;
			mapBtn = new Btn();
			//addChild(mapBtn);
			mapBtn.x = 232;
			mapBtn.y = 445;
			mapBtn.init({label: "map"});
			mapBtn.addEventListener(MouseEvent.CLICK, mapping, false, 0, true);
		}
		private function setup():void {
			viewport.interactive = true;
			camera.x = 0;
			camera.y = cameraHeight;
			camera.z = - radius;
			camera.zoom = 25;
			camera.focus = 20;
			camera.target = DisplayObject3D.ZERO;
			setEffect();
			map = new Map(pixels);
		}
		private function setEffect():void {
			effect = new BitmapEffectLayer(viewport, bw, bh);
			effect.addEffect(new BitmapColorEffect(1, 1, 1, 0.8));
			viewport.containerSprite.addLayer(effect);
			pixels = new Pixels(effect);
			scene.addChild(pixels);
			bitmapData = new BitmapData(bw/_scale, bh/_scale, false, 0xFF000000);
			var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
			bitmap.scaleX = bitmap.scaleY = _scale;
			bitmap.blendMode = BlendMode.ADD;
			addChild(bitmap);
		}
		private function render(evt:Event):void {
			sparkle();
			angle --;
			degree ++;
			camera.x = Math.cos(angle*radian)*radius;
			camera.y = Math.cos(degree*radian)*radius;
			camera.z = Math.sin(angle*radian)*Math.cos(degree*radian)*radius;
			renderer.renderScene(scene, camera, viewport);
		}
		private function sparkle():void {
			var matrix:Matrix = new Matrix();
			matrix.scale(1/_scale, 1/_scale);
			bitmapData.lock();
			bitmapData.fillRect(bitmapData.rect, 0xFF000000);
			bitmapData.draw(viewport, matrix);
			bitmapData.unlock();
		}
		private function load(evt:MouseEvent):void {
			loader.load();
		}
		private function initialize(evt:Event):void {
			removeChild(loadBtn);
			addChild(mapBtn);
			var bd:BitmapData = evt.target.bitmapData;
			var bw:Number = 400/bd.width;
			var bh:Number = 400/bd.height;
			var scale:Number = Math.min(bw, bh);
			var matrix:Matrix = new Matrix();
			matrix.scale(scale, scale);
			matrix.translate(uint(400 - bd.width*scale)/2, uint(400 - bd.height*scale)/2);
			bitmap.bitmapData.draw(bd, matrix, null, null, null, true);
		}
		private function mapping(evt:MouseEvent):void {
			removeChild(base);
			removeChild(bitmap);
			removeChild(mapBtn);
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, 465, 465);
			graphics.endFill();
			map.setup(bitmap.bitmapData);
			addEventListener(Event.ENTER_FRAME, render, false, 0, true);
		}

	}

}


//////////////////////////////////////////////////
//	Mapクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import frocessing.color.ColorHSV;

class Map {
	private var detection:DetectPixels;
	private static var accuracy:uint = 4;
	private var bitmapData:BitmapData;
	private var pixels:Pixels;
	private static var sw:uint = 400;
	private static var sh:uint = 400;
	private static var colors:Array;
	//重ねる層の数
	private var layers:uint = 10;

	public function Map(p:Pixels) {
		pixels = p;
		init();
	}

	private function init():void {
		detection = new DetectPixels(accuracy);
	}
	public function setup(bd:BitmapData):void {
		bitmapData = bd;
		for (var n:uint = 0; n < layers; n++) {
			drawLayer(n);
		}
	}
	private function drawLayer(id:uint):void {
		var hex:uint = uint(0xFF/layers*(id + 1));
		var threshold:uint = 0xFF << 24 | hex << 16 | hex << 8 | hex;
		detection.search(bitmapData, bitmapData.rect, threshold);
		var map:Array = detection.pixels();
		//色相指定
		var hsv:ColorHSV = new ColorHSV(45, 1);
		//色相変化
		hsv.h = 45 + 50/layers*(layers - id);
		var color:uint = 0xFF << 24 | hsv.value;
		for (var n:uint = 0; n < map.length; n++) {
			var dx:Number = sw/2 - map[n].x;
			var dy:Number = 8*id - 8*uint(layers/2);
			var dz:Number = map[n].y - sh/2;
			pixels.addPixel3D(new Pixel3D(color, dx, dy, dz));
		}
	}

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
	private var bd:IBitmapDrawable;
	private var rect:Rectangle;
	private var map:BitmapData;
	private var mapList:Array;
	private var accuracy:uint;
	private var threshold:uint = 0x80FFFFFF;

	public function DetectPixels(a:uint = 1) {
		accuracy = a;
	}

	public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
		bd = t;
		rect = r;
		threshold = th;
		var w:uint = rect.width/accuracy;
		var h:uint = rect.height/accuracy;
		detect(w, h);
	}
	private function detect(w:uint, h:uint):void {
		map = new BitmapData(w, h, true, 0x00000000);
		var matrix:Matrix = new Matrix();
		matrix.scale(1/accuracy, 1/accuracy);
		map.lock();
		map.draw(bd, matrix);
		map.unlock();
		mapList = new Array();
		for (var x:uint = 0; x < w; x++) {
			for (var y:uint = 0; y < h; y++) {
				var color:uint = map.getPixel32(x, y);
				if (color >= threshold) {
					var px:int = x*accuracy + rect.x;
					var py:int = y*accuracy + rect.y;
					var point:Point = new Point(px, py);
					mapList.push(point);
				}
			}
		}
	}
	public function pixels():Array {
		return mapList;
	}

}


//////////////////////////////////////////////////
//	FileLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.net.FileReference;
import flash.net.FileFilter;
import flash.display.Loader;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.DataEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class FileLoader extends EventDispatcher {
	private var file:FileReference;
	private static var typeFilter:Array;
	public var data:*;
	private var loader:Loader;
	public var bitmapData:BitmapData;

	public function FileLoader() {
		init();
	}

	private function init():void {
		file = new FileReference();
		file.addEventListener(Event.SELECT, select, false, 0, true);
		file.addEventListener(Event.CANCEL, cancel, false, 0, true);
		file.addEventListener(Event.OPEN, open, false, 0, true);
		file.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
		file.addEventListener(Event.COMPLETE, complete, false, 0, true);
		file.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
		file.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
		file.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
		var fileFilter:FileFilter = new FileFilter("画像ファイル", "*.jpg;*.gif;*.png");
		typeFilter = [fileFilter];
		loader = new Loader();
   		loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
	}
	public function load():void {
		file.browse(typeFilter);
	}
	private function select(evt:Event):void {
		file.load();
		dispatchEvent(evt);
	}
	private function cancel(evt:Event):void {
		dispatchEvent(evt);
	}
	private function open(evt:Event):void {
		dispatchEvent(evt);
	}
	private function progress(evt:ProgressEvent):void {
		dispatchEvent(evt);
	}
	private function complete(evt:Event):void {
		data = evt.target.data;
		loader.loadBytes(data);
		dispatchEvent(evt);
	}
	private function ioerror(evt:IOErrorEvent):void {
		dispatchEvent(evt);
	}
	private function httpstatus(evt:HTTPStatusEvent):void {
		dispatchEvent(evt);
	}
	private function securityerror(evt:SecurityErrorEvent):void {
		dispatchEvent(evt);
	}
	private function initialize(evt:Event):void {
		bitmapData = null;
		var bitmap:Bitmap = Bitmap(evt.target.content);
		bitmapData = bitmap.bitmapData;
		dispatchEvent(evt);
	}

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
	public var id:uint;
	private var shade:Shape;
	private var bottom:Shape;
	private var light:Shape;
	private var base:Shape;
	private var txt:TextField;
	private var label:String = "";
	private static var fontType:String = "_ゴシック";
	private var _width:uint = 60;
	private static var _height:uint = 20;
	private static var corner:uint = 5;
	private var type:uint = 1;
	private static var bColor:uint = 0xFFFFFF;
	private static var sColor:uint = 0x000000;
	private static var upColor:uint = 0x666666;
	private static var overColor:uint = 0x333333;
	private static var offColor:uint = 0x999999;
	private static var gColor:uint = 0x0099FF;
	private var blueGlow:GlowFilter;
	private var shadeGlow:GlowFilter;
	private var _clicked:Boolean = false;
	private var _enabled:Boolean = true;

	public function Btn() {
	}

	public function init(option:Object):void {
		if (option.id != undefined) id = option.id;
		if (option.label != undefined) label = option.label;
		if (option.width != undefined) _width = option.width;
		if (option.type != undefined) type = option.type;
		draw();
	}
	private function draw():void {
		switch (type) {
		case 1 :
			bColor = 0xFFFFFF;
			sColor = 0x000000;
			upColor = 0x666666;
			overColor = 0x333333;
			offColor = 0x999999;
			break;
		case 2 :
			bColor = 0x000000;
			sColor = 0xFFFFFF;
			upColor = 0x666666;
			overColor = 0x999999;
			offColor = 0x333333;
			break;
		}
		blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
		shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
		shade = new Shape();
		bottom = new Shape();
		light = new Shape();
		base = new Shape();
		txt = new TextField();
		addChild(shade);
		addChild(bottom);
		addChild(light);
		addChild(base);
		addChild(txt);
		createBase(shade, _width, _height, corner, sColor);
		shade.filters = [shadeGlow];
		createBase(bottom, _width, _height, corner, sColor, 0.3);
		createBase(light, _width, _height, corner, gColor);
		light.filters = [blueGlow];
		createBase(base, _width, _height, corner, bColor);
		txt.x = -_width*0.5;
		txt.y = -_height*0.5;
		txt.width = _width;
		txt.height = _height - 1;
		txt.type = TextFieldType.DYNAMIC;
		txt.selectable = false;
		//txt.embedFonts = true;
		//txt.antiAliasType = AntiAliasType.ADVANCED;
		var tf:TextFormat = new TextFormat();
		tf.font = fontType;
		tf.size = 12;
		tf.align = TextFormatAlign.CENTER;
		txt.defaultTextFormat = tf;
		txt.text = label;
		enabled = true;
		mouseChildren = false;
	}
	private function rollOver(evt:MouseEvent):void {
		_over();
	}
	private function rollOut(evt:MouseEvent):void {
		_up();
	}
	private function press(evt:MouseEvent):void {
		_down();
	}
	private function release(evt:MouseEvent):void {
		_up();
	}
	private function click(evt:MouseEvent):void {
	}
	private function _up():void {
		txt.y = -_height*0.5;
		txt.textColor = upColor;
		base.y = -1;
		light.visible = false;
		light.y = -1;
	}
	private function _over():void {
		txt.y = -_height*0.5;
		txt.textColor = overColor;
		base.y = -1;
		light.visible = true;
		light.y = -1;
	}
	private function _down():void {
		txt.y = -_height*0.5 + 1;
		txt.textColor = overColor;
		base.y = 0;
		light.visible = true;
		light.y = 0;
	}
	private function _off():void {
		txt.y = -_height*0.5 + 1;
		txt.textColor = offColor;
		base.y = 0;
		light.visible = false;
		light.y = 0;
	}
	public function get clicked():Boolean {
		return _clicked;
	}
	public function set clicked(param:Boolean):void {
		_clicked = param;
		enabled = !_clicked;
		if (_clicked) {
			_down();
		} else {
			_up();
		}
	}
	public function get enabled():Boolean {
		return _enabled;
	}
	public function set enabled(param:Boolean):void {
		_enabled = param;
		buttonMode = _enabled;
		mouseEnabled = _enabled;
		useHandCursor = _enabled;
		if (_enabled) {
			_up();
			addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
			addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
			addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
			addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
			addEventListener(MouseEvent.CLICK, click, false, 0, true);
		} else {
			_off();
			removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
			removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
			removeEventListener(MouseEvent.MOUSE_DOWN, press);
			removeEventListener(MouseEvent.MOUSE_UP, release);
			removeEventListener(MouseEvent.CLICK, click);
		}
	}
	private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
		target.graphics.beginFill(color, alpha);
		target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
		target.graphics.endFill();
	}

}
