/**
 * Copyright goldsource ( http://wonderfl.net/user/goldsource )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yhG3
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", frameRate="60")]
    
    /**
     * Catch Me
     * CATCH ALL THE SHAPES IN CORRECT ORDER.
     * DO NOT DOUBLECLICK. CLICK TO BEGIN!
     * @author Nicholas Schreiber
     **/
    public class CatchMe extends Sprite
    {
        /**
        * Sprite Size
        **/
        private static const SIZE:uint = 32;
        private static const MIN_SPEED:uint = 1;
        private static const SPEED_MULT:uint = 3;
        private var __last:int;
        private var __score:uint;
        private var __time:uint;
        private var __selected:SomeSprite;
        private var __container:Sprite = new Sprite();
        private var __bgColor:uint;
        public function CatchMe()
        {
            super();               
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;                        
            __randomBg();
            __container.addChild(new WelcomeScreen());
            stage.addEventListener(MouseEvent.CLICK,__onWelcomeClick);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,__onMouseMove);
            stage.addEventListener(Event.RESIZE,__onResize);
            addChild(__container);
            __container.z=100;
            __onResize();
        }
        
        private function __onResize($e:Event=null):void{
            if(stage == null || stage.stageWidth == 0 || stage.stageHeight == 0)return;
            var pp:PerspectiveProjection = new PerspectiveProjection();
            pp.projectionCenter = new Point(stage.stageWidth/2,stage.stageHeight/2);            
            transform.perspectiveProjection = pp;
            __draw();
            __container.x =stage.stageWidth/2;
            __container.y =stage.stageHeight/2;
            
        }
        
        private function __randomBg():void{
            __bgColor = 0x11 << 16 | Math.floor(0x11+Math.random()*0x33) << 8 | Math.floor(0x11+Math.random()*(0x33));                
        }
        
        private function __draw():void{
            with(__container.graphics){
                clear();
                beginFill(__bgColor,.8);
                drawRect(-stage.stageWidth/2,-stage.stageHeight/2,stage.stageWidth,stage.stageHeight)
                endFill();
            }            
        }
        
        private function __onMouseMove($e:MouseEvent):void{
            if(stage==null || stage.stageWidth == 0 || stage.stageHeight == 0)return;
            __container.rotationY = 20*Math.min(1,Math.max(-1,(((stage.stageWidth-stage.mouseX)-stage.stageWidth/2)/(stage.stageWidth/2))));
            __container.rotationX = 20*Math.min(1,Math.max(-1,(((stage.stageHeight-stage.mouseY)-stage.stageHeight/2)/(stage.stageHeight/2))));
            $e.updateAfterEvent();
        }
                
        private function __onWelcomeClick($e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.CLICK,__onWelcomeClick);
            __removeAll();
            __startOver();
        }
        
        private function __removeAll():void{
            while(__container.numChildren>0){
                if(__container.getChildAt(0) is SomeSprite){
                    if(SomeSprite(__container.getChildAt(0)).hasEventListener(MouseEvent.MOUSE_DOWN))SomeSprite(__container.getChildAt(0)).removeEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
                    delete SomeSprite(__container.removeChildAt(0)).destruct();
                }else if(__container.getChildAt(0) is WelcomeScreen){
                    delete WelcomeScreen(__container.removeChildAt(0)).destruct();
                }else if(__container.getChildAt(0) is GameOverScreen){
                    delete GameOverScreen(__container.removeChildAt(0)).destruct();
                }
            }
        }
        
        private function __startOver():void{            
            __randomBg();
            __draw();
            __removeAll();
            __score = 0;
            __last = -1;
            __time = new Date().time;
            for (var i:uint = 0; i<10; i++){
                var randomColor:uint=(0x44+Math.floor(Math.random()*(0x99)) << 16 | Math.floor(0x44+Math.random()*(0x99)) << 8 | Math.floor(0x44+Math.random()*(0x99)))
                var someSprite:SomeSprite = new SomeSprite(i,SIZE,randomColor,MIN_SPEED+Math.random()*SPEED_MULT,Math.PI/180*(Math.random()*360));
                someSprite.x = int(Math.random()*(stage.stageWidth-SIZE));
                someSprite.y = int(Math.random()*(stage.stageHeight-SIZE));
                someSprite.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
                __container.addChild(someSprite);
            }                
        }
        
        private function __gameOver($gotAll:Boolean):void{
            __removeAll();        
            __container.addChild(new GameOverScreen(__score,(($gotAll)?"CONGRATULATIONS,\nYOU'VE GOT 'EM ALL!":"GAME OVER!")));
            stage.addEventListener(MouseEvent.CLICK,__onGameOverClick);
        }
        
        private function __onGameOverClick($e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.CLICK,__onGameOverClick);
            __removeAll();
            __startOver();
        }
        
        private function __onMouseDown(e:MouseEvent):void
        {                
            if(!e.target is SomeSprite)return;        
            __selected = SomeSprite(e.target);
            if(++__last != __selected.id){
                __gameOver(false);
                return;
            }
            var now:uint = new Date().time;
            __score+=Math.max(1,((60*1000)-(now-__time))/100);
            __time = now;
            __selected.removeEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
            __selected.animate = false;            
            __selected.catched = true;            
            if(__last == __container.numChildren-1){
                __gameOver(true);
                return;
            }
            stage.addEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
        }        
                
        private function __onMouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
            __selected.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);            
            __selected.animate = true;
            __selected = null;
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.DropShadowFilter;
import flash.geom.Rectangle;
import flash.text.AntiAliasType;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

import flashx.textLayout.formats.TextAlign;

internal class SomeSprite extends Sprite{
    private static const BORDER_WIDTH:int = 4;
    private var __tf:TextField = new TextField();
    private var __catched:Boolean = false;
    public var color:uint;
    public var speed:Number;
    public var radians:Number;
    public var size:uint;
    public var animate:Boolean = true;
    public var id:uint;
    private var __x:Number;
    private var __y:Number;
    private var __screen:Bitmap;
    public function SomeSprite($id:uint,$size:uint,$color:uint,$speed:Number,$radians:Number){
        super();    
        id = $id;
        speed = $speed;
        radians = $radians;
        color = $color;
        size = $size;
        mouseChildren = false;
        __tf.mouseEnabled = false;
        __tf.width = __tf.height = size;
        __tf.selectable=false;
        __tf.antiAliasType = AntiAliasType.ADVANCED;
        __tf.defaultTextFormat = new TextFormat("_sans",24,0xFFFFFF,true,null,null,null,null,TextAlign.CENTER);
        __tf.text = (id+1).toString();
        
        __screen = new Bitmap(new BitmapData(size,size,false,0),PixelSnapping.ALWAYS,false);
        __screen.x = -size/2;
        __screen.y = -size/2;
        addChild(__screen);
        __render();
        addEventListener(Event.ENTER_FRAME,__onEnterFrame);
    }
    
    public function destruct():SomeSprite{
        removeEventListener(Event.ENTER_FRAME,__onEnterFrame);
        graphics.clear();        
        __tf = null;
        __screen.bitmapData.dispose();
        while(numChildren>0)delete removeChildAt(0);
        return this;
    }
    
    private function __onEnterFrame($e:Event):void{
        if(!animate)return;    
        __x += speed * Math.cos(radians);
        __y += speed * Math.sin(radians);
        var outOfBounds:Boolean = false;
        if(__x<size/2){
            __x = size/2;
            outOfBounds = true;
        }
        if(__x>stage.stageWidth-size/2){
            __x = stage.stageWidth-size/2;
            outOfBounds = true;
        }
        if(__y<size/2){
            __y = size/2;
            outOfBounds = true;
        }
        if(__y>stage.stageHeight-size/2){
            __y = stage.stageHeight-size/2;
            outOfBounds = true;            
        }
        if(outOfBounds){
            speed*=-1;
            radians+=Math.PI/180*Math.random()*135
        }
        super.x = int(__x-stage.stageWidth/2);
        super.y = int(__y-stage.stageHeight/2);
    }
    
    private function __render():void{        
        if(!__catched){
            __screen.bitmapData.fillRect(__screen.bitmapData.rect,color);
        }else{
            __screen.bitmapData.fillRect(__screen.bitmapData.rect,0xFFFFFF);
            __screen.bitmapData.fillRect(new Rectangle(__screen.bitmapData.rect.x+BORDER_WIDTH,__screen.bitmapData.rect.y+BORDER_WIDTH,__screen.bitmapData.rect.height-BORDER_WIDTH*2,__screen.bitmapData.rect.width-BORDER_WIDTH*2),color);
        }
        __screen.bitmapData.draw(__tf);
        
    }
    
    public function get catched():Boolean
    {
        return __catched;
    }
    
    public function set catched(value:Boolean):void
    {
        __catched = value;
        __render();
    }

    override public function get x():Number
    {
        return __x;
    }

    override public function set x(value:Number):void
    {
        __x = value;
    }

    override public function get y():Number
    {
        return __y;
    }

    override public function set y(value:Number):void
    {
        __y = value;
    }


}

internal class WelcomeScreen extends Sprite{
    
    private var __tf:TextField = new TextField();
    public function WelcomeScreen(){        
        addEventListener(Event.ADDED_TO_STAGE,__onAddedToStage);
    }
    
    private function __onAddedToStage($e:Event):void{    
        removeEventListener(Event.ADDED_TO_STAGE,__onAddedToStage);
        __tf.width = 1;
        __tf.height = 1;
        __tf.autoSize = TextFieldAutoSize.CENTER;
        __tf.selectable=false;
        __tf.defaultTextFormat = new TextFormat("_sans",32,0xFFFFFF,true,null,null,null,null,TextAlign.CENTER);
        __tf.text = "CATCH ME!\n";
        var tl:int = __tf.text.length;
        __tf.appendText("CATCH ALL THE SHAPES IN CORRECT ORDER.\n DO NOT DOUBLECLICK.\n CLICK TO BEGIN!");
        __tf.setTextFormat(new TextFormat("_sans",18,0xFFFFFF,true,null,null,null,null,TextAlign.CENTER),tl,__tf.text.length);        
        __tf.x = -__tf.width/2;
        __tf.y = -__tf.height/2;
        addChild(__tf);
        
    }
    
    public function destruct():WelcomeScreen{
        __tf = null;
        while(numChildren>0)delete removeChildAt(0);
        return this;
    }
}

internal class GameOverScreen extends Sprite{
    
    private var __tf:TextField = new TextField();
    private var __score:uint;
    private var __headline:String;
    public function GameOverScreen($score:uint,$headline:String){
        __score = $score;
        __headline = $headline;
        addEventListener(Event.ADDED_TO_STAGE,__onAddedToStage);
    }
    private function __onAddedToStage($e:Event):void{
        __tf.width = 1;
        __tf.height = 1;
        __tf.autoSize = TextFieldAutoSize.CENTER;
        __tf.selectable=false;
        __tf.defaultTextFormat = new TextFormat("_sans",32,0xFFFFFF,true,null,null,null,null,TextAlign.CENTER);
        __tf.text = __headline+"\n";        
        var tl:int = __tf.text.length;
        __tf.appendText("YOUR SCORE: "+__score+"\n");
        __tf.appendText("CLICK TO RESTART!");
        __tf.setTextFormat(new TextFormat("_sans",18,0xFFFFFF,true,null,null,null,null,TextAlign.CENTER),tl,__tf.text.length);        
        __tf.x = -__tf.width/2;
        __tf.y = -__tf.height/2;
        addChild(__tf);        
    }
    
    
    public function destruct():GameOverScreen{
        __tf = null;
        while(numChildren>0)delete removeChildAt(0);
        return this;
    }
}