/**
 * Copyright windy ( http://wonderfl.net/user/windy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ygmV
 */

// forked from mojoispaces's forked from: flash on 2010-1-8
// forked from mex_ny's flash on 2010-1-8
/*
 * Flash Player10.1のマイクのテスト。
 * 音楽を流して外部入力にすると動きが判りやすいかもしれないです。
 *
*/
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics; 
    import flash.display.Shape; 
    import flash.display.Sprite; 
    import flash.events.Event; 
    import flash.events.SampleDataEvent; 
    import flash.geom.Point;
    import flash.media.Microphone; 
    import flash.media.SoundTransform;
    import flash.utils.ByteArray; 
    import flash.media.SoundMixer;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.IObjectTween;
    import org.libspark.betweenas3.easing.Circ;
    import org.libspark.betweenas3.events.TweenEvent;

    [SWF(backgroundColor = '0xFFFFFF', width = '465', height = '465', frameRate = '30')]
    public class SoundWave extends Sprite {
        private const DATA_PER_ENTER_FRAME:uint = 1024;
        private const SAMPLEING_RATE:uint = 44;
        private const POINT:Point = new Point( 0 , 0 );

        private var _mic: Microphone; 
        private var _waveData:Vector.<Number>;
        private var _stageWidth:Number;
        private var _stageHeight:Number;
        private var _baseHeight:Number;
        private var _offset:Number;
        private var _waveG:Graphics;
        private var _colorPalette:Vector.<uint>;
        private var _colorPaletteLength:uint;
        private var _colorPaletteIndex:uint;
        private var _colorCounter:uint = 0;
        private var _isBmpStop:Boolean = false;
        private var _isDeleteAnimation:Boolean = false;
        private var _tweenCompleteNext:Function;
        private var _backGroundLayer:Shape;
        private var _contentsLayer:Sprite;
        private var _statsLayer:Sprite;
        private var _bitmapLayer:Sprite;
        private var _waveDrawLayer:Shape;
        private var _vector:int = 1;

        public function SoundWave() {
            if (stage) init(); 
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init( $evt:Event = null ):void 
        { 
            removeEventListener( Event.ADDED_TO_STAGE, init );
            Wonderfl.capture_delay( 30 );
            _stageWidth = stage.stageWidth;
            _stageHeight = stage.stageHeight;
            _baseHeight = _stageHeight >> 1;
            _offset = _stageWidth / DATA_PER_ENTER_FRAME;
            
            flashSoundOff();
            makeColorPalette();
            makeLayer();
            addBackGround();
            addStats();
            startMicMonitor();
        }
        
        private function flashSoundOff():void
        {
            var s:SoundTransform = SoundMixer.soundTransform;
            s.volume = 0;
            SoundMixer.soundTransform = s;
        }
        
        private function makeColorPalette():void
        {
            var i:int , rgbPart:Vector.<int> , rgb:uint , colorHsv:ColorHSV;
            
            _colorPaletteIndex = 0;
            _colorPalette = new Vector.<uint>();
            colorHsv = new ColorHSV();
            colorHsv.s = colorHsv.v = 1;
            
            for ( i = 0; i <= 360; i++ )
            {
                colorHsv.h = i;
                _colorPalette.push( colorHsv.value );
            }
            _colorPaletteLength = _colorPalette.length;
        }
        
        private function makeLayer():void
        {
            addChild( _backGroundLayer = new Shape() );
            addChild( _contentsLayer = new Sprite() );
            addChild( _statsLayer = new Sprite() );
            _contentsLayer.addChild( _bitmapLayer = new Sprite() );
            _contentsLayer.addChild( _waveDrawLayer = new Shape() );
            _waveG = _waveDrawLayer.graphics;
            _waveDrawLayer.y = _stageHeight >> 1;
        }
        
        private function addBackGround():void
        {
            var g:Graphics =  _backGroundLayer.graphics;
            g.beginFill( 0x000000 );
            g.drawRect( 0 , 0 , _stageWidth , _stageHeight );
            g.endFill();
        }
        
        private function addStats():void
        {
            _statsLayer.addChild( new Stats() );
        }
        
        private function startMicMonitor():void
        {
            _mic = Microphone.getMicrophone(); 
            _mic.rate = SAMPLEING_RATE;
            _mic.addEventListener( SampleDataEvent.SAMPLE_DATA, sampleDataHandler );
            addEventListener( Event.ENTER_FRAME , loop , false , 0 , true );
        }
        
        private function sampleDataHandler( $evt: SampleDataEvent　):void 
        { 
            var data:ByteArray = $evt.data;

            _waveData = new Vector.<Number>();
            
            while ( data.bytesAvailable )
                _waveData.push( data.readFloat() );
        }
        
        private function loop( $evt:Event ):void
        {
            drawWave( _waveData , _waveG );
            drawBitmap();
        }
        
        private function getDrawData( data:Vector.<Number> ):Vector.<Number>
        {
            if ( data.length > DATA_PER_ENTER_FRAME )
                return data.splice(0, DATA_PER_ENTER_FRAME);
            else
                return data;
        }
        
        private function drawWave( data:Vector.<Number>, g:Graphics ):void
        {
            var drawPoint:Point , i:uint , color:uint , thickness:uint;

            drawPoint = POINT;

            if ( data != null ) data = getDrawData( data );

            thickness = ( data != null )  ?  ( data[i] < 0 ? -data[i] : data[i]  ) * 10 : 1;
            color = _colorPalette[_colorPaletteIndex];
            g.clear();
            g.lineStyle( thickness , color );
            g.moveTo(0, 0);

            for ( i = 0; i < DATA_PER_ENTER_FRAME; i++ )
            {
                drawPoint.x = _offset * i;
                drawPoint.y = ( data != null ) ? data[i] * _baseHeight : 0;
                g.lineTo( drawPoint.x , drawPoint.y );
            }
            
            if ( _waveDrawLayer.y >= _baseHeight + 200 )
                _vector = -1;
            else if( _waveDrawLayer.y <= _baseHeight - 200 )
                _vector = 1;
        
            _waveDrawLayer.y += _vector;

            _colorPaletteIndex += 1;
            if ( _colorPaletteIndex >= _colorPaletteLength ) _colorPaletteIndex = 0;
        }

        private function drawBitmap():void
        {
            if ( !_isBmpStop && _colorCounter == ( _colorPaletteLength - 1 ) )
                _isBmpStop = true;

            if ( !_isBmpStop )
            {
                var bmp:Bitmap = makeNewBitmap( _stageWidth , _stageHeight , _contentsLayer );
                removeBmp();
                _bitmapLayer.addChildAt( bmp , 0 );

                _colorCounter += 1;
            }
            else
            {
                if ( !_isDeleteAnimation )
                {
                    _tweenCompleteNext = removeBmp;
                    tween( _bitmapLayer , {alpha:0} , null , 4.0 , Circ.easeOutIn );
                    _isDeleteAnimation = true;
                }
                _colorCounter = 0;
            }
        }

        private function removeBmp():void
        {
            while ( _bitmapLayer.numChildren > 0 )
                _bitmapLayer.removeChildAt( 0 );
            
            _bitmapLayer.alpha = 1;
            _isBmpStop = false;
            _isDeleteAnimation = false;
        }
        
        private function makeNewBitmap( WIDTH:Number , HEIGHT:Number , sp:Sprite ):Bitmap
        {
            var bmd:BitmapData = new BitmapData( WIDTH , HEIGHT , false , 0x00000000 );
            bmd.draw( sp );
            var bmp:Bitmap = new Bitmap( bmd );
            
            return bmp;
        }
        
        public function tween( sp:Sprite , to:Object , from:Object , time:Number , easing:* ):void
        {
            var t:IObjectTween;
            t = BetweenAS3.tween( sp , to , from , time , easing );
            t.addEventListener( TweenEvent.COMPLETE , tweenEventCompleteHandler , false , 0 , true );
            t.play();
        }
        
        private function tweenEventCompleteHandler( $evt:TweenEvent ):void
        {
            var t:IObjectTween = $evt.target as IObjectTween;
            t.removeEventListener( TweenEvent.COMPLETE , tweenEventCompleteHandler );
            if ( _tweenCompleteNext != null )
            {
                _tweenCompleteNext();
                _tweenCompleteNext = null;
            }
        }
    }
}