/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ygSU
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;

	[SWF(width=465, height=465, frameRate=15, backgroundColor=0x000000)]
	public class Peak extends Sprite {
		private const WIDTH: int = 465;
		private const HEIGHT: int = 465;

		private var data: BitmapData = new BitmapData(WIDTH, HEIGHT, false , 0);

		public function Peak() {
			stage.addEventListener(MouseEvent.CLICK, generate);
	
			generate(null);
			var screen: Bitmap = new Bitmap(data);
			addChild(screen);
		}

		public function generate(event: MouseEvent): void {
			data.lock();
			var angle: Number = -mouseY * Math.PI / 180.0;
			var xSlope: Number =  Math.sin( angle );
			var ySlope: Number = -Math.cos( angle );
			for ( var i: int = 0; i < WIDTH; i++ )
			{
				for ( var j: int = 0; j < HEIGHT; j++ )
				{
					var dx: Number = i * 2.0 / WIDTH - 1.0;
					var dy: Number = j * 2.0 / HEIGHT - 1.0;
					var radius: Number = Math.sqrt( dx * dx + dy * dy );
					if ( radius > 1.0 )
					{
						data.setPixel(i, j, 0xffffff);
					}
					else
					{
						data.setPixel(i, j, radius * 255);
					}
					/*
					var gx: Number = i / WIDTH;
					var gy: Number = j / HEIGHT;
					var value: Number = gx + gy;
					value = xSlope * ( gx - 0.5 ) + ySlope * ( gy ) + 0.5;
					if (value < 0.0) value = 0.0;
					if (value > 1.0) value = 1.0;
					var red: Number = (value > 0.49 && value < 0.51) ? 1.0 : 0.0;
					data.setPixel(i, j, value * 255 + red * 256 * 255);
					*/
				}
			}
			data.unlock();
		}
	}
}
