/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ygIv
 */

package 
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;

    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends MovieClip 
    {
        
        /* Property */
        /////////////////////////////////////////////////////////////////////////
        
//        private var page:MovieClip;
        
        private var movers:Vector.<Mover> = new Vector.<Mover>(4);
        private var mover:Sprite = new Sprite();
        private var transformer:Transformer = new Transformer();
        private var bmd:BitmapData        
        
        
        /* Main Function */
        /////////////////////////////////////////////////////////////////////////　
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
                                    
            //controlPoint
            var i:int = 0;
            for (i = 0; i < 4; i++) {
                if( i==1 ){
                    movers[i] = new Mover(true);
                    movers[i].buttonMode = true;
                    movers[i].addEventListener(Mover.MOVE, onVertexMove);
                }else{
                    movers[i] = new Mover()
                }
                mover.addChildAt(movers[i], 0);
            }
                        
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void
            {
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
            
            var loaderBG:Loader = new Loader();
            var infoBG:LoaderInfo = loaderBG.contentLoaderInfo;
            var urlBG:URLRequest = new URLRequest( "http://lab.rettuce.com/common/src/PearlGirl.jpg" );
            infoBG.addEventListener(Event.COMPLETE, function(e:Event):void{
                e.target.removeEventListener(Event.COMPLETE, arguments.callee );
                var bm:Bitmap = e.target.content;
                var bmNew:Bitmap = imgResize( bm );
                addChildAt(bmNew, 0);
            });
            loaderBG.load(urlBG, context);

            var context:LoaderContext = new LoaderContext(true);
            var loader:Loader = new Loader();
            var info:LoaderInfo = loader.contentLoaderInfo;
            var url:URLRequest = new URLRequest( "http://lab.rettuce.com/common/src/MonaLisa.jpg" );
            info.addEventListener(Event.COMPLETE, loadComp);
            loader.load(url, context);
        }

        private function loadComp(e:Event):void
        {
            e.target.removeEventListener(Event.COMPLETE, arguments.callee );
            var bm:Bitmap = e.target.content;
            var bmNew:Bitmap = imgResize( bm );
            
            var bmd:BitmapData = new BitmapData(bmNew.width,bmNew.height);
            bmd.draw(bmNew);
            setImage(bmd);
        };
        
        // 渡されたBitmapを決められた値（W,H）でリサイズして戻す
        private function imgResize(bm:Bitmap):Bitmap
        {
            var W:Number = 465;
            var H:Number = 465;
            
            var bmNew:Bitmap = new Bitmap( new BitmapData( W, H ) );
            bmNew.smoothing = true;
            
            var per:Number;
            var perW:Number = W / bm.width;
            var perH:Number = H / bm.height ;            
            per = Math.max( perW, perH );
            
            var bmX:Number = Math.floor(( W - bm.width * per ) / 2 );
            var bmY:Number = Math.floor(( H - bm.height * per ) / 2 );
            
            var mat:Matrix = new Matrix();
            mat.scale( per, per );
            mat.translate( bmX , bmY );
            bmNew.bitmapData.draw(bm , mat );
            
            return bmNew;
        }

                
        private var t:Number = 0.05;
        private var t2:Number = 0.4;
        private var trans:String = "easeInQuad";
        private var func:Function = draw;
        
        private function onVertexMove(e:MouseEvent):void
        {            
            e.target.x += e.target.mouseX
            e.target.y += e.target.mouseY                

            // 画面半分超えたら消す
            if(movers[1].x < stage.stageWidth/2 || movers[1].y > stage.stageHeight/2 ){
                movers[1].destroy();
                Tweener.addTween( movers[1], { x:-500, y:stage.stageHeight+500, time:t2, transition:trans, onUpdate:func });
                Tweener.addTween( movers[0], { x:-500, time:t2, transition:trans, onUpdate:func });
                Tweener.addTween( movers[3], { x:-500, time:t2, transition:trans, onUpdate:func });
                Tweener.addTween( movers[2], { y:stage.stageHeight+500, time:t2, transition:trans, onUpdate:func });
                Tweener.addTween( movers[3], { y:stage.stageHeight+500, time:t2, transition:trans, onUpdate:func });                
                return;
            }
                
            if( movers[1].x < movers[0].x ){
                Tweener.addTween( movers[0], { x:movers[1].x, time:t, transition:trans, onUpdate:func });
                Tweener.addTween( movers[3], { x:movers[1].x, time:t, transition:trans, onUpdate:func });
            }
            if( movers[1].y > movers[2].y ){
                Tweener.addTween( movers[2], { y:movers[1].y, time:t, transition:trans, onUpdate:func });
                Tweener.addTween( movers[3], { y:movers[1].y, time:t, transition:trans, onUpdate:func });
            }
                
            draw(e.shiftKey);
            e.updateAfterEvent();
        }
        
        
        public function setImage(img:BitmapData):void
        {
            var w:int = img.width;
            var h:int = img.height;
            var scale:Number = 1;
            var bd:BitmapData = img;
            
            var m:Matrix = new Matrix();
            m.scale(scale,scale);
            
            bmd = new BitmapData(w, h, true, 0x0);
            bmd.draw( bd,m,null,null,null,true);
            
            movers[0].x = bmd.width-120;
            movers[0].y = 0;
            movers[1].x = bmd.width;
            movers[1].y = 0;
            movers[2].x = bmd.width;
            movers[2].y = 120;
            movers[3].x = bmd.width-120;
            movers[3].y = 120;
            
            //Transformer
            addChild(transformer);
            addChild(mover);
            draw();
        }
        
        private function draw(shift:Boolean=false):void {
            transformer.draw(bmd,movers,shift)
        }        
        
        

        
        /* Stage Setting & Resize Event */
        /////////////////////////////////////////////////////////////////////////　
        
        private function setStage():void {
            stage.align = StageAlign.TOP;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {
            
        }
        
    }    
}



import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.net.FileFilter;
import flash.net.FileReference;


class Transformer extends Sprite {
    
    public var polygons:Vector.<Polygon>
    public var vertices:Vector.<Vertex>
    public function Transformer() {
    }
    
    
    public function draw(base:BitmapData, mp:Vector.<Mover>,shift:Boolean=false):void {
        
        //vertexMoversのPointを自分自身でLocal化
        var gPoint:Point
        var uv:Array=[]
        
        var x1:Number = mp[0].x/base.width;
        var y2:Number = mp[2].y/base.height;
        
        uv[0] = new Point(x1, 0);
        uv[1] = new Point(1, 0);
        uv[2] = new Point(1, y2);
        uv[3] = new Point(x1, y2);
                
        vertices = new Vector.<Vertex>();
        polygons = new Vector.<Polygon>();
        
        //20×20の頂点を用意する
        var vCounter:uint = 0
        var pCounter:uint = 0
        var leftPt:Point
        var rightPt:Point
        var leftUv:Point
        var rightUv:Point
        var tempUv:Point
        var tempPt:Point
        var vy:int
        var vx:int
        
        
        for (vy = 0; vy < 21; vy++) {
            leftPt = Point.interpolate(new Point(mp[1].x, mp[1].y), new Point(mp[2].x, mp[2].y), (1 / 20 * vy));
            rightPt = Point.interpolate(new Point(mp[0].x, mp[0].y), new Point(mp[3].x, mp[3].y), (1 / 20 * vy));
            leftUv =Point.interpolate(uv[1],uv[2], (1/20*vy));
            rightUv=Point.interpolate(uv[0],uv[3], (1/20*vy));
            
            for (vx = 0; vx < 21; vx++) {
                tempUv=Point.interpolate(leftUv,rightUv, 1-(1/20*vx));
                tempPt=Point.interpolate(leftPt,rightPt, 1-(1/20*vx));
                vertices[vCounter] = new Vertex(tempPt.x, tempPt.y, tempUv.x, tempUv.y)
                if (vx < 20 && vy < 20) {
                    polygons[pCounter] = new Polygon(vCounter, vCounter+1, vCounter+22, vCounter+21)
                    pCounter++
                }
                vCounter++
            }
        }        
        
        var points:Vector.<Number> = new Vector.<Number>()
        var indices:Vector.<int> =    new Vector.<int>()
        var uvtData:Vector.<Number> =  new Vector.<Number>
        var count:uint = vertices.length
        
        var i:uint;
        for (i = 0; i < count; i++) {
            points[i * 2] = vertices[i].x;
            points[i * 2 + 1] = vertices[i].y;
            uvtData[i * 2] = vertices[i].u;
            uvtData[i * 2 + 1] = vertices[i].v;
        }
        count = polygons.length
        for (i = 0; i < count; i++) {
            indices=indices.concat(polygons[i].indices)
        }
        
        graphics.clear();
        if (shift) {
            graphics.lineStyle(0,0x009900)
        }
        graphics.beginBitmapFill(base,null,false,true);
        
        // めくれてない部分の描画
        graphics.lineTo(mp[0].x, mp[0].y);
        graphics.lineTo(mp[3].x, mp[3].y);
        graphics.lineTo(mp[2].x, mp[2].y);
        graphics.lineTo(base.width, base.height);
        graphics.lineTo(0, base.height);
        graphics.lineTo(0, 0);

        graphics.drawTriangles(points,indices,uvtData)
        graphics.endFill();
    }
}



class Polygon {
    private var _indices:Vector.<uint>
    private var _id:uint
    public function Polygon(v0:uint,v1:uint,v2:uint,v3:uint) {
        _indices = new Vector.<uint>(4)
        _indices[0]=v0
        _indices[1]=v1
        _indices[2]=v2
        _indices[3]=v3
    }
    
    public function get id():uint {
        return _id;
    }
    
    public function set id(value:uint):void {
        _id = value;
    }
    
    public function get indices():Vector.<int> {
        var result:Vector.<int> = new Vector.<int>();
        result[0] = _indices[0];
        result[1] = _indices[1];
        result[2] = _indices[2];
        result[3] = _indices[0];
        result[4] = _indices[2];
        result[5] = _indices[3];
        
        return result;
    }
    
}

class Vertex    extends Point{
    private var _u:Number;
    private var _v:Number;
    private var _id:uint;
    private var _next:Vertex;
    public function Vertex(x:Number = 0, y:Number = 0, u:Number = 0, v:Number = 0) {
        super(x,y)
        _u = u;
        _v = v;
    }
    
    public function get u():Number { return _u; }
    
    public function set u(value:Number):void {
        _u = value;
    }
    
    public function get v():Number { return _v; }
    
    public function set v(value:Number):void {
        _v = value;
    }
    
}

class Mover extends Sprite
{
    public static const MOVE:String = 'string';
    
    public function Mover(flg:Boolean = false) {
        if(flg==true){
            graphics.beginFill(0x0000CC, 1);            
        }else{
            graphics.beginFill(0x0000CC, 0);            
        }
        graphics.drawRect( -25, -25, 50, 50)
        graphics.endFill();
        
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
    }
    
    
    private function mouseDown(e:MouseEvent):void {
        removeEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
    }
    
    
    private function mouseUp(e:MouseEvent):void {
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);
    }
    
    
    private function mouseMove(e:MouseEvent):void {
        dispatchEvent(
            new MouseEvent(MOVE,
                e.bubbles,
                e.cancelable,
                e.localX,
                e.localY,
                e.relatedObject,
                e.ctrlKey,
                e.altKey,
                e.shiftKey,
                e.buttonDown,
                e.delta));
    }
    
    public function destroy():void {
        removeEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);
    }        
    
}
