/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yg2n
 */

package {
    
    import flash.geom.Point
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private const BLOCK_SIZE:int = 6
        
        private var loader:Loader
        private var bd:BitmapData
        private var txt:TextField
        private var debug:TextField
        
        public function FlashTest() {
            // write as3 code here..
            loader = new Loader
            //loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/0/0b/0b8f/0b8f050342f835efc9a4454ebcd23b6aff0bd45b"), new LoaderContext(true))
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/0/0d/0da7/0da7e789f3ded4c25cbd056a4d5f10e24050e00f"), new LoaderContext(true))
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete)
            
            txt = new TextField
            txt.autoSize = "left"
            txt.multiline = true
            //txt.selectable = false
            txt.defaultTextFormat = new TextFormat("Consolas", 10)
            addChild(txt)
            
            addChild(debug = new TextField)
            debug.autoSize = "left"
            debug.multiline = true
        }
        
        private function loadComplete(e:Event):void {
            bd = Bitmap(loader.content).bitmapData
            txt.text = toAscii(bd)
            txt.scaleX = stage.stageWidth / txt.width
            txt.scaleY = stage.stageHeight / txt.height
        }
        
        private function toAscii(bd:BitmapData):String {
            var src:BitmapData = new BitmapData(bd.width/BLOCK_SIZE, bd.height/BLOCK_SIZE, false, 0x0)
            src.draw(bd, new Matrix(1/BLOCK_SIZE,0,0,1/BLOCK_SIZE,0,0))
            var conv:Array = [1/3,1/3,1/3,0,0, 1/3,1/3,1/3,0,0, 1/3,1/3,1/3,0,0, 0,0,0,1,0]
            src.applyFilter(src, src.rect, new Point, new ColorMatrixFilter(conv))
            
            var ascii:String = ""
            var table:String = " .,-^/lv+oaxw%@&#"
            //var table:String = ".'`,:;\-_~^i!/r*=lIj+1t>f|<()LT7vzx[]J?cYFuy}n{sok4hePEZV2XCA#a53HUpqKdb0mwDRS9OG6g$N8B&Q%@WM"
            var mapping:Vector.<String> = new Vector.<String>(256, true)
            var i:int, j:int, x:int, y:int
            
            var chunk:int = int(256 / table.length)
            var id:int = 0
            for(i=0; i<256; i++){
                mapping[i] = table.charAt(id)
                if(i != 0 && i % chunk == 0) id++
                if(id >= table.length) id = table.length - 1
            }
            
            for(i=0; i<src.height; i++){
                for(j=0; j<src.width; j++){
                    ascii += mapping[src.getPixel(j, i) & 0xFF]
                    //debug.appendText( accum.toString() + " ")
                }
                ascii += "\n"
                //debug.appendText("\n")
            }
            
            addChild(new Bitmap(src)).x = stage.stageWidth - src.width
            return ascii
        }
        
    }
    
}