/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yfcR
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    public class DragXY extends Sprite {
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        private var canvas:Canvas;
        private var targetObj:Object;
        private var proj:PerspectiveProjection;
        private var disPoint:Point;
        public function DragXY():void {
            
            //---------------------------------------------------
            // 3D表示情報を設定
            proj = root.transform.perspectiveProjection;
            // カメラ角度
            proj.fieldOfView = 35;
            // 消失点を設定（カンバス中央から）
            disPoint = new Point(100, -50); 
            proj.projectionCenter = new Point(SW/2+disPoint.x,SH/2+disPoint.y);

            //---------------------------------------------------
            // カンバスをステージ中央に配置
            canvas = new Canvas(SW,SH,disPoint);
            canvas.x = SW/2;
            canvas.y = SH/2;
            addChild(canvas);
            
            //---------------------------------------------------
            // カンバスに3Dオブジェクトを表示
            var numPoints:int = 10;
            for (var i:int = 0; i < numPoints; i++) {
                var rects:Rects = new Rects();
                rects.x = Math.random()*SW-SW/2;
                rects.y = Math.random()*SH-SH/2;
                rects.z = Math.random()*200-50;
                rects.dispVector();
                canvas.addChild(rects);
                rects.addEventListener(MouseEvent.MOUSE_DOWN, mDown);
            }
        }
        public function mDown(e:MouseEvent):void {
            targetObj = e.target;
            e.target.addEventListener(Event.ENTER_FRAME, dragStart);
            stage.addEventListener(MouseEvent.MOUSE_UP,mUp);
        }
        public function mUp(e:MouseEvent):void {
            e.target.removeEventListener(Event.ENTER_FRAME, dragStart);
            stage.removeEventListener(MouseEvent.MOUSE_UP,mUp);
        }
        private function dragStart(e:Event):void {
            // 2DのマウスXY情報をオブジェクトのXY座標値に置き換える
            var ratio:Number = (proj.focalLength+targetObj.z)/proj.focalLength;
            if (targetObj.z != 0) {
                targetObj.x  = canvas.mouseX*ratio + disPoint.x - disPoint.x*ratio;
                targetObj.y  = canvas.mouseY*ratio + disPoint.y - disPoint.y*ratio;
            } else {
                targetObj.x  = canvas.mouseX*ratio;
                targetObj.y  = canvas.mouseY*ratio;
            }
            targetObj.dispVector();
        }
    }
}
import flash.display.*;
import flash.geom.*;
import flash.text.*;
class Canvas extends Sprite {
    public function Canvas(w:Number, h:Number, p:Point):void {
        graphics.lineStyle(0,0x999999);
        // x軸
        graphics.moveTo(-w/2,0);
        graphics.lineTo(w/2,0);
        // y軸
        graphics.moveTo(0,-h/2);
        graphics.lineTo(0,h/2);
        // z軸
        graphics.moveTo(-p.x,-p.y);
        graphics.lineTo(p.x,p.y);
    }
}
class Rects extends Sprite {
    private var field:TextField;
    public function Rects(size:Number=15, nColor:int=0x0066ff):void {
        for (var i:int = 0; i < 5; i++) {
            var panel:Panel = new Panel(size,nColor);
            panel.alpha = 1-i*0.15;
            addChild(panel);
            panel.z = i*30;
        }
        field = new TextField();
        field.mouseEnabled = false;
        field.autoSize = TextFieldAutoSize.CENTER;
        field.selectable = false;
        field.text = 'temp';
        field.x = -field.width/2;
        field.y = -field.height-size/2;
        addChild(field);
    }
    // 3D座標を表示
    public function dispVector():void {
        field.text = '(x:'+roundNum(x)+', y:'+roundNum(y)+', z:'+roundNum(z)+')';
    }
    private function roundNum(num:Number):Number {
        return Math.round(num*10)/10;
    }
}
class Panel extends Shape {
    public function Panel(size:Number = 10, color:int=0):void {
        graphics.beginFill(color);
        graphics.drawRect(-size/2,-size/2,size,size)
        graphics.endFill();
    }
}