/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yfNn
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=207
    public class Euler207 extends Sprite {
        private var _tf : TextField;
  
        public function Euler207() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + solve() + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        // x=2^tと置くと、x^2=x+k
        // x=(1+√(1+4k))/2
        // xは整数なので、√(1+4k)は整数でなければならない。
        // 4k+1=(2k+1)^2-(2k)^2とピタゴラス数の生成より、
        // m>n>=1を用いて
        // m^2+n^2=2k+1, 2mn=2k と表せる。これより
        // (m-n)^2=1, m=n+1なので、
        // x=n+1, k=n(n+1)
        // よって、nをインクリメントしていって、
        // nの2進数表示の桁数/nが1/12345を下回ったときのn(n+1)の値が答え。
        private function solve() : Number
        {
            for(var n : int = 1;;n++){
                var p : Number = int(Math.log(n + 1) / Math.log(2)) / n;
//                _tf.appendText("" + p + "\n");
                
                if(p < 1 / 12345){
                    return n * (n + 1);
                }
            }
            return 0;
        }
    }
}