/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yfNX
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.layer.ViewportLayer;
    
    [SWF(frameRate="60")];
    
    public class FlashTest extends ReflectionView {
        private static const MAX_NUM:Number = 2;
        
        public function FlashTest() {
            objects = [];
            for(var i:int=0; i<MAX_NUM; i++) {
                var cube:Cube = Cube(scene.addChild(new Cube(new MaterialsList(
                    {
                     all: new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466)   
                    }
                ))));
                
                cube.x = 1000 * i - 1000 * MAX_NUM / 4;
                var cubeLayer:ViewportLayer = cube.createViewportLayer(viewportReflection);
                
                var maskSp:Shape = new Shape();
                viewportReflection.containerSprite.addChild(maskSp);
                objects[i] = {obj:cube, layer:cubeLayer, mask:maskSp};
            }
            
            surfaceHeight = -600;
            viewportReflection.alpha = .6;
            viewportReflection.filters = [new BlurFilter(8,8,1)]
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);            
        }
        private var objects:Array;
        
        protected function enterFrameHandler(event:Event):void {
            camera.y = 500 + 800 * Math.sin(getTimer() / 1000);
            singleRender();
            for(var i:int=0; i<objects.length; i++) {
                objects[i].obj.yaw(2);
                updateMask(objects[i].layer, objects[i].mask);
            }
        }
        
        private function updateMask(layer:ViewportLayer, shape:Shape):void {
            layer.mask = null;
            var rectangle:Rectangle = layer.getRect(viewportReflection.containerSprite);
            shape.graphics.clear();
            shape.x = rectangle.x;
            shape.y = rectangle.y;
            createGradation(shape.graphics, rectangle.width, rectangle.height);
            shape.cacheAsBitmap = true;
            layer.cacheAsBitmap = true;
            layer.mask = shape;
        }
        
        private function createGradation(graphics:Graphics, w:int, h:int):void {
            var type:String = GradientType.LINEAR;
            var colors:Array = [0x0, 0x0];
            var alphas:Array = [0, 1];
            var ratios:Array = [0, 255];
            var mtrx:Matrix = new Matrix();
            mtrx.createGradientBox(w, h, 0, 0, 0);
            mtrx.rotate(Math.PI / 2);
            var spread:String = SpreadMethod.PAD;
            var interpolation:String = InterpolationMethod.RGB;
            var focalPointRatio:Number = 0;
            
            graphics.beginGradientFill(type, colors, alphas, ratios, mtrx, spread, interpolation, focalPointRatio);
            graphics.drawRect(0,0,w,h);
            graphics.endFill();
        }



    }
}