/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yeLc
 */

// forked from fakestar0826's MultiSegmentReach
// forked from fakestar0826's ReachingSegment
// forked from fakestar0826's SingleSegment
package {
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var ball:Ball;
        private var g:Number = 0.9;
        private var b:Number = -.9;
        
        private var segments:Array;
        private var numSeg:int = 30;
        
        public function FlashTest() {
            // write as3 code here..
            ball = new Ball(50, 0);
            ball.vx = 10;
            
            segments = [];
            for(var i:int  = 0;i < numSeg;i++)
            {
                var seg:Segment = new Segment(10, 20);
                addChild(seg);
                segments.push(seg);
            }
            seg.x = 200;seg.y = 200;
            addChild(ball);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            moveBall();
            var target:Point = reach(segments[0], ball.x, ball.y);
            for(var i:int = 1;i < numSeg;i++)
            {
                target = reach(segments[i], target.x, target.y);
            }
            for(i = numSeg - 1;i > 0;i--)
            {
                position(segments[i - 1], segments[i]);
            }

        }
        
        private function reach(seg:Segment, xpos:Number, ypos:Number):Point
        {
            var dx:Number = xpos - seg.x;
            var dy:Number = ypos - seg.y;
            var angle:Number = Math.atan2(dy, dx);
            seg.rotation = angle * 180 / Math.PI;
            var w:Number = seg.getPin().x - seg.x;
            var h:Number = seg.getPin().y - seg.y;
            var tx:Number = xpos - w;
            var ty:Number = ypos - h;
            
            return new Point(tx, ty);
        }
        
        private function position(seg0:Segment, seg1:Segment):void
        {
            seg0.x = seg1.getPin().x;
            seg0.y = seg1.getPin().y;
        }
        
        private function moveBall():void
        {
            ball.vy += g;
            ball.x += ball.vx;
            ball.y += ball.vy;
            if(ball.x + ball.r > stage.stageWidth)
            {
                ball.x = stage.stageWidth - ball.r;
                ball.vx *= b;
            }
            else if(ball.x - ball.r < 0)
            {
                ball.x = ball.r;
                ball.vx *= b;
            }
            
            if(ball.y + ball.r > stage.stageHeight)
            {
                ball.y = stage.stageHeight - ball.r;
                ball.vy *= b;
            }
            else if(ball.y - ball.r < 0)
            {
                ball.y = ball.r;
                ball.vy *= b;
            }

        }

    }
}
import flash.geom.Point;
import flash.display.Sprite;

class Segment extends Sprite
{
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number, segmentHeight:Number, color:uint = 0xFFFFFF)
    {
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        
        graphics.lineStyle(0);
        graphics.beginFill(color);
        graphics.drawRoundRect(-segmentHeight / 2, -segmentHeight / 2, segmentWidth + segmentHeight, segmentHeight, segmentHeight, segmentHeight);
        graphics.endFill();
        
        graphics.drawCircle(0, 0, 2);
        graphics.drawCircle(segmentWidth, 0, 2);
    }
    
    public function getPin():Point
    {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos(angle) * segmentWidth;
        var yPos:Number = y + Math.sin(angle) * segmentWidth;
        
        return new Point(xPos, yPos);
    }


}

class Ball extends Sprite
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var r:Number;
    
    public function Ball(r:Number = 30, c:uint = 0xFF0000)
    {
        this.r = r;
        this.graphics.beginFill(c);
        this.graphics.drawCircle(0, 0, r);
        this.graphics.endFill();
    }

}
