/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yeE9
 */

package {
    import adobe.utils.CustomActions;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Point;
    import flash.net.*;
    import flash.system.*;

    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=45)]
    public class Main extends Sprite {
        
        public var photoBoxSp:Sprite;
        public var canvasBMD:BitmapData;
        public var photoBM:Bitmap;
        public var mapBMD:BitmapData;
        public var mapBM:Bitmap;
        public var perlinNum:Number = 0;
        public var lo:Loader;
        public var urlReq:URLRequest;
        public var W:Number = stage.stageWidth;
        public var H:Number = stage.stageHeight;

        public function Main() {
            init();
        }
        
        public function init():void {
            urlReq=new URLRequest("http://farm5.static.flickr.com/4097/4941567163_0fa5cd2938.jpg");
            var myLoaderContext:LoaderContext = new LoaderContext(true);
            lo = new Loader();
            lo.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            lo.load(urlReq,myLoaderContext);     
        }
        
        public function onComplete(e:Event):void {
            canvasBMD = new BitmapData(400,300);
            canvasBMD.draw(lo);
            photoBM = new Bitmap(canvasBMD);
            photoBoxSp = new Sprite();
            photoBoxSp.addChild(photoBM);
            addChild(photoBoxSp);
            photoBM.x = W / 2 - photoBM.width / 2;
            photoBM.y = H / 2 - photoBM.height / 2;
            stage.addEventListener(Event.ENTER_FRAME,onEnterFramer);
        }
        
        public function onEnterFramer(e:Event):void {
            perlinNum += 10;
            canvasBMD.draw(lo);
            canvasBMD.applyFilter(canvasBMD, canvasBMD.rect, new Point(0, 0), displacementMap(perlinNum, perlinNum));
            photoBM.bitmapData = canvasBMD;
        }
        
        public function displacementMap(px:Number,py:Number):DisplacementMapFilter {
            var dis:DisplacementMapFilter = new DisplacementMapFilter();
            dis.mapBitmap = perlinMap(px, py);
            var po:Point = new Point(0,0);
            dis.mapPoint = po;
            var colChannel:uint = BitmapDataChannel.RED;
            var colChannel2:uint = BitmapDataChannel.BLUE;
            dis.componentX = colChannel;
            dis.componentY = colChannel2;
            dis.scaleX = 50;
            dis.scaleY = 30;
            var modest:String = new String("color");
            dis.mode = modest;
            return dis;
        }
        
        public function perlinMap(px:Number,py:Number):BitmapData {
            var bmd:BitmapData = new BitmapData(400,300);
            var baseX:Number = 200;
            var baseY:Number = 150;
            var numOctaves:uint = 1;
            var ramdomseed:int = 1;
            var stitch:Boolean = true;
            var factalNoize:Boolean = true;
            var channelOption:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
            var grayScale:Boolean = false;
            var offsets:Array = [new Point(0,px),new Point(0,py)];
            bmd.perlinNoise(baseX, baseY, numOctaves, ramdomseed, stitch, factalNoize, channelOption, grayScale, offsets);
            return bmd;
        }
        
        
        
        
        
        

    }


}