/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ydiz
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var pd:PetriDish = new PetriDish(stage.stageWidth, stage.stageHeight);
            addChild(pd);
        }
    }
}
import flash.events.Event;
import flash.text.TextField;
import flash.events.MouseEvent;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;

Class {
    class PetriDish extends Sprite {
        private var layers:Array = [];
        private var selectedLay:int = 0;
        
        public function PetriDish(w:Number, h:Number, depth:int=5):void {
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,w,h);
            this.graphics.endFill();
            selectedLay = depth;
            for(var i:int=0; i<depth; i++){
                var lay:Sprite = new Sprite();
                lay.graphics.beginFill(0xaaaaff/depth*i);
                lay.graphics.drawRect(0,0,w,h);
                lay.graphics.endFill();
                lay.alpha = 0.3;
                var map:Bitmap = new Bitmap(new BitmapData(w/4, h/4, true, 0), 'auto', true);
                lay.addChild(map);
                map.scaleX = 4; map.scaleY = 4;
                var layer:Object = new Object();
                layer.l = lay; layer.m = map;
                layers.push(layer);
                addChild(lay);
            }
            addEventListener(MouseEvent.CLICK, drawSome);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        private function drawSome(e:MouseEvent):void{
            (layers[selectedLay-1].m as Bitmap).bitmapData.setPixel32(int(e.localX/4), int(e.localY/4), 0xffffffff);
        }
        private function loop(e:Event):void {
            for(var tx:int=0; tx<(layers[selectedLay-1].m as Bitmap).width; tx++){
                for(var ty:int=0; ty<(layers[selectedLay-1].m as Bitmap).height; ty++){
                    procedureCell(tx, ty);
                }
            }
        }
        private function procedureCell(tx:int=0, ty:int=0):void {
            if((layers[selectedLay-1].m as Bitmap).bitmapData.getPixel32(tx, ty) == 0xffffffff){
                // Сдвинем в рандомном направлении...
                (layers[selectedLay-1].m as Bitmap).bitmapData.setPixel32(tx, ty, 0);
                tx+=int(Math.random()*4-2);
                ty+=int(Math.random()*4-2);
                (layers[selectedLay-1].m as Bitmap).bitmapData.setPixel32(tx, ty, 0xffffffff);
            }
        }
    }
}





