/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ydLT
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.StageQuality;
    
    /**
     * ...
     * @author curved straight line
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private const CANVAS_WIDTH:int = stage.stageWidth;
        private const CANVAS_HEIGHT:int = stage.stageHeight;
        private const CANVAS_COLOR:uint = 0x000000;
        
        private var canvas_data:BitmapData;
        private var canvas:Bitmap;
        private var map:BitmapData = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT);
        private var movePoint1:Point = new Point(0, 0);
        private var movePoint2:Point = new Point(0, 0);
        private var origin : Point = new Point(0, 0);
        
        private var circle:Circle;
        private const CIRCLE_NUMBER:int = 10;
        private const CIRCLE_MAX_SPEED:int = 15;
        private const CIRCLE_MIN_SPEED:int = 5;
        private const CIRCLE_MAX_SIZE:int = 50;
        private const CIRCLE_MIN_SIZE:int = 6;
        private var circle_property:Array = [];
        private var point:Point = new Point();
        //private var blur:BlurFilter;
        
        private var blend:String = "screen";
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.quality = StageQuality.LOW;
            
            canvas_data = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT, false, CANVAS_COLOR);
            canvas = new Bitmap(canvas_data);
            addChild(canvas);
            
            //blur = new BlurFilter(10, 10, 1);
            
            for (var i:int = 0; i < CIRCLE_NUMBER;++i)
            {
                var cObject:Object =
                {
                    color:Math.random() * 0xff << 16 | Math.random() * 0xcc << 8 | 0xff,
                    x:Math.floor(Math.random() * CANVAS_WIDTH),
                    y:Math.floor(Math.random() * CANVAS_HEIGHT),
                    posX:Math.floor(Math.random() * CANVAS_WIDTH),
                    posY:Math.floor(Math.random() * CANVAS_HEIGHT),
                    speed:Math.floor(Math.random() * (CIRCLE_MAX_SPEED - CIRCLE_MIN_SPEED)) + CIRCLE_MIN_SPEED,
                    size:Math.floor(Math.random() * (CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)) + CIRCLE_MIN_SIZE,
                    posSize:Math.floor(Math.random() * (CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)) + CIRCLE_MIN_SIZE,
                    blurX_pow:Math.floor(Math.random() * 3) + 2,
                    blurY_pow:Math.floor(Math.random() * 3) + 2
                };
                circle_property.push(cObject);
                
            }
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            map.perlinNoise
            (
                60,
                60, 
                1, 
                6, 
                true,
                true,
                BitmapDataChannel.RED | BitmapDataChannel.GREEN,
                false,
                [movePoint1, movePoint2, movePoint1, movePoint2]
            );
            movePoint1.offset( -100, -10000);
            movePoint2.offset(1,1);
            
            var displace:DisplacementMapFilter = new DisplacementMapFilter
            (
                map, 
                origin, 
                BitmapDataChannel.RED,
                BitmapDataChannel.GREEN, 
                4,//Math.floor(Math.random() * 400), 
                3//Math.floor(Math.random() * 300)
            );
            canvas_data.applyFilter(canvas_data, canvas_data.rect, origin, displace);
            
            for (var i:int = 0; i < CIRCLE_NUMBER;++i)
            {
                var cObject:Object = circle_property[i];
                
                cObject.x += (cObject.posX - cObject.x) / cObject.speed;
                cObject.y += (cObject.posY - cObject.y) / cObject.speed;
                cObject.size += (cObject.posSize-cObject.size) / cObject.speed;
                if (Math.abs(cObject.posX - cObject.x) < 1)
                {
                    if (Math.abs(cObject.posY - cObject.y) < 1)
                    {
                        cObject.posX = Math.floor(Math.random() * CANVAS_WIDTH);
                        cObject.posY = Math.floor(Math.random() * CANVAS_HEIGHT);
                        cObject.speed = Math.floor(Math.random() * (CIRCLE_MAX_SPEED - CIRCLE_MIN_SPEED)) + CIRCLE_MIN_SPEED;
                        cObject.posSize = Math.floor(Math.random() * (CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)) + CIRCLE_MIN_SIZE;
                    }
                }
                
                var blur:BlurFilter = new BlurFilter
                (
                    1,//Math.pow(2, cObject.blurX_pow),
                    1,//Math.pow(2, cObject.blurY_pow),
                    1
                );
                circle = new Circle(cObject.color, cObject.x, cObject.y, cObject.size);
                canvas_data.applyFilter(canvas_data, canvas_data.rect, point, blur);
                canvas_data.lock();
                canvas_data.draw
                (
                    circle,
                    null,
                    null,
                    blend,
                    null,
                    false
                );
                canvas_data.unlock();
                //canvas_data.setPixel(cObject.x, cObject.y, cObject.color);
            }
        }
    }
}

import flash.display.Shape;
import flash.display.Sprite;
class Circle extends Sprite
{
    private var c:Shape;
    private var COLOR:uint;
    private var X:int;
    private var Y:int;
    private var SIZE:int;
    public function Circle(color:uint,x:int,y:int,size:int):void
    {
        COLOR = color;
        X = x;
        Y = y;
        SIZE = size;
        create();
    }
    public function create():void
    {
        c = new Shape();
        c.graphics.lineStyle(4, COLOR, 1);
        //c.graphics.beginFill(COLOR, 1);
        c.graphics.drawCircle(X, Y, SIZE);
        c.graphics.endFill();
        this.addChild(c);
    }
}