/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ydHs
 */

// forked from lizhi's flash on 2011-9-17
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author lizhi
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class TestParticle extends Sprite 
    {
        private var first:Particle;
        private var w:int;
        private var h:int;
        private var vbmp:BitmapData;
        private var canvas:Shape = new Shape;
        private var offsets:Array = [new Point,new Point];
        public function TestParticle() 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            vbmp = new BitmapData(w, h, false, 0x123456);
            addChild(new Bitmap(vbmp));
            
            addChild(canvas);
            var c:int = 2000;
            var last:Particle;
            while (c-->0) {
                var p:Particle = new Particle;
                p.x = w * Math.random();
                p.y = h * Math.random();
                p.vx = 0;
                p.vy = 0;
                if (first == null) first = p;
                else last.next = p;
                last = p;
            }
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void 
        {
            offsets[0].x -= 1;//(mouseX - w / 2)/10;
            //offsets[1].y -= (mouseY - h / 2)/10;
            vbmp.perlinNoise(100, 100, 2, 1, true, true, 7, true,offsets);
            var graphics:Graphics = canvas.graphics;
            var p:Particle = first;
            graphics.clear();
            while (p != null) {
                var left:uint = vbmp.getPixel(p.x - 1, p.y)&0xff;
                var right:uint = vbmp.getPixel(p.x + 1, p.y) & 0xff;
                var top:uint = vbmp.getPixel(p.x, p.y-1)&0xff;
                var bottom:uint = vbmp.getPixel(p.x, p.y+1)&0xff;
                var s:Number = 0.02;
                p.vx += (right - left) * s;
                p.vy += (bottom - top) * s;
                p.vx *= 0.99;
                p.vy *= 0.99;
                p.x += p.vx;
                p.y += p.vy;
                var a:Number = Math.atan2(p.vy, p.vx);
                var x0:Number = p.x+3 * Math.cos(a);
                var y0:Number = p.y+3 * Math.sin(a);
                var x1:Number = p.x+3 * Math.cos(a+Math.PI+0.5);
                var y1:Number = p.y+3 * Math.sin(a+Math.PI+0.5);
                var x2:Number = p.x+3 * Math.cos(a+Math.PI-0.5);
                var y2:Number = p.y + 3 * Math.sin(a + Math.PI - 0.5);
                
                graphics.beginFill(0);
                graphics.moveTo(x0, y0);
                graphics.lineTo(x1, y1);
                graphics.lineTo(x2, y2);
                graphics.lineTo(x0, y0);
                graphics.endFill();
                /*graphics.beginFill(0);
                graphics.drawCircle(p.x, p.y, 1);
                graphics.endFill();*/
                if (p.x < 0 || p.y < 0 || p.x > w || p.y > h) {
                    p.vx = 0;
                    p.vy = 0;
                    p.x = w * Math.random();
                    p.y = h * Math.random();
                }
                p = p.next;
            }
        }
        
    }

}
class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var next:Particle;
}