/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ycX87
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
			stage.frameRate = 60;
			
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			for (var index:uint = 0; index < 500; ++index) {
				var r:uint = 192 + (64 * Math.random());
				var g:uint = 192 + (64 * Math.random());
				var b:uint = 192 + (64 * Math.random());
				var color:uint = (r << 16) + (g << 8) + (b << 0);
				var radius:Number = Math.random() * 300 + 5;
				var size:Number = radius * (Math.random() * 0.25);
				var rotate:Number = Math.random() * Math.PI * 2;
				var frame:uint = Math.random() * 90 + 30;
				var star:Star = new Star(color, size, radius, rotate, frame);
				this.addChild(star);
			}
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

class Star extends Sprite
{
	private var _prevPos:Array;
	
	private var _radius:Number;
	private var _rotate:Number;
	private var _frame:uint;
	
	public function Star(color:uint, size:Number, radius:Number, rotate:Number, frame:uint) {
		_radius = radius;
		_rotate = rotate;
		_frame = frame;
		
		this.graphics.beginFill(color);
		this.graphics.drawCircle(0, 0, size);
		this.graphics.endFill();

		this.addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function update(e:Event):void {
		
		_rotate += (Math.PI * 2) / _frame;

		this.x = 232.5 + (Math.cos(_rotate) * _radius);
		this.y = 232.5 + (Math.sin(_rotate) * _radius);
		
		return;
	}
}